/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfig;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfigDTO;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.dto.CampoCadastroGeralDTO;
import br.com.elotech.tributos.calculo.dto.CampoCadastroImobiliarioDTO;
import br.com.elotech.tributos.calculo.dto.CampoCadastroMobiliarioDTO;
import br.com.elotech.tributos.calculo.dto.CampoCidadeDTO;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.camposdinamicos.GrupoCampoService;
import br.com.elotech.tributos.util.AutoCompleteDetailUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ArquivoGraficaConfigService
extends CrudService<ArquivoGraficaConfig, Long> {
    private final ParametroGeralService parametroGeralService;
    private final GrupoCampoService grupoCampoService;

    public ArquivoGraficaConfigService(ParametroGeralService parametroGeralService, GrupoCampoService grupoCampoService) {
        this.parametroGeralService = parametroGeralService;
        this.grupoCampoService = grupoCampoService;
    }

    protected void beforeSave(ArquivoGraficaConfig arquivoGraficaConfig, Authentication authentication) {
        arquivoGraficaConfig.getCampos().forEach(arquivoGraficaConfigCampo -> {
            if (Objects.isNull(arquivoGraficaConfigCampo.getArquivoGraficaConfig())) {
                arquivoGraficaConfigCampo.setArquivoGraficaConfig(arquivoGraficaConfig);
            }
        });
        super.beforeSave((EloEntity)arquivoGraficaConfig, authentication);
    }

    public ArquivoGraficaConfigDTO loadDTO(Long id) {
        ArquivoGraficaConfig arquivoGraficaConfig = (ArquivoGraficaConfig)this.findById((Serializable)id).orElseThrow(RestException::notFound);
        List campoDetalheDisponiveis = this.searchCampos(arquivoGraficaConfig.getTipoDivida(), null);
        return ArquivoGraficaConfigDTO.from((ArquivoGraficaConfig)arquivoGraficaConfig, (List)campoDetalheDisponiveis);
    }

    public ArquivoGraficaConfigDTO saveDTO(ArquivoGraficaConfigDTO dto) {
        ArquivoGraficaConfig arquivoGraficaConfigToSave = Optional.ofNullable(dto.getId()).map(value -> Optional.ofNullable((ArquivoGraficaConfig)this.findOne((Serializable)value)).map(config -> config.merge(dto.toEntity())).orElseThrow(RestException::notFound)).orElse(dto.toEntity());
        return this.loadDTO(((ArquivoGraficaConfig)this.save((EloEntity)arquivoGraficaConfigToSave, null)).getId());
    }

    public void delete(Long id) {
        ArquivoGraficaConfig entity = Optional.ofNullable((ArquivoGraficaConfig)this.findOne((Serializable)id)).orElseThrow(RestException::notFound);
        this.delete((EloEntity)entity, null);
    }

    public List<CampoDetalheDTO> searchCampos(TipoDivida tipoDivida, String search) {
        ArrayList<CampoDetalheDTO> campos = new ArrayList<CampoDetalheDTO>();
        campos.addAll(this.getCamposFixos(tipoDivida));
        campos.addAll(this.getCamposDinamicos(tipoDivida));
        if (StringUtils.isNotBlank((CharSequence)search)) {
            return campos.stream().filter(item -> item.getTabela().toLowerCase().contains(search.toLowerCase()) || item.getNome().toLowerCase().contains(search.toLowerCase())).collect(Collectors.toList());
        }
        return campos;
    }

    private List<CampoDetalheDTO> getCamposFixos(TipoDivida tipoDivida) {
        ArrayList<CampoDetalheDTO> result = new ArrayList<CampoDetalheDTO>();
        result.addAll(AutoCompleteDetailUtils.getCamposFromAnnotation(CampoCidadeDTO.class));
        result.addAll(AutoCompleteDetailUtils.getCamposFromAnnotation(CampoCadastroGeralDTO.class));
        if (TipoCadastro.IMOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida))) {
            result.addAll(AutoCompleteDetailUtils.getCamposFromAnnotation(CampoCadastroImobiliarioDTO.class));
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida))) {
            result.addAll(AutoCompleteDetailUtils.getCamposFromAnnotation(CampoCadastroMobiliarioDTO.class));
        }
        return result;
    }

    private List<CampoDetalheDTO> getCamposDinamicos(TipoDivida tipoDivida) {
        ArrayList<CampoDetalheDTO> result = new ArrayList<CampoDetalheDTO>();
        if (TipoCadastro.IMOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida))) {
            Boolean utilizaBoletimLogradouro = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_BOLETIM_LOGRADOURO);
            if (Objects.isNull(utilizaBoletimLogradouro)) {
                throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar o par\u00e2metro Utiliza Boletim Logradouro");
            }
            ArrayList<FuncionalidadeCampo> funcionalidades = new ArrayList<FuncionalidadeCampo>();
            funcionalidades.add(FuncionalidadeCampo.TERRENO);
            if (Boolean.TRUE.equals(utilizaBoletimLogradouro)) {
                funcionalidades.add(FuncionalidadeCampo.LOGRADOURO);
            }
            result.addAll(this.grupoCampoService.getCamposByFuncionalidade(funcionalidades));
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida))) {
            result.addAll(this.grupoCampoService.getCamposByFuncionalidade(Collections.singletonList(FuncionalidadeCampo.MOBILIARIO)));
        }
        return result;
    }
}

