select distinct
       :idPessoa as idPessoa,
       filtro.nratualizacao, 
       filtro.nranoatualizacao, 
       tid.nrdivida, 
       tid.nranodivida, 
       ca.idtce as cdControleLeiAto, 
       filtro.idtipoatualizacaocredito, 
       filtro.dtatualizacao, 
       filtro.vlatualizacao 
from 
( 
   select tam.nratualizacao, 
          tam.nranoatualizacao, 
          tam.idtipoatualizacaocredito, 
          tam.dtatualizacao, 
          tam.vlatualizacao, 
          coalesce(coalesce(tgr.entidade, tgrc.entidade), tgrco.entidade) as entidade, 
          coalesce(coalesce(tgr.fundamentolegal, tgrc.fundamentolegal), tgrco.fundamentolegal) as fundamentoLegal, 
          coalesce(coalesce(tpd.iddebitoparcelareceita, tcci.iddebitoparcelareceita), tdpro.iddebitoparcelareceita) as iddebitoparcelareceita 
   from tceAtualizaMoneCredDA            tam 
   /*Pagamento*/ 
   left join tceAtualizaMonePagamentoDA  tamp  on tamp.idtceatualizamonecredDA = tam.idtceatualizamonecredDA 
   left join tribpagamentodebito         tpd   on tpd.idpagamentobloqueto = tamp.idpagamentobloqueto and tpd.iddebitoparcelareceita = tamp.iddebitoparcelareceita 
   left join tribpagamentobloqueto       tpb   on tpb.idpagamentobloqueto  = tpd.idpagamentobloqueto 
   left join tribdebitoparcelareceita    tdpr  on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
   left join tribguiarecolhimento        tgr   on tgr.entidade = tdpr.entidade and tgr.exercicio = tdpr.exercicio 
                                              and tgr.guiarecolhimento = tdpr.guiarecolhimento 
   /*Crdito*/ 
   left join tceAtualizaMoneCreditoDA    tamc  on tamc.idtceatualizamonecredDA = tam.idtceatualizamonecredDA 
   left join tribcreditocontribuinteitem tcci  on tcci.idcreditocontribuinteitem = tamc.idcreditocontribuinteitem and tcci.iddebitoparcelareceita = tamc.iddebitoparcelareceita 
   left join tribcreditocontribuinte     tcc   on tcc.entidade = tcci.entidade and tcc.exercicio = tcci.exercicio and tcc.creditocontribuinte = tcci.creditocontribuinte 
   left join tribdebitoparcelareceita    tdprc on tdprc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
   left join tribguiarecolhimento        tgrc  on tgrc.entidade = tdprc.entidade and tgrc.exercicio = tdprc.exercicio 
                                              and tgrc.guiarecolhimento = tdprc.guiarecolhimento 
   /*Parcelamento*/ 
   left join tceAtualizaMoneParcDA         tparc on tparc.idtceatualizamonecredDA = tam.idtceatualizamonecredDA 
   left join tribParcelamentoParcRecOrigem tppro on tppro.idparcelamento = tparc.idparcelamento and tppro.iddebitoparcelareceita = tparc.iddebitoparcelareceita 
   left join tribdebitoparcelareceita      tdpro on tdpro.iddebitoparcelareceita = tppro.iddebitoparcelareceita 
   left join tribguiarecolhimento          tgrco on tgrco.entidade = tdpro.entidade and tgrco.exercicio = tdpro.exercicio 
                                              and tgrco.guiarecolhimento = tdpro.guiarecolhimento 
   where tam.dtatualizacao between :dataInicial and :dataFinal 
     and coalesce(coalesce(tpb.entidade, tcc.entidade), tdpro.entidade) = :entidade 
   order by tam.nratualizacao, tam.nranoatualizacao 
) as filtro 
left join tceDebitoInscCreditoDA tdic on tdic.iddebitoparcelareceitadestino = filtro.iddebitoparcelareceita 
left join tceInscCreditoDA       tid  on tid.idTceInscCreditoDA = tdic.idTceInscCreditoDA 
left join cgato                  ca   on ca.entidade = filtro.entidade and ca.idato = filtro.fundamentolegal