SELECT :idPessoa AS idPessoa,
       filtro.nrAnoEstorno,
       filtro.nrAtualizacao,
       filtro.nrAnoAtualizacao,
       filtro.cdControleLeiAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo
FROM (SELECT extract(YEAR FROM tep.data)                               AS nrAnoEstorno,
             tamc.nrAtualizacao,
             tamc.nrAnoAtualizacao,
             extract(MONTH FROM tep.data)                              AS nrMes,
             extract(YEAR FROM tep.data)                               AS nrAno,
             ca.idato                                                  AS cdControleLeiAto,
             tep.data                                                  AS dtEstorno,
             tpd.valorjuros                                            AS vlEstorno,
             substr(tmd.descricao || '.' || tep.motivoestorno, 0, 250) AS dsMotivo
      FROM tribestornopagamento tep
               JOIN tribestornopagamentoitem tepi ON tepi.entidade = tep.entidade AND
                                                     tepi.exercicio = tep.exercicio AND
                                                     tepi.estorno = tep.estorno
               JOIN tribpagamentodebito tpd ON tpd.idpagamentobloqueto = tepi.idpagamentobloqueto AND
                                               tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               JOIN tceAtualizaMonePagamento tamp ON tamp.idpagamentobloqueto = tepi.idpagamentobloqueto AND
                                                     tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               JOIN tceAtualizaMoneCred tamc ON tamc.idtceatualizamonecred = tamp.idtceatualizamonecred
               LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tep.motivodesconto
               LEFT JOIN cgato ca ON ca.entidade = tep.entidade AND ca.idato = tmd.idato
      WHERE tep.entidade = :entidade
        AND tep.data BETWEEN :dataInicial AND :dataFinal
        AND tep.geracreditocontribuinte = 'N'
        AND tpd.estorno = 'S'
        AND tpd.valorjuros > 0
        AND tamc.idtipoatualizacaocredito = 1
      UNION ALL
      SELECT extract(YEAR FROM tep.data)                               AS nrAnoEstorno,
             tamc.nrAtualizacao,
             tamc.nrAnoAtualizacao,
             extract(MONTH FROM tep.data)                              AS nrMes,
             extract(YEAR FROM tep.data)                               AS nrAno,
             ca.idato                                                  AS cdControleLeiAto,
             tep.data                                                  AS dtEstorno,
             tpd.valormulta                                            AS vlEstorno,
             substr(tmd.descricao || '.' || tep.motivoestorno, 0, 250) AS dsMotivo
      FROM tribestornopagamento tep
               INNER JOIN tribestornopagamentoitem tepi ON tepi.entidade = tep.entidade AND
                                                           tepi.exercicio = tep.exercicio AND
                                                           tepi.estorno = tep.estorno
               INNER JOIN tribpagamentodebito tpd ON tpd.idpagamentobloqueto = tepi.idpagamentobloqueto AND
                                                     tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               INNER JOIN tceAtualizaMonePagamento tamp ON tamp.idpagamentobloqueto = tepi.idpagamentobloqueto AND
                                                           tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               INNER JOIN tceAtualizaMoneCred tamc ON tamc.idtceatualizamonecred = tamp.idtceatualizamonecred
               LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tep.motivodesconto
               LEFT JOIN cgato ca ON ca.entidade = tep.entidade AND ca.idato = tmd.idato
      WHERE tep.entidade = :entidade
        AND tep.data BETWEEN :dataInicial AND :dataFinal
        AND tep.geracreditocontribuinte = 'N'
        AND tpd.estorno = 'S'
        AND tpd.valormulta > 0
        AND tamc.idtipoatualizacaocredito = 2
      UNION ALL
      SELECT extract(YEAR FROM tep.data)                               AS nrAnoEstorno,
             tamc.nrAtualizacao,
             tamc.nrAnoAtualizacao,
             extract(MONTH FROM tep.data)                              AS nrMes,
             extract(YEAR FROM tep.data)                               AS nrAno,
             ca.idato                                                  AS cdControleLeiAto,
             tep.data                                                  AS dtEstorno,
             tpd.valorcorrecao                                         AS vlEstorno,
             substr(tmd.descricao || '.' || tep.motivoestorno, 0, 250) AS dsMotivo
      FROM tribestornopagamento tep
               JOIN tribestornopagamentoitem tepi ON tepi.entidade = tep.entidade AND
                                                     tepi.exercicio = tep.exercicio AND
                                                     tepi.estorno = tep.estorno
               JOIN tribpagamentodebito tpd ON tpd.idpagamentobloqueto = tepi.idpagamentobloqueto AND
                                               tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               JOIN tceAtualizaMonePagamento tamp ON tamp.idpagamentobloqueto = tepi.idpagamentobloqueto AND
                                                     tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               JOIN tceAtualizaMoneCred tamc ON tamc.idtceatualizamonecred = tamp.idtceatualizamonecred
               LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tep.motivodesconto
               LEFT JOIN cgato ca ON ca.entidade = tep.entidade AND ca.idato = tmd.idato
      WHERE tep.entidade = :entidade
        AND tep.data BETWEEN :dataInicial AND :dataFinal
        AND tep.geracreditocontribuinte = 'N'
        AND tpd.estorno = 'S'
        AND tpd.valorcorrecao > 0
        AND tamc.idtipoatualizacaocredito = 3
      UNION ALL
      SELECT extract(YEAR FROM tcc.dataestorno)                                 AS nrAnoEstorno,
             tamc.nrAtualizacao,
             tamc.nrAnoAtualizacao,
             extract(MONTH FROM tcc.dataestorno)                                 AS nrMes,
             extract(YEAR FROM tcc.dataestorno)                                 AS nrAno,
             ca.idato                                                      AS cdControleLeiAto,
             tcc.dataestorno                                               AS dtEstorno,
             tcci.valorjuros                                               AS vlEstorno,
             substr(tmd.descricao || '.' || tcc.observacaoestorno, 0, 250) AS dsMotivo
      FROM tribcreditocontribuinte tcc
               JOIN tribCreditoContribuinteItem tcci ON tcci.entidade = tcc.entidade AND tcci.exercicio = tcc.exercicio AND tcci.creditocontribuinte = tcc.creditocontribuinte
               JOIN tceAtualizaMoneCredito tamcc ON tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem AND tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               JOIN tceAtualizaMoneCred tamc ON tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred
               LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tcc.motivodescontoestorno
               LEFT JOIN cgato ca ON ca.entidade = tcc.entidade AND ca.idato = tmd.idato
      WHERE tcc.entidade = :entidade
        AND tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
        AND tcci.valorjuros > 0
        AND tamc.idtipoatualizacaocredito = 1
      UNION ALL
      SELECT extract(YEAR FROM tcc.dataestorno)                            AS nrAnoEstorno,
             tamc.nrAtualizacao,
             tamc.nrAnoAtualizacao,
             extract(MONTH FROM tcc.dataestorno)                           AS nrMes,
             extract(YEAR FROM tcc.dataestorno)                            AS nrAno,
             ca.idato                                                      AS cdControleLeiAto,
             tcc.dataestorno                                               AS dtEstorno,
             tcci.valormulta                                               AS vlEstorno,
             substr(tmd.descricao || '.' || tcc.observacaoestorno, 0, 250) AS dsMotivo
      FROM tribcreditocontribuinte tcc
               JOIN tribCreditoContribuinteItem tcci ON tcci.entidade = tcc.entidade AND
                                                        tcci.exercicio = tcc.exercicio AND
                                                        tcci.creditocontribuinte = tcc.creditocontribuinte
               JOIN tceAtualizaMoneCredito tamcc ON tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem AND
                                                    tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               JOIN tceAtualizaMoneCred tamc ON tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred
               LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tcc.motivodescontoestorno
               LEFT JOIN cgato ca ON ca.entidade = tcc.entidade AND
                                     ca.idato = tmd.idato
      WHERE tcc.entidade = :entidade
        AND tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
        AND tcci.valormulta > 0
        AND tamc.idtipoatualizacaocredito = 2
      UNION ALL
      SELECT extract(YEAR FROM tcc.dataestorno)                            AS nrAnoEstorno,
             tamc.nrAtualizacao,
             tamc.nrAnoAtualizacao,
             extract(MONTH FROM tcc.dataestorno)                           AS nrMes,
             extract(YEAR FROM tcc.dataestorno)                            AS nrAno,
             ca.idato                                                      AS cdControleLeiAto,
             tcc.dataestorno                                               AS dtEstorno,
             tcci.valorcorrecao                                            AS vlEstorno,
             substr(tmd.descricao || '.' || tcc.observacaoestorno, 0, 250) AS dsMotivo
      FROM tribcreditocontribuinte tcc
               JOIN tribCreditoContribuinteItem tcci
                    ON tcci.entidade = tcc.entidade AND tcci.exercicio = tcc.exercicio AND
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               JOIN tceAtualizaMoneCredito tamcc ON tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem AND
                                                    tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               JOIN tceAtualizaMoneCred tamc ON tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred
               LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tcc.motivodescontoestorno
               LEFT JOIN cgato ca ON ca.entidade = tcc.entidade AND ca.idato = tmd.idato
      WHERE tcc.entidade = :entidade
        AND tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
        AND tcci.valorcorrecao > 0
        AND tamc.idtipoatualizacaocredito = 3
      union all
      select distinct extract(year from tep.dataestorno)                  as nrAnoEstorno,
                      tamc.nrAtualizacao,
                      tamc.nrAnoAtualizacao,
                      extract(month from tep.dataestorno)                 as nrMes,
                      extract(year from tep.dataestorno)                  as nrAno,
                      ca.idato                                            as cdControleLeiAto,
                      tep.dataestorno                                     as dtEstorno,
                      tdpr.valor                                          as vlEstorno,
                      substr(tmd.descricao || '. ' || tep.motivo, 0, 250) as dsMotivo
      from tribestornoparcelamento tep
               inner join tribparcelamento tpar on tpar.idparcelamento = tep.idparcelamento
               inner join tribParcelamentoParcRecOrigem tppro on tppro.idparcelamento = tpar.idparcelamento
               inner join tribestparcelamparcrecdestino tepd
                          on tepd.iddebitoparcelareceita = tppro.iddebitoparcelareceita and
                             tepd.idestornoparcelamento = tep.idestornoparcelamento
               inner join tceAtualizaMoneParc tamp on tamp.idparcelamento = tppro.idparcelamento and
                                                      tamp.iddebitoparcelareceita = tppro.iddebitoparcelareceita
               inner join tceAtualizaMoneCred tamc on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred
               inner join tribparcelamentodebitoorigem tpdo on tpdo.idparcelamento = tep.idparcelamento
               inner join tribdebito td on td.iddebito = tpdo.iddebitonovo
               inner join tribdebitoparcela tdp on tdp.entidade = td.entidade and
                                                   tdp.exercicio = td.exercicio and
                                                   tdp.tipocadastro = td.tipocadastro and
                                                   tdp.cadastrogeral = td.cadastrogeral and
                                                   tdp.guiarecolhimento = td.guiarecolhimento and
                                                   tdp.subdivida = td.subdivida
               inner join tribdebitoparcelareceita tdpr on tdpr.entidade = tdp.entidade and
                                                           tdpr.exercicio = tdp.exercicio and
                                                           tdpr.tipocadastro = tdp.tipocadastro and
                                                           tdpr.cadastrogeral = tdp.cadastrogeral and
                                                           tdpr.guiarecolhimento = tdp.guiarecolhimento and
                                                           tdpr.subdivida = tdp.subdivida and
                                                           tdpr.parcela = tdp.parcela
               inner join tribreceita tr
                          on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
               left join tribparamparcelamento tpp on tpp.idparametroparcelamento = tpar.idparametroparcelamento
               left join tribmotivodesconto tmd on tmd.motivodesconto = tpp.motivoestorno
               left join cgato ca on ca.entidade = tmd.entidade and ca.idato = tmd.idato
      WHERE tdpr.entidade = :entidade
        and tep.dataestorno BETWEEN :dataInicial AND :dataFinal
        and tep.estornado = 'N'
        and ((tr.classificacao = 'J' and tamc.idtipoatualizacaocredito = 1) or
             (tr.classificacao = 'M' and tamc.idtipoatualizacaocredito = 2) or
             (tr.classificacao = 'C' and tamc.idtipoatualizacaocredito = 3))
     ) filtro
ORDER BY filtro.nrAnoAtualizacao,
         filtro.nrAtualizacao