SELECT filtro.idTipoAtualizacaoCredito,
       filtro.dtAtualizacao,
       filtro.nrcredito,
       filtro.nranocredito,
       filtro.idpagamentobloqueto,
       filtro.iddebitoparcelareceita,
       filtro.idCreditoContribuinteItem,
       filtro.vlAtualizacao,
       filtro.cdControleLeiAto
FROM
  (SELECT 1 AS idTipoAtualizacaoCredito,
          tpd.valorjuros AS vlAtualizacao,
          tpd.idpagamentobloqueto,
          tpd.iddebitoparcelareceita,
          0 AS idCreditoContribuinteItem,
          tp.datapagamento AS dtAtualizacao,
          tlc.nrcredito,
          tlc.nranocredito,
          ato.idtce as cdControleLeiAto
   FROM tribpagamento tp
   JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade
   AND tpb.exerciciopagamento = tp.exerciciopagamento
   AND tpb.pagamento = tp.pagamento
   JOIN tribpagamentodebito tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
   AND tpd.valorjuros > 0
   AND tpd.situacaolegal = 0
   AND tpd.valorpago > 0
   JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
   JOIN tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   JOIN tribguiarecolhimento tgr on tdpr.entidade = tgr.entidade
                                        and tdpr.exercicio = tgr.exercicio
                                        and tgr.guiarecolhimento = tdpr.guiarecolhimento
   LEFT JOIN cgato ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
WHERE tp.entidade = :entidade
     AND tp.datapagamento BETWEEN :dataInicial AND :dataFinal
     AND NOT EXISTS
       (SELECT 1
        FROM tceAtualizaMonePagamento tamp
        WHERE tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
          AND tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita )
   UNION ALL SELECT 2 AS idTipoAtualizacaoCredito,
                    tpd.valormulta AS vlAtualizacao,
                    tpd.idpagamentobloqueto,
                    tpd.iddebitoparcelareceita,
                    0 AS idCreditoContribuinteItem,
                    tp.datapagamento AS dtAtualizacao,
                    tlc.nrcredito,
                    tlc.nranocredito,
                    ato.idtce as cdControleLeiAto
   FROM tribpagamento tp
   JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade
   AND tpb.exerciciopagamento = tp.exerciciopagamento
   AND tpb.pagamento = tp.pagamento
   JOIN tribpagamentodebito tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
   AND tpd.valormulta > 0
   AND tpd.situacaolegal = 0
   AND tpd.valorpago > 0
   JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
   JOIN tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   JOIN tribguiarecolhimento tgr on tdpr.entidade = tgr.entidade
       and tdpr.exercicio = tgr.exercicio
       and tgr.guiarecolhimento = tdpr.guiarecolhimento
   LEFT JOIN cgato ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
WHERE tp.entidade = :entidade
     AND tp.datapagamento BETWEEN :dataInicial AND :dataFinal
     AND NOT EXISTS
       (SELECT 1
        FROM tceAtualizaMonePagamento tamp
        WHERE tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
          AND tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita )
   UNION ALL SELECT 3 AS idTipoAtualizacaoCredito,
                    tpd.valorcorrecao AS vlAtualizacao,
                    tpd.idpagamentobloqueto,
                    tpd.iddebitoparcelareceita,
                    0 AS idCreditoContribuinteItem,
                    tp.datapagamento AS dtAtualizacao,
                    tlc.nrcredito,
                    tlc.nranocredito,
                    ato.idtce as cdControleLeiAto
   FROM tribpagamento tp
   JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade
   AND tpb.exerciciopagamento = tp.exerciciopagamento
   AND tpb.pagamento = tp.pagamento
   JOIN tribpagamentodebito tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
   AND tpd.valorcorrecao > 0
   AND tpd.situacaolegal = 0
   AND tpd.valorpago > 0
   JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
   JOIN tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   JOIN tribguiarecolhimento tgr on tdpr.entidade = tgr.entidade
       and tdpr.exercicio = tgr.exercicio
       and tgr.guiarecolhimento = tdpr.guiarecolhimento
   LEFT JOIN cgato ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
WHERE tp.entidade = :entidade
     AND tp.datapagamento BETWEEN :dataInicial AND :dataFinal
     AND NOT EXISTS
       (SELECT 1
        FROM tceAtualizaMonePagamento tamp
        WHERE tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
          AND tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita )
   UNION ALL SELECT 1 AS idTipoAtualizacaoCredito,
                    tcci.valorjuros AS vlAtualizacao,
                    0 AS idpagamentobloqueto,
                    tcci.iddebitoparcelareceita,
                    tcci.idcreditocontribuinteitem,
                    tcc.datacredito AS dtAtualizacao,
                    tlc.nrcredito,
                    tlc.nranocredito,
                    ato.idtce as cdControleLeiAto
   FROM tribcreditocontribuinte tcc
   JOIN tribcreditocontribuinteitem tcci ON tcci.entidade = tcc.entidade
   AND tcci.exercicio = tcc.exercicio
   AND tcci.creditocontribuinte = tcc.creditocontribuinte
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade
   AND tdp.exercicio = tdpr.exercicio
   AND tdp.tipocadastro = tdpr.tipocadastro
   AND tdp.cadastrogeral = tdpr.cadastrogeral
   AND tdp.guiarecolhimento = tdpr.guiarecolhimento
   AND tdp.subdivida = tdpr.subdivida
   AND tdp.parcela = tdpr.parcela
   JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
   JOIN tribguiarecolhimento tgr on tdpr.entidade = tgr.entidade
       and tdpr.exercicio = tgr.exercicio
       and tgr.guiarecolhimento = tdpr.guiarecolhimento
   LEFT JOIN cgato ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
WHERE tcc.entidade = :entidade
     AND tcc.datacredito BETWEEN :dataInicial AND :dataFinal
     AND tcci.valorjuros > 0
     AND tcci.valorprincipal > 0
     AND tdp.situacaolegal = 0
     AND NOT EXISTS
       (SELECT 1
        FROM tceatualizamonecredito tamc
        WHERE tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
          AND tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita )
   UNION ALL SELECT 2 AS idTipoAtualizacaoCredito,
                    tcci.valormulta AS vlAtualizacao,
                    0 AS idpagamentobloqueto,
                    tcci.iddebitoparcelareceita,
                    tcci.idcreditocontribuinteitem,
                    tcc.datacredito AS dtAtualizacao,
                    tlc.nrcredito,
                    tlc.nranocredito,
                    ato.idtce as cdControleLeiAto
   FROM tribcreditocontribuinte tcc
   JOIN tribcreditocontribuinteitem tcci ON tcci.entidade = tcc.entidade
   AND tcci.exercicio = tcc.exercicio
   AND tcci.creditocontribuinte = tcc.creditocontribuinte
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade
   AND tdp.exercicio = tdpr.exercicio
   AND tdp.tipocadastro = tdpr.tipocadastro
   AND tdp.cadastrogeral = tdpr.cadastrogeral
   AND tdp.guiarecolhimento = tdpr.guiarecolhimento
   AND tdp.subdivida = tdpr.subdivida
   AND tdp.parcela = tdpr.parcela
   JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
   JOIN tribguiarecolhimento tgr on tdpr.entidade = tgr.entidade
       and tdpr.exercicio = tgr.exercicio
       and tgr.guiarecolhimento = tdpr.guiarecolhimento
   LEFT JOIN cgato ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
   WHERE tcc.entidade = :entidade
     AND tcc.datacredito BETWEEN :dataInicial AND :dataFinal
     AND tcci.valormulta > 0
     AND tcci.valorprincipal > 0
     AND tdp.situacaolegal = 0
     AND NOT EXISTS
       (SELECT 1
        FROM tceatualizamonecredito tamc
        WHERE tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
          AND tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita )
   UNION ALL SELECT 3 AS idTipoAtualizacaoCredito,
                    tcci.valorcorrecao AS vlAtualizacao,
                    0 AS idpagamentobloqueto,
                    tcci.iddebitoparcelareceita,
                    tcci.idcreditocontribuinteitem,
                    tcc.datacredito AS dtAtualizacao,
                    tlc.nrcredito,
                    tlc.nranocredito,
                    ato.idtce as cdControleLeiAto
   FROM tribcreditocontribuinte tcc
   JOIN tribcreditocontribuinteitem tcci ON tcci.entidade = tcc.entidade
   AND tcci.exercicio = tcc.exercicio
   AND tcci.creditocontribuinte = tcc.creditocontribuinte
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade
   AND tdp.exercicio = tdpr.exercicio
   AND tdp.tipocadastro = tdpr.tipocadastro
   AND tdp.cadastrogeral = tdpr.cadastrogeral
   AND tdp.guiarecolhimento = tdpr.guiarecolhimento
   AND tdp.subdivida = tdpr.subdivida
   AND tdp.parcela = tdpr.parcela
   JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
   JOIN tribguiarecolhimento tgr on tdpr.entidade = tgr.entidade
       and tdpr.exercicio = tgr.exercicio
       and tgr.guiarecolhimento = tdpr.guiarecolhimento
   LEFT JOIN cgato ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
WHERE tcc.entidade = :entidade
     AND tcc.datacredito BETWEEN :dataInicial AND :dataFinal
     AND tcci.valorcorrecao > 0
     AND tcci.valorprincipal > 0
     AND tdp.situacaolegal = 0
     AND NOT EXISTS
       (SELECT 1
        FROM tceatualizamonecredito tamc
        WHERE tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
          AND tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita ) ) filtro
ORDER BY filtro.dtAtualizacao,
         filtro.nrcredito,
         filtro.nranocredito,
         filtro.idpagamentobloqueto,
         filtro.iddebitoparcelareceita,
         filtro.idTipoAtualizacaoCredito