/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.dto.ReceitaValorItbiDTO;
import br.com.elotech.tributos.repository.ImobiliarioItbiRepository;
import br.com.elotech.tributos.service.AiseBloquetoService;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.exception.ImobiliarioItbiException;
import br.com.elotech.tributos.service.ws.AiseItbiService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoItbiDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.TransferenciaItbiDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseItbiServiceRest
implements AiseItbiService {
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final TributosProperties tributosProperties;
    private final ImobiliarioItbiRepository imobiliarioItbiRepository;
    private final AiseDebitoService debitoService;
    private final AiseBloquetoService aiseBloquetoService;

    public AiseItbiServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, TributosProperties tributosProperties, ImobiliarioItbiRepository imobiliarioItbiRepository, AiseDebitoService debitoService, AiseBloquetoService aiseBloquetoService) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.tributosProperties = tributosProperties;
        this.imobiliarioItbiRepository = imobiliarioItbiRepository;
        this.debitoService = debitoService;
        this.aiseBloquetoService = aiseBloquetoService;
    }

    public void transferir(Long idItbi, String usuario) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/titbi/transferir/", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)TransferenciaItbiDTO.from((Long)idItbi, (String)usuario), (HttpHeaders)headers), Void.class, new Object[0]);
    }

    public void cancelar(Long idItbi, String usuario) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/titbi/cancelar/", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)TransferenciaItbiDTO.from((Long)idItbi, (String)usuario), (HttpHeaders)headers), Void.class, new Object[0]);
    }

    public GerarDebitoResponseDTO gerarDebito(Long id, GerarDebitoRequestDTO gerarDebitoRequestDTO) {
        ImobiliarioItbi itbi = (ImobiliarioItbi)this.imobiliarioItbiRepository.findOne((Object)id);
        GerarDebitoRequestDTO sendGerarDebitoRequestDTO = this.criarGerarDebitoRequest(itbi, gerarDebitoRequestDTO);
        GerarDebitoResponseDTO gerarDebitoResponseDTO = this.debitoService.geraDebito(sendGerarDebitoRequestDTO);
        itbi.setSubDivida(gerarDebitoResponseDTO.getSubDivida());
        itbi.setDebitoGerado(Boolean.valueOf(true));
        this.imobiliarioItbiRepository.save((Object)itbi);
        return gerarDebitoResponseDTO;
    }

    private GerarDebitoRequestDTO criarGerarDebitoRequest(ImobiliarioItbi itbi, GerarDebitoRequestDTO dto) {
        GerarDebitoRequestDTO gerarDebitoRequestDTO = new GerarDebitoRequestDTO();
        gerarDebitoRequestDTO.setTipoCadastro(itbi.getTipoCadastro().getValue());
        gerarDebitoRequestDTO.setCadastroGeral(itbi.getCadastroGeral());
        gerarDebitoRequestDTO.setExercicio(itbi.getExercicio());
        gerarDebitoRequestDTO.setEntidade(itbi.getEntidade());
        gerarDebitoRequestDTO.setGuiaRecolhimento(itbi.getGuiaRecolhimento());
        gerarDebitoRequestDTO.setDataLancamento(itbi.getDataLancamento());
        gerarDebitoRequestDTO.setDataVencimento(itbi.getDataVencimento());
        gerarDebitoRequestDTO.setTelaOrigemDebito("ITBI Online");
        gerarDebitoRequestDTO.setReceitaLista(this.montarReceitaLista(itbi));
        gerarDebitoRequestDTO.setUsuario(dto.getUsuario());
        gerarDebitoRequestDTO.setObservacao(dto.getObservacao());
        gerarDebitoRequestDTO.setIdImobiliarioItbi(itbi.getId());
        return gerarDebitoRequestDTO;
    }

    public String montarReceitaLista(ImobiliarioItbi itbi) {
        ParametroItbi paramItbi = itbi.getParametroItbi();
        ArrayList<ReceitaValorItbiDTO> receitasItbi = new ArrayList<ReceitaValorItbiDTO>();
        if (itbi.getTipoItbi().isNormal()) {
            receitasItbi.add(new ReceitaValorItbiDTO(paramItbi.getTributoPadrao(), itbi.getValor(), itbi.getBaseCalculo()));
        } else if (itbi.getTipoItbi().isFinanciado()) {
            receitasItbi.add(new ReceitaValorItbiDTO(paramItbi.getTributoAVista(), itbi.getValor(), itbi.getBaseCalculo()));
            receitasItbi.add(new ReceitaValorItbiDTO(paramItbi.getTributoFinanciado(), itbi.getValorFinanciado(), itbi.getBaseCalculoFinanciado()));
        } else if (itbi.getTipoItbi().isAnuencia()) {
            receitasItbi.add(new ReceitaValorItbiDTO(paramItbi.getTributoPadrao(), itbi.getValor(), itbi.getBaseCalculo()));
            receitasItbi.add(new ReceitaValorItbiDTO(paramItbi.getTributoAnuencia(), itbi.getValorFinanciado(), itbi.getBaseCalculoFinanciado()));
        } else {
            throw new ImobiliarioItbiException(HttpStatus.BAD_REQUEST, String.format("O tipo de Itbi %s n\u00e3o \u00e9 suportado.", itbi.getTipoItbi().getDescricao()));
        }
        List receitasItbiAgrupadas = this.agruparReceitasItbi(receitasItbi);
        return this.montarReceitasAise(receitasItbiAgrupadas);
    }

    private String montarReceitasAise(List<ReceitaValorItbiDTO> receitasItbiAgrupadas) {
        return receitasItbiAgrupadas.stream().map(arg_0 -> this.addReceita(arg_0)).reduce("", (accum, elemento) -> accum + elemento);
    }

    private List<ReceitaValorItbiDTO> agruparReceitasItbi(List<ReceitaValorItbiDTO> receitasItbi) {
        return receitasItbi.stream().collect(Collectors.groupingBy(ReceitaValorItbiDTO::getReceita, this.somandoValor())).values().stream().map(Optional::get).filter(receita -> receita.getValor().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
    }

    private Collector<ReceitaValorItbiDTO, ?, Optional<ReceitaValorItbiDTO>> somandoValor() {
        return Collectors.reducing((accum, element) -> {
            accum.setValor(accum.getValor().add(element.getValor()));
            accum.setBaseCalculo(accum.getBaseCalculo().add(element.getBaseCalculo()));
            return accum;
        });
    }

    private String addReceita(ReceitaValorItbiDTO receita) {
        Locale locale = new Locale("pt", "BR");
        return String.format(locale, "%s|%.2f|0|0|0|%.2f;", receita.getReceita(), receita.getValor(), receita.getBaseCalculo());
    }

    public BloquetoDTO gerarBloqueto(Long idSequencia, String usuario) {
        ImobiliarioItbi itbi = (ImobiliarioItbi)this.imobiliarioItbiRepository.findById((Object)idSequencia).orElseThrow(() -> new ImobiliarioItbiException(HttpStatus.BAD_REQUEST, String.format("N\u00e3o foi encontrado ITBI com sequ\u00eancia %d", idSequencia)));
        if (itbi.getParametroItbi() == null) {
            throw new ImobiliarioItbiException(HttpStatus.BAD_REQUEST, String.format("N\u00e3o h\u00e1 par\u00e2metro configurado para o ITBI com sequ\u00eancia %d", idSequencia));
        }
        Long idDebito = this.imobiliarioItbiRepository.findIdDebitoById(idSequencia);
        if (idDebito == null) {
            throw new ImobiliarioItbiException(HttpStatus.BAD_REQUEST, String.format("N\u00e3o h\u00e1 d\u00e9bito gerado para o ITBI com sequ\u00eancia %d", idSequencia));
        }
        if (Objects.isNull(itbi.getParametroItbi().getModeloBoleto())) {
            throw new ImobiliarioItbiException(HttpStatus.BAD_REQUEST, String.format("O parametro de itbi %s n\u00e3o possui o relat\u00f3rio de boleto configurado.", itbi.getParametroItbi().getId()));
        }
        ProprietarioItbi compradorPrincipal = Optional.ofNullable(itbi.getCompradorPrincipal()).orElseThrow(() -> new EloValidationException("Necess\u00e1rio definir o comprador principal"));
        DebitoItbiDTO debitoItbi = new DebitoItbiDTO();
        debitoItbi.setIdDebito(idDebito);
        debitoItbi.setIdSequencia(idSequencia);
        debitoItbi.setTipoRelatorioBloqueto(itbi.getParametroItbi().getModeloBoleto().getTipoRelatorio());
        debitoItbi.setRelatorioBloqueto(Long.valueOf(itbi.getParametroItbi().getModeloBoleto().getRelatorio().intValue()));
        debitoItbi.setUsuario(usuario);
        debitoItbi.setPessoaCompradorPrincipal(compradorPrincipal.getId().getPessoa().getId());
        return this.aiseBloquetoService.geraBloquetoItbi(debitoItbi);
    }
}

