/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipo;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoDetalheDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoFiltroDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoResumoDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoResumoItemDTO;
import br.com.elotech.tributos.repository.integracaocontabil.ArrecadacaoRepository;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ArrecadacaoService {
    private final ArrecadacaoRepository arrecadacaoRepository;

    public ArrecadacaoService(ArrecadacaoRepository arrecadacaoRepository) {
        this.arrecadacaoRepository = arrecadacaoRepository;
    }

    public ArrecadacaoPorTipoResumoDTO consultaResumoArrecadacao(ArrecadacaoPorTipoFiltroDTO filtro) {
        ArrecadacaoPorTipoResumoDTO retorno = new ArrecadacaoPorTipoResumoDTO();
        ArrecadacaoPorTipoResumoItemDTO pagamentos = this.arrecadacaoRepository.consultaResumoArrecadacaoPorPagamento(filtro);
        ArrecadacaoPorTipoResumoItemDTO estornoPagamentos = this.arrecadacaoRepository.consultaResumoArrecadacaoPorEstornoPagamento(filtro);
        estornoPagamentos.getValores().setNegativo(Boolean.TRUE);
        ArrecadacaoPorTipoResumoItemDTO reabilitacaoEstornoPagamentos = this.arrecadacaoRepository.consultaResumoArrecadacaoPorReabilitacaoEstornoPagamento(filtro);
        ArrecadacaoPorTipoResumoItemDTO creditos = this.arrecadacaoRepository.consultaResumoArrecadacaoPorCreditos(filtro);
        ArrecadacaoPorTipoResumoItemDTO estornoCreditos = this.arrecadacaoRepository.consultaResumoArrecadacaoPorEstornoCreditos(filtro);
        estornoCreditos.getValores().setNegativo(Boolean.TRUE);
        retorno.setItens(Arrays.asList(pagamentos, estornoPagamentos, reabilitacaoEstornoPagamentos, creditos, estornoCreditos));
        return retorno;
    }

    public Page<ArrecadacaoPorTipoDetalheDTO> consultaResumoArrecadacaoPorTipoDetalhe(ArrecadacaoPorTipoFiltroDTO filtro, Pageable pageable) {
        ArrayList listaCompleta = new ArrayList();
        ArrecadacaoPorTipo tipo = Optional.ofNullable(filtro.getTipo()).orElseThrow(() -> new EloValidationException("O filtro informado deve conter o Tipo da arrecada\u00e7\u00e3o."));
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$integracaocontabil$ArrecadacaoPorTipo[tipo.ordinal()]) {
            case 1: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorPagamentoDetalhe(filtro));
                break;
            }
            case 2: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorEstornoPagamentoDetalhe(filtro));
                break;
            }
            case 3: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorReabilitacaoEstornoPagamentoDetalhe(filtro));
                break;
            }
            case 4: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorCreditoDetalhe(filtro));
                break;
            }
            case 5: {
                listaCompleta.addAll(this.arrecadacaoRepository.consultaArrecadacaoPorEstornoCreditoDetalhe(filtro));
            }
        }
        List resultado = listaCompleta.stream().sorted(Comparator.comparing(ArrecadacaoPorTipoDetalheDTO::getExercicio).thenComparing(ArrecadacaoPorTipoDetalheDTO::getItem)).skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new PageImpl(resultado, pageable, (long)listaCompleta.size());
    }
}

