/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.AcessoDiarioPortalContribuinte;
import br.com.elotech.tributos.dto.TotalAcessoAcumuladoDTO;
import br.com.elotech.tributos.repository.TotalAcessoRepository;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class TotalAcessoService {
    private final TotalAcessoRepository totalAcessoRepository;
    private final PlatformTransactionManager transactionManager;

    public synchronized TotalAcessoAcumuladoDTO getTotalAcesso(LocalDate data) {
        return (TotalAcessoAcumuladoDTO)new TransactionTemplate(this.transactionManager).execute(status -> {
            AcessoDiarioPortalContribuinte totalAcessoDiario = this.totalAcessoRepository.findByData(data);
            if (Objects.isNull(totalAcessoDiario)) {
                totalAcessoDiario = new AcessoDiarioPortalContribuinte();
                totalAcessoDiario.setData(data);
            }
            totalAcessoDiario.incrementa();
            this.totalAcessoRepository.save((Object)totalAcessoDiario);
            return new TotalAcessoAcumuladoDTO(this.totalAcessoRepository.getTodosAcessos());
        });
    }

    @Generated
    public TotalAcessoService(TotalAcessoRepository totalAcessoRepository, PlatformTransactionManager transactionManager) {
        this.totalAcessoRepository = totalAcessoRepository;
        this.transactionManager = transactionManager;
    }
}

