/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.TipoContencioso;
import br.com.elotech.tributos.domain.protocolo.Assunto;
import br.com.elotech.tributos.dto.contencioso.TipoContenciosoResponseDTO;
import br.com.elotech.tributos.repository.AssuntoRepository;
import br.com.elotech.tributos.repository.DocumentoTipoRepository;
import br.com.elotech.tributos.repository.TipoContenciosoRepository;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class TipoContencioService
extends CrudService<TipoContencioso, Long> {
    private TipoContenciosoRepository tipoContenciosoRepository;
    private AssuntoRepository assuntoRepository;
    private DocumentoTipoRepository documentoTipoRepository;

    public TipoContencioService(TipoContenciosoRepository tipoContenciosoRepository, AssuntoRepository assuntoRepository, DocumentoTipoRepository documentoTipoRepository) {
        this.tipoContenciosoRepository = tipoContenciosoRepository;
        this.assuntoRepository = assuntoRepository;
        this.documentoTipoRepository = documentoTipoRepository;
    }

    public TipoContencioso update(Long id, TipoContenciosoResponseDTO dto) {
        if (Objects.isNull(dto)) {
            throw new EloValidationException("A atualiza\u00e7\u00e3o do tipo de contencioso necessita das novas informa\u00e7\u00f5es.");
        }
        TipoContencioso tipoContencioso = this.findTipoContenciosoById(id);
        return (TipoContencioso)this.tipoContenciosoRepository.save((Object)this.buildTipoContencioso(dto, tipoContencioso));
    }

    public TipoContencioso create(TipoContenciosoResponseDTO dto) {
        return (TipoContencioso)this.tipoContenciosoRepository.save((Object)this.buildTipoContencioso(dto, new TipoContencioso()));
    }

    private TipoContencioso buildTipoContencioso(TipoContenciosoResponseDTO dto, TipoContencioso tipoContencioso) {
        tipoContencioso.setDescricao(dto.getDescricao());
        Optional.ofNullable(dto.getSituacao()).ifPresent(arg_0 -> ((TipoContencioso)tipoContencioso).setAtivo(arg_0));
        Optional.ofNullable(dto.getGeraProtocolo()).ifPresent(arg_0 -> ((TipoContencioso)tipoContencioso).setGeraProtocolo(arg_0));
        Optional.ofNullable(dto.getEmiteDocumento()).ifPresent(arg_0 -> ((TipoContencioso)tipoContencioso).setEmiteDocumento(arg_0));
        Optional.ofNullable(dto.getCancelamentoAutomatico()).ifPresent(arg_0 -> ((TipoContencioso)tipoContencioso).setCancelamentoAutomatico(arg_0));
        Optional.ofNullable(dto.getCancelamentoParcial()).ifPresent(arg_0 -> ((TipoContencioso)tipoContencioso).setCancelamentoParcial(arg_0));
        Optional.ofNullable(dto.getCancelamentoParcialRecAdm()).ifPresent(arg_0 -> ((TipoContencioso)tipoContencioso).setCancelamentoParcialRecAdm(arg_0));
        if (Objects.nonNull(dto.getAssunto().getId())) {
            Assunto assunto = (Assunto)this.assuntoRepository.findById((Object)dto.getAssunto().getId()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi poss\u00edvel encontrar Assunto com o id: %d", dto.getAssunto().getId())));
            tipoContencioso.setAssuntoProtocolo(assunto);
        }
        if (Objects.nonNull(dto.getTipoDocumento().getId())) {
            DocumentoTipo documentoTipo = (DocumentoTipo)this.documentoTipoRepository.findById((Object)dto.getTipoDocumento().getId()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi poss\u00edvel encontrar Tipo Documento com o id: %d", dto.getTipoDocumento().getId())));
            tipoContencioso.setTipoDocumento(documentoTipo);
        }
        return tipoContencioso;
    }

    public TipoContencioso findTipoContenciosoById(Long id) {
        return (TipoContencioso)this.findById((Serializable)id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi poss\u00edvel encontrar Tipo Contencioso com o id: %d", id)));
    }
}

