/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.repository.ParametroGeralRepository;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ParametroGeralService
extends CrudService<ParametroGeral, Long> {
    private final Logger log = LoggerFactory.getLogger(ParametroGeralService.class);
    private final ParametroGeralRepository parametroGeralRepository;

    public ParametroGeralService(ParametroGeralRepository parametroGeralRepository) {
        this.parametroGeralRepository = parametroGeralRepository;
    }

    public ParametroGeral findByParametroAndModulo(ParametroGeralEnum parametro, String modulo) {
        ParametroGeral parametroGeral = this.parametroGeralRepository.findByModuloAndParametro(modulo, parametro.getValue());
        this.validaParametro(parametro, parametroGeral);
        return parametroGeral;
    }

    public ParametroGeral findByParametroAndModulo(String parametro, String modulo) {
        return Optional.ofNullable(this.parametroGeralRepository.findByModuloAndParametro(modulo, parametro)).orElseThrow(() -> new ParametroNaoEncontradoException(parametro));
    }

    public String getParamValueAsString(ParametroGeralEnum parametro, String modulo) {
        ParametroGeral param = this.findByParametroAndModulo(parametro, modulo);
        this.log.debug("O valor do p\u00e2rametro {} \u00e9 {}. ", (Object)parametro.getValue(), (Object)param);
        return Optional.ofNullable(param).map(ParametroGeral::getValor).orElse("");
    }

    public Long getParamValueAsLong(ParametroGeralEnum parametro, String modulo) {
        String paramValue = this.getParamValueAsString(parametro, modulo);
        if ("".equals(paramValue)) {
            return null;
        }
        return Long.valueOf(paramValue);
    }

    public Integer getParamValueAsInteger(ParametroGeralEnum parametro, String modulo) {
        String paramValue = this.getParamValueAsString(parametro, modulo);
        if ("".equals(paramValue)) {
            return null;
        }
        return Integer.valueOf(paramValue);
    }

    public BigDecimal getParamValueAsBigDecimal(ParametroGeralEnum parametro, String modulo) {
        String paramValue = this.getParamValueAsString(parametro, modulo);
        if ("".equals(paramValue)) {
            return null;
        }
        return new BigDecimal(paramValue.replace(",", "."));
    }

    public Boolean getParamValueAsBoolean(ParametroGeralEnum parametro, String modulo) {
        String paramValue = this.getParamValueAsString(parametro, modulo);
        return SimNao.toBoolean((String)paramValue, (Boolean)Boolean.FALSE);
    }

    public Boolean getParamValueAsBoolean(ParametroGeralEnum parametro) {
        String paramValue = this.getParamValueAsString(parametro, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        return SimNao.toBoolean((String)paramValue, (Boolean)Boolean.FALSE);
    }

    public Boolean paramsValueAreTrue(List<ParametroGeralEnum> parametros, String modulo) {
        return parametros.stream().noneMatch(param -> this.getParamValueAsBoolean(param, modulo).equals(false));
    }

    private void validaParametro(ParametroGeralEnum parametro, ParametroGeral parametroGeral) {
        if (Objects.isNull(parametroGeral) && !parametro.possuiValorPadrao().booleanValue()) {
            throw new ParametroNaoEncontradoException(parametro.getDescricao());
        }
    }
}

