/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CategoriaMobiliario;
import br.com.elotech.tributos.domain.ClassificacaoMobiliario;
import br.com.elotech.tributos.domain.Cnae;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.PessoaMobiliario;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioAtividade;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioCnae;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioSituacao;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscalPeriodo;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioAlteracaoCadastralDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioCnaeDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioRowDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioSituacaoDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.ContratoSocialDTO;
import br.com.elotech.tributos.dto.EnderecoCorrespondenciaDTO;
import br.com.elotech.tributos.dto.RegimeFiscalPeriodoAlteracaoDTO;
import br.com.elotech.tributos.dto.mobile.CadastroMobiliarioMobileDTO;
import br.com.elotech.tributos.exception.CadastroMobiliarioNaoEncontradoException;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.facet.FacetCadastroMobiliario;
import br.com.elotech.tributos.repository.CategoriaMobiliarioRepository;
import br.com.elotech.tributos.repository.ClassificacaoMobiliarioRepository;
import br.com.elotech.tributos.repository.CnaeRepository;
import br.com.elotech.tributos.repository.PessoaMobiliarioRepository;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.repository.RegimeFiscalRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.mobiliario.CadastroMobiliarioRepository;
import br.com.elotech.tributos.repository.mobiliario.MobiliarioCnaeRepository;
import br.com.elotech.tributos.service.EnderecoCorrespondenciaService;
import br.com.elotech.tributos.service.HibernateSearchService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SequenceCadastroGeralService;
import br.com.elotech.tributos.service.SituacaoMobiliarioService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class CadastroMobiliarioService
extends CrudService<CadastroMobiliario, Long> {
    private final CadastroMobiliarioRepository cadastroMobiliarioRepository;
    private final PessoaRepository pessoaRepository;
    private final PessoaMobiliarioRepository pessoaMobiliarioRepository;
    private final CategoriaMobiliarioRepository categoriaMobiliarioRepository;
    private final ClassificacaoMobiliarioRepository classificacaoMobiliarioRepository;
    private final CnaeRepository cnaeRepository;
    private final RegimeFiscalRepository regimeFiscalRepository;
    private final MobiliarioCnaeRepository mobiliarioCnaeRepository;
    private final HibernateSearchService hibernateSearchService;
    private final ParametroGeralService parametroGeralService;
    private final SituacaoMobiliarioService situacaoMobiliarioService;
    private final RespostaService respostaService;
    private final EnderecoCorrespondenciaService enderecoCorrespondenciaService;
    private final SequenceCadastroGeralService sequenceCadastroGeralService;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;

    public CadastroMobiliarioService(CadastroMobiliarioRepository cadastroMobiliarioRepository, PessoaRepository pessoaRepository, PessoaMobiliarioRepository pessoaMobiliarioRepository, CategoriaMobiliarioRepository categoriaMobiliarioRepository, ClassificacaoMobiliarioRepository classificacaoMobiliarioRepoository, CnaeRepository cnaeRepository, RegimeFiscalRepository regimeFiscalRepository, MobiliarioCnaeRepository mobiliarioCnaeRepository, HibernateSearchService hibernateSearchService, ParametroGeralService parametroGeralService, SituacaoMobiliarioService situacaoMobiliarioService, RespostaService respostaService, EnderecoCorrespondenciaService enderecoCorrespondenciaService, SequenceCadastroGeralService sequenceCadastroGeralService, SequenceGeneratorRepository sequenceGeneratorRepository) {
        this.cadastroMobiliarioRepository = cadastroMobiliarioRepository;
        this.pessoaRepository = pessoaRepository;
        this.pessoaMobiliarioRepository = pessoaMobiliarioRepository;
        this.categoriaMobiliarioRepository = categoriaMobiliarioRepository;
        this.classificacaoMobiliarioRepository = classificacaoMobiliarioRepoository;
        this.cnaeRepository = cnaeRepository;
        this.regimeFiscalRepository = regimeFiscalRepository;
        this.mobiliarioCnaeRepository = mobiliarioCnaeRepository;
        this.hibernateSearchService = hibernateSearchService;
        this.parametroGeralService = parametroGeralService;
        this.situacaoMobiliarioService = situacaoMobiliarioService;
        this.respostaService = respostaService;
        this.enderecoCorrespondenciaService = enderecoCorrespondenciaService;
        this.sequenceCadastroGeralService = sequenceCadastroGeralService;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
    }

    public CadastroMobiliario findByTipoCadastroAndCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroMobiliarioRepository.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
    }

    public CadastroMobiliario alteracaoCadastral(CadastroMobiliarioAlteracaoCadastralDTO cadastroMobiliarioAlteracaoCadastralDTO) {
        CadastroMobiliario cadastroMobiliario = this.buscarCadastroMobiliario(cadastroMobiliarioAlteracaoCadastralDTO);
        Optional.ofNullable(cadastroMobiliarioAlteracaoCadastralDTO.getPessoaEmpresa()).ifPresent(pessoaEmpresa -> cadastroMobiliario.setPessoaEmpresa((Pessoa)this.pessoaRepository.findOne(pessoaEmpresa)));
        Optional.ofNullable(cadastroMobiliarioAlteracaoCadastralDTO.getPessoaMobiliario()).ifPresent(pessoaMobiliario -> cadastroMobiliario.setPessoaMobiliario((PessoaMobiliario)this.pessoaMobiliarioRepository.findOne(pessoaMobiliario)));
        Optional.ofNullable(cadastroMobiliarioAlteracaoCadastralDTO.getCategoriaMobiliario()).ifPresent(categoriaMobiliario -> cadastroMobiliario.setCategoriaMobiliario((CategoriaMobiliario)this.categoriaMobiliarioRepository.findOne(categoriaMobiliario)));
        Optional.ofNullable(cadastroMobiliarioAlteracaoCadastralDTO.getClassificacaoMobiliario()).ifPresent(classificacaoMobiliario -> cadastroMobiliario.setClassificacaoMobiliario((ClassificacaoMobiliario)this.classificacaoMobiliarioRepository.findOne(classificacaoMobiliario)));
        if (Objects.nonNull(cadastroMobiliarioAlteracaoCadastralDTO.getCnaes()) && !cadastroMobiliarioAlteracaoCadastralDTO.getCnaes().isEmpty()) {
            cadastroMobiliario.getCadastroMobiliarioCnaes().clear();
            this.mobiliarioCnaeRepository.flush();
            cadastroMobiliario.getCadastroMobiliarioCnaes().addAll(cadastroMobiliarioAlteracaoCadastralDTO.getCnaes().stream().map(cnae -> this.atualizarCnaes(cadastroMobiliario, cnae)).collect(Collectors.toList()));
        }
        if (Objects.nonNull(cadastroMobiliarioAlteracaoCadastralDTO.getRegimesFiscais()) && !cadastroMobiliarioAlteracaoCadastralDTO.getRegimesFiscais().isEmpty()) {
            cadastroMobiliario.getRegimeFiscalPeriodo().clear();
            for (RegimeFiscalPeriodoAlteracaoDTO dto : cadastroMobiliarioAlteracaoCadastralDTO.getRegimesFiscais()) {
                cadastroMobiliario.getRegimeFiscalPeriodo().add(this.atualizarRegimeFiscal(cadastroMobiliario, dto));
            }
        }
        cadastroMobiliario.set(cadastroMobiliarioAlteracaoCadastralDTO);
        return (CadastroMobiliario)this.cadastroMobiliarioRepository.save((Object)cadastroMobiliario);
    }

    private CadastroMobiliario buscarCadastroMobiliario(CadastroMobiliarioAlteracaoCadastralDTO dto) {
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioRepository.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)dto.getTipoCadastro()), dto.getCadastroGeral());
        if (Objects.isNull(cadastroMobiliario)) {
            throw new CadastroMobiliarioNaoEncontradoException(HttpStatus.BAD_REQUEST, String.format("Cadastro %d n\u00e3o encontrado", dto.getCadastroGeral()));
        }
        return cadastroMobiliario;
    }

    private CadastroMobiliarioCnae atualizarCnaes(CadastroMobiliario cadastroMobiliario, CadastroMobiliarioCnaeDTO dto) {
        CadastroMobiliarioCnae cnae = CadastroMobiliarioCnae.set((CadastroMobiliarioCnaeDTO)dto);
        cnae.setCnae((Cnae)this.cnaeRepository.findOne((Object)dto.getCnae()));
        cnae.setCadastroMobiliario(cadastroMobiliario);
        return cnae;
    }

    private RegimeFiscalPeriodo atualizarRegimeFiscal(CadastroMobiliario cadastro, RegimeFiscalPeriodoAlteracaoDTO dto) {
        RegimeFiscalPeriodo regime = RegimeFiscalPeriodo.ofAlteracaoCadastral((RegimeFiscalPeriodoAlteracaoDTO)dto);
        regime.setRegimeFiscal((RegimeFiscal)this.regimeFiscalRepository.findOne((Object)dto.getRegimeFiscal()));
        regime.setCadastroGeral((CadastroGeral)cadastro);
        return regime;
    }

    public Page<CadastroMobiliarioMobileDTO> searchCadastrosAtivosByNomeAndGrupoAtividade(String nome, String grupoAtividade, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)nome) && StringUtils.isBlank((CharSequence)grupoAtividade)) {
            throw new EloValidationException("Necess\u00e1rio filtrar por nome ou grupo de atividade.");
        }
        return this.cadastroMobiliarioRepository.searchCadastrosAtivosByNomeAndGrupoAtividade(nome, grupoAtividade, pageable);
    }

    public CadastroSearchDTO<CadastroMobiliarioRowDTO> searchCadastrosMobiliarios(CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        List<String> searchFields = Arrays.asList("cep", "atividadePrincipal", "pessoa.nome", "pessoa.cnpjCpf", "pessoa.nomeFantasia", "pessoa.rg", "contratosSocial.pessoas.pessoa.nome", "contratosSocial.pessoas.pessoa.cnpjCpf", "contratosSocial.pessoas.pessoa.nomeFantasia", "contratosSocial.pessoas.pessoa.rg", "enderecoFormatado");
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.getEm(), CadastroMobiliario.class, pageable, searchParams.getSearch(), searchFields, Arrays.asList(FacetCadastroMobiliario.values()));
        Query query = hibernateSearchParams.getQueryBuilder().bool().must(hibernateSearchParams.createQueryWithSpecificField("tipoCadastroDescricao", TipoCadastro.MOBILIARIO.getDescricao())).should((Query)new BoostQuery(hibernateSearchParams.createQueryWithSpecificField("cadastroGeral", searchParams.getSearch()), 1.5f)).should(hibernateSearchParams.createFuzzyQuery()).createQuery();
        return this.hibernateSearchService.geraCadastroSearchDTO(query, hibernateSearchParams, searchParams.getFacets(), CadastroMobiliarioRowDTO::from);
    }

    public CadastroMobiliarioDTO save(CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        this.camposObrigatoriosValidate(cadastroMobiliarioDTO);
        CadastroMobiliario cadastroMobiliario = cadastroMobiliarioDTO.toEntity();
        this.camposDinamicosObrigatoriosValidate(cadastroMobiliario);
        cadastroMobiliario.setUsuario(UsuarioUtils.getUsuarioAise());
        SituacaoMobiliario situacaoMobiliario = (SituacaoMobiliario)this.situacaoMobiliarioService.findById((Serializable)cadastroMobiliarioDTO.getSituacaoMobiliario()).orElseThrow(() -> new EloValidationException(String.format("Situa\u00e7\u00e3o %d n\u00e3o encontrada.", cadastroMobiliarioDTO.getSituacaoMobiliario())));
        CadastroMobiliarioSituacao cadastroMobiliarioSituacao = new CadastroMobiliarioSituacao();
        cadastroMobiliarioSituacao.setSequencia(Long.valueOf(1L));
        cadastroMobiliarioSituacao.setCadastroMobiliario(cadastroMobiliario);
        cadastroMobiliarioSituacao.setAtual(Boolean.TRUE);
        cadastroMobiliarioSituacao.setSituacaoMobiliario(situacaoMobiliario);
        cadastroMobiliarioSituacao.setDataInclusao(LocalDate.now());
        cadastroMobiliarioSituacao.setDataAlteracao(LocalDate.now());
        cadastroMobiliarioSituacao.setUsuarioInclusao(cadastroMobiliario.getUsuario());
        cadastroMobiliario.getCadastroMobiliarioSituacoes().add(cadastroMobiliarioSituacao);
        cadastroMobiliario.getCadastroMobiliarioAtividades().forEach(atividade -> atividade.setCadastroMobiliario(cadastroMobiliario));
        cadastroMobiliario.getCadastroMobiliarioHorariosEspeciais().forEach(horarioEspecial -> horarioEspecial.setCadastroMobiliario(cadastroMobiliario));
        cadastroMobiliario.getCadastroMobiliarioCnaes().forEach(cnae -> cnae.setCadastroMobiliario(cadastroMobiliario));
        cadastroMobiliario.getRespostasMobiliarios().forEach(resposta -> resposta.setCadastroMobiliario(cadastroMobiliario));
        cadastroMobiliario.getRegimeFiscalPeriodo().forEach(regimeFiscalPeriodo -> regimeFiscalPeriodo.setCadastroGeral((CadastroGeral)cadastroMobiliario));
        if (Objects.isNull(cadastroMobiliarioDTO.getCadastroGeral())) {
            cadastroMobiliario.setCadastroGeral(this.getCadastroGeralBySequence(cadastroMobiliario));
            cadastroMobiliario.atualizaReferenciaObservacoes();
        }
        return this.saveCadastroMobiliario(cadastroMobiliario);
    }

    public CadastroMobiliarioDTO update(Long id, CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        this.camposObrigatoriosValidate(cadastroMobiliarioDTO);
        CadastroMobiliario cadastroMobiliarioToMerge = cadastroMobiliarioDTO.toEntity();
        this.camposDinamicosObrigatoriosValidate(cadastroMobiliarioToMerge);
        CadastroMobiliario cadastroMobiliarioFound = this.findCadastroMobiliarioById(id);
        if (!cadastroMobiliarioToMerge.getId().equals(cadastroMobiliarioFound.getId())) {
            throw new EloValidationException("Para atualizar os dados, os cadastros devem ser os mesmos.");
        }
        return this.saveCadastroMobiliario(cadastroMobiliarioFound.merge(cadastroMobiliarioToMerge));
    }

    public CadastroMobiliarioDTO saveCadastroMobiliario(CadastroMobiliario cadastroMobiliario) {
        CadastroMobiliarioDTO cadastroMobiliarioSaved = CadastroMobiliarioDTO.from((CadastroMobiliario)((CadastroMobiliario)this.cadastroMobiliarioRepository.save((Object)cadastroMobiliario)));
        cadastroMobiliarioSaved.setRespostasMobiliario(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.MOBILIARIO, cadastroMobiliarioSaved.getId()));
        return cadastroMobiliarioSaved;
    }

    private Long getCadastroGeralBySequence(CadastroMobiliario cadastroMobiliario) {
        String sequenceNome = this.sequenceCadastroGeralService.getExpression((CadastroGeral)cadastroMobiliario);
        return this.sequenceGeneratorRepository.getNextVal(sequenceNome);
    }

    private boolean isNovoCadastro(CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        return Objects.isNull(cadastroMobiliarioDTO.getId());
    }

    private void camposObrigatoriosValidate(CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        boolean isCodigoMobiliarioSequencial = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CODIGO_MOBILIARIO_SEQUENCIAL);
        if (this.isNovoCadastro(cadastroMobiliarioDTO)) {
            if (isCodigoMobiliarioSequencial && Objects.nonNull(cadastroMobiliarioDTO.getCadastroGeral())) {
                throw new EloValidationException("C\u00f3digo do Cadastro n\u00e3o deve ser informado e ser\u00e1 gerado automaticamente.");
            }
            if (Objects.isNull(cadastroMobiliarioDTO.getSituacaoMobiliario())) {
                throw new EloValidationException("Situa\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
            }
        }
        if (Objects.nonNull(cadastroMobiliarioDTO.getCmcResponsavel()) && !TipoCadastro.MOBILIARIO.equals((Object)cadastroMobiliarioDTO.getCmcResponsavel().getTipoCadastro())) {
            throw new EloValidationException(String.format("O C.M.C Respons\u00e1vel deve ser do tipo Mobili\u00e1rio, mas foi informado um respons\u00e1vel do tipo %s.", cadastroMobiliarioDTO.getCmcResponsavel().getTipoCadastro().getDescricao()));
        }
        if (!(isCodigoMobiliarioSequencial && this.isNovoCadastro(cadastroMobiliarioDTO) || !Objects.isNull(cadastroMobiliarioDTO.getCadastroGeral()))) {
            throw new EloValidationException("C\u00f3digo do Cadastro \u00e9 obrigat\u00f3rio.");
        }
        if (Objects.isNull(cadastroMobiliarioDTO.getPessoa().getNome())) {
            throw new EloValidationException("Nome/Raz\u00e3o \u00e9 obrigat\u00f3rio.");
        }
        if (Objects.isNull(cadastroMobiliarioDTO.getPessoa().getCnpjCpf())) {
            throw new EloValidationException("CNPJ \u00e9 obrigat\u00f3rio.");
        }
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDACAO_ATIVIDADE_MOBILIARIO).booleanValue()) {
            if (cadastroMobiliarioDTO.getCadastroMobiliarioAtividades().isEmpty()) {
                throw new EloValidationException("O cadastro deve possuir pelo menos uma atividade.");
            }
            if (cadastroMobiliarioDTO.getCadastroMobiliarioAtividades().stream().noneMatch(CadastroMobiliarioAtividade::getAtividadePrincipal)) {
                throw new EloValidationException("O cadastro deve possuir uma atividade marcada como principal.");
            }
        }
        if (!cadastroMobiliarioDTO.getCadastroMobiliarioCnaes().isEmpty() && cadastroMobiliarioDTO.getCadastroMobiliarioCnaes().stream().noneMatch(CadastroMobiliarioCnae::getCnaePrincipal)) {
            throw new EloValidationException("Nenhum CNAE cadastrado est\u00e1 marcado como principal.");
        }
    }

    private void camposDinamicosObrigatoriosValidate(CadastroMobiliario cadastroMobiliario) {
        this.respostaService.validaRespostas(cadastroMobiliario.getRespostasMobiliarios(), FuncionalidadeCampo.MOBILIARIO);
    }

    private CadastroMobiliario findCadastroMobiliarioById(Long id) {
        return (CadastroMobiliario)this.cadastroMobiliarioRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Cadastro mobili\u00e1rio com o id %d n\u00e3o encontrado.", id)));
    }

    public CadastroMobiliarioDTO findCadastroMobiliarioDTO(Long id) {
        CadastroMobiliarioDTO cadastroMobiliarioDTO = CadastroMobiliarioDTO.from((CadastroMobiliario)this.findCadastroMobiliarioById(id));
        this.preencheEnderecoCorrespondencia(cadastroMobiliarioDTO);
        cadastroMobiliarioDTO.setRespostasMobiliario(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.MOBILIARIO, cadastroMobiliarioDTO.getId()));
        return cadastroMobiliarioDTO;
    }

    private void preencheEnderecoCorrespondencia(CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        Optional.ofNullable(cadastroMobiliarioDTO.getTipoEnderecoCorrespondencia()).ifPresent(tipoEnderecoCorrespondencia -> {
            EnderecoCorrespondenciaDTO enderecoCorrespondenciaDTO = this.enderecoCorrespondenciaService.findEnderecoCorrespondenciaByIdAndTipo(cadastroMobiliarioDTO.getId(), tipoEnderecoCorrespondencia);
            cadastroMobiliarioDTO.setEnderecoCorrespondencia(enderecoCorrespondenciaDTO.getLogradouroDescricao());
            cadastroMobiliarioDTO.setBairroCorrespondencia(enderecoCorrespondenciaDTO.getBairroDescricao());
            cadastroMobiliarioDTO.setCidadeUfCorrespondencia(enderecoCorrespondenciaDTO.getCidadeDescricao());
            cadastroMobiliarioDTO.setComplementoCorrespondencia(enderecoCorrespondenciaDTO.getComplemento());
            cadastroMobiliarioDTO.setNumeroCorrespondencia(enderecoCorrespondenciaDTO.getNumero());
            cadastroMobiliarioDTO.setUfCorrespondencia(enderecoCorrespondenciaDTO.getUnidadeFederacao());
            cadastroMobiliarioDTO.setCepCorrespondencia(enderecoCorrespondenciaDTO.getCep());
        });
    }

    public List<CadastroMobiliarioSituacaoDTO> getSituacoes(Long id) {
        CadastroMobiliario cadastroMobiliario = this.findCadastroMobiliarioById(id);
        return cadastroMobiliario.getCadastroMobiliarioSituacoes().stream().map(CadastroMobiliarioSituacaoDTO::from).sorted(Comparator.comparing(CadastroMobiliarioSituacaoDTO::getSequencia).reversed()).collect(Collectors.toList());
    }

    public List<CadastroMobiliarioSituacaoDTO> createSituacao(Long id, CadastroMobiliarioSituacaoDTO newSituacaoDTO) {
        CadastroMobiliario cadastroMobiliario = this.findCadastroMobiliarioById(id);
        boolean isSituacaoEncerramento = Objects.nonNull(newSituacaoDTO.getSituacaoMobiliario().getTipoSituacaoMobiliario()) && newSituacaoDTO.getSituacaoMobiliario().getTipoSituacaoMobiliario().getEncerramento() != false;
        this.validateNewSituacao(newSituacaoDTO, cadastroMobiliario.getDataAbertura(), isSituacaoEncerramento);
        cadastroMobiliario.getCadastroMobiliarioSituacoes().stream().filter(situacao -> Boolean.TRUE.equals(situacao.getAtual())).forEach(situacao -> {
            situacao.setAtual(Boolean.FALSE);
            situacao.setDataAlteracao(LocalDate.now());
        });
        CadastroMobiliarioSituacao newSituacao = CadastroMobiliarioSituacao.createNewSituacao((CadastroMobiliarioSituacaoDTO)newSituacaoDTO, (CadastroMobiliario)cadastroMobiliario, (String)UsuarioUtils.getUsuarioAise());
        cadastroMobiliario.getCadastroMobiliarioSituacoes().add(newSituacao);
        if (isSituacaoEncerramento) {
            cadastroMobiliario.setDataEncerramento(newSituacaoDTO.getDataEncerramento());
            cadastroMobiliario.setIdProcessoEncerramento(newSituacaoDTO.getIdProcesso());
            cadastroMobiliario.setExercicioProcessoEncerramento(newSituacaoDTO.getExercicioProcesso());
        }
        this.save((EloEntity)cadastroMobiliario, null);
        return cadastroMobiliario.getCadastroMobiliarioSituacoes().stream().map(CadastroMobiliarioSituacaoDTO::from).sorted(Comparator.comparing(CadastroMobiliarioSituacaoDTO::getSequencia).reversed()).collect(Collectors.toList());
    }

    private void validateNewSituacao(CadastroMobiliarioSituacaoDTO newSituacaoDTO, LocalDate dataAbertura, boolean isSituacaoEncerramento) {
        if (isSituacaoEncerramento && Objects.isNull(newSituacaoDTO.getDataEncerramento())) {
            throw new EloValidationException("Data de encerramento \u00e9 obrigat\u00f3ria para uma situa\u00e7\u00e3o de encerramento.");
        }
        if (isSituacaoEncerramento && newSituacaoDTO.getDataEncerramento().isAfter(LocalDate.now())) {
            throw new EloValidationException("A data de encerramento n\u00e3o pode ser posterior a data de hoje.");
        }
        if (isSituacaoEncerramento && Objects.nonNull(dataAbertura) && !dataAbertura.isBefore(newSituacaoDTO.getDataEncerramento())) {
            throw new EloValidationException(String.format("A data de encerramento deve ser posterior a data de abertura: \"%s\".", DateUtils.localDateToStringFormatoBrasileiro((LocalDate)dataAbertura)));
        }
        if (Objects.nonNull(newSituacaoDTO.getIdProcesso()) && Objects.isNull(newSituacaoDTO.getExercicioProcesso()) || Objects.isNull(newSituacaoDTO.getIdProcesso()) && Objects.nonNull(newSituacaoDTO.getExercicioProcesso())) {
            throw new EloValidationException("Necess\u00e1rio preencher ambos ou nenhum dos campos de processo e ano do processo.");
        }
    }

    public List<ContratoSocialDTO> getContratosSociais(Long idCadastro) {
        return this.findCadastroMobiliarioById(idCadastro).getContratosSocial().stream().map(ContratoSocialDTO::from).sorted(Comparator.comparing(ContratoSocialDTO::getSequencia).reversed()).collect(Collectors.toList());
    }

    public void deleteById(Long id) {
        CadastroMobiliario cadastroMobiliario = this.findCadastroMobiliarioById(id);
        this.cadastroMobiliarioRepository.delete((Object)cadastroMobiliario);
    }

    public Boolean existsCadastroMobiliarioByPessoa(Long pessoa) {
        List cadastros = this.cadastroMobiliarioRepository.findByPessoaId(pessoa);
        return !cadastros.isEmpty();
    }
}

