/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.ModeloCampoGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.ModeloGrupoGeomaisDTO;
import br.com.elotech.tributos.service.integracaogeomais.ModeloGrupoGeomaisService;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/modelo/grupo"})
public class ModeloGrupoGeomaisResource {
    private final ModeloGrupoGeomaisService modeloGrupoGeomaisService;

    public ModeloGrupoGeomaisResource(ModeloGrupoGeomaisService modeloGrupoGeomaisService) {
        this.modeloGrupoGeomaisService = modeloGrupoGeomaisService;
    }

    @GetMapping
    public ResponseEntity<Page<ModeloGrupoGeomaisDTO>> findAll(Pageable page) {
        Page grupos = this.modeloGrupoGeomaisService.findAll(page).map(ModeloGrupoGeomaisDTO::from);
        return ResponseEntity.ok((Object)grupos);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ModeloGrupoGeomaisDTO> findById(@PathVariable Long id) {
        ModeloGrupoGeomaisDTO modeloGrupoGeomaisDTO = this.modeloGrupoGeomaisService.findById((Serializable)id).map(ModeloGrupoGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Modelo Grupo com o id '%d'.", id)));
        return ResponseEntity.ok((Object)modeloGrupoGeomaisDTO);
    }

    @GetMapping(value={"/{id}/campos"})
    public ResponseEntity<List<ModeloCampoGeomaisDTO>> findCamposByIdGrupo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.modeloGrupoGeomaisService.findCamposByIdGrupo(id));
    }
}

