/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoItemDTO;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DevolucaoCreditoItemService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/devolucao-credito-item"})
public class DevolucaoCreditoItemResource {
    private final DevolucaoCreditoItemService devolucaoCreditoItemService;
    private final ContextService contextService;
    private final CadastroGeralService cadastroGeralService;

    public DevolucaoCreditoItemResource(DevolucaoCreditoItemService devolucaoCreditoItemService, ContextService contextService, CadastroGeralService cadastroGeralService) {
        this.devolucaoCreditoItemService = devolucaoCreditoItemService;
        this.contextService = contextService;
        this.cadastroGeralService = cadastroGeralService;
    }

    @GetMapping
    public ResponseEntity<DevolucaoCreditoItemDTO> findPagamento(@RequestParam String termo, @RequestParam Long cadastroGeral, @RequestParam Long tipoCadastro) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Pagamento pagamento = this.devolucaoCreditoItemService.findPagamentoByCamposBoleto(termo, entidade, cadastroGeral, tipoCadastro);
        DevolucaoCreditoItemDTO item = new DevolucaoCreditoItemDTO();
        CadastroGeral cadastroPagamento = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral).get();
        item = item.getPagamentoItem(pagamento, cadastroPagamento, tipoCadastro, entidade);
        return ResponseEntity.ok((Object)item);
    }
}

