/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.ImplantacaoSaldoReceitaDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoContabilidadeDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoContabilidadeGroupedDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoInformationDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoTributosDTO;
import br.com.elotech.tributos.repository.simam.ImplantacaoSaldoCustomRepository;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ImplantacaoSaldoCustomRepositoryImpl
implements ImplantacaoSaldoCustomRepository {
    private static final String ENTIDADE = "entidade";
    private static final String EXERCICIO = "exercicio";
    private static final String SITUACAO = "situacao";
    private static final String SITUACAO_LEGAL = "situacaoLegal";
    private static final String IDTIPOCREDITO = "idTipoCredito";
    private static final String RECEITA = "receita";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<ImplantacaoSaldoContabilidadeDTO> findDadosContabilidade(Long entidade, Long exercicio, String situacao) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(EXERCICIO, (Object)exercicio);
        parameters.addValue(SITUACAO, (Object)situacao);
        String sql = this.getSqlDadosContabilidade();
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ImplantacaoSaldoContabilidadeDTO.class));
    }

    public List<ImplantacaoSaldoContabilidadeGroupedDTO> findDadosContabilidadeGrouped(Long entidade, Long exercicio, String situacao) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(EXERCICIO, (Object)exercicio);
        parameters.addValue(SITUACAO, (Object)situacao);
        String sql = this.getSqlDadosContabilidadeGrouped();
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ImplantacaoSaldoContabilidadeGroupedDTO.class));
    }

    public ImplantacaoSaldoInformationDTO getInformationFromLastImplantacaoSaldo(Long entidade, Long exercicio, String situacao) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(EXERCICIO, (Object)exercicio);
        parameters.addValue(SITUACAO, (Object)situacao);
        String sql = this.getSqlInformationFromLastImplantacaoSaldo();
        return (ImplantacaoSaldoInformationDTO)this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, rs -> {
            if (rs.next()) {
                ImplantacaoSaldoInformationDTO dto = new ImplantacaoSaldoInformationDTO();
                dto.setUsuario(rs.getString("usuario"));
                dto.setDataCriacao(rs.getDate("datacriacao").toLocalDate());
                dto.setDataReferencia(rs.getDate("datareferencia").toLocalDate());
                dto.setCpfUsuario(rs.getString("usuariocriacao"));
                return dto;
            }
            throw new EloValidationException("Nenhum registro encontrado para o exerc\u00edcio selecionado.");
        });
    }

    public Page<ImplantacaoSaldoDebitoParcelaDTO> findDebitoParcelaTributos(ImplantacaoSaldoReceitaDTO dto, String situacao, Pageable pageable) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)dto.getEntidade());
        parameters.addValue(EXERCICIO, (Object)dto.getExercicio());
        parameters.addValue(SITUACAO, (Object)situacao);
        parameters.addValue(SITUACAO_LEGAL, (Object)dto.getSituacaoLegal());
        parameters.addValue(IDTIPOCREDITO, (Object)dto.getIdTipoCredito());
        parameters.addValue(RECEITA, (Object)dto.getReceita());
        String sql = this.getSqlDebitoParcelaTributos();
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sql);
        Long numeroTotal = (Long)this.namedParameterJdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)sql, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedRecords = this.namedParameterJdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ImplantacaoSaldoDebitoParcelaDTO.class));
        return new PageImpl(pagedRecords, pageable, numeroTotal.longValue());
    }

    public List<ImplantacaoSaldoTributosDTO> findTributosDetalhados(ImplantacaoSaldoReceitaDTO dto, String situacao) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)dto.getEntidade());
        parameters.addValue(EXERCICIO, (Object)dto.getExercicio());
        parameters.addValue(SITUACAO, (Object)situacao);
        parameters.addValue(SITUACAO_LEGAL, (Object)dto.getSituacaoLegal());
        parameters.addValue(IDTIPOCREDITO, (Object)dto.getIdTipoCredito());
        String sql = this.getSqlTributosDetalhados();
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ImplantacaoSaldoTributosDTO.class));
    }

    private String getSqlDadosContabilidade() {
        return "select tcii.idDebitoParcelaReceita,        tcii.situacaoLegal,        case when(tcii.situacaoLegal = 0) then 'N\u00e3o Inscrito em D\u00edvida Ativa'             else 'Inscrito em D\u00edvida Ativa'        end as situacaoLegalDescricao,        tcii.situacaoDebito,        tcii.valor,        tcii.dataLancamento,        tcii.dataSituacao,        tcii.dataDividaAtiva,        trt.classificacaoreceitatipo as ClassificacaoReceita,        tcrt.descricao as ClassificacaoReceitaDescricao,        case when tcrt.tributavel = 'S' then 'true' else 'false' end as tributavel,        tr.receita from tceControleImplantacaoItem tcii      join tribDebitoParcelaReceita     tdpr on tdpr.iddebitoparcelareceita = tcii.iddebitoparcelareceita      join tribreceita                  tr   on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio      join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo      join  (select max(id) as id             from tcecontroleimplantacao tcci2             where tcci2.entidade = :entidade             and tcci2.exercicio = :exercicio             and tcci2.situacao = :situacao      ) filtro on filtro.id = tcii.idcontrole order by tcii.situacaoLegal, tcii.dataLancamento";
    }

    private String getSqlDadosContabilidadeGrouped() {
        return "SELECT TCII.SITUACAOLEGAL,        TRT.CLASSIFICACAORECEITATIPO AS IDTIPOCREDITO,        SUM(TCII.VALOR) AS VALOR FROM TCECONTROLEIMPLANTACAOITEM TCII JOIN TRIBDEBITOPARCELARECEITA TDPR ON TDPR.IDDEBITOPARCELARECEITA = TCII.IDDEBITOPARCELARECEITA JOIN TRIBRECEITA TR ON TR.RECEITA = TDPR.RECEITA AND TR.EXERCICIO = TDPR.EXERCICIO JOIN TRIBRECEITATIPO TRT ON TRT.TIPORECEITA = TR.TIPORECEITA JOIN TRIBCLASSIFICACAORECEITATIPO TCRT ON TCRT.CLASSIFICACAORECEITATIPO = TRT.CLASSIFICACAORECEITATIPO JOIN   (SELECT MAX(ID) AS ID    FROM TCECONTROLEIMPLANTACAO TCCI2    WHERE TCCI2.ENTIDADE = :entidade      AND TCCI2.EXERCICIO = :exercicio      AND TCCI2.SITUACAO = :situacao ) FILTRO ON FILTRO.ID = TCII.IDCONTROLE GROUP BY TCII.SITUACAOLEGAL,          TRT.CLASSIFICACAORECEITATIPO ORDER BY TCII.SITUACAOLEGAL,          TRT.CLASSIFICACAORECEITATIPO";
    }

    private String getSqlTributosDetalhados() {
        return " SELECT TR.receita, TR.descricao, SUM(TCII.VALOR) AS VALOR  FROM TCECONTROLEIMPLANTACAOITEM TCII  JOIN TRIBDEBITOPARCELARECEITA TDPR ON TDPR.IDDEBITOPARCELARECEITA = TCII.IDDEBITOPARCELARECEITA  JOIN TRIBRECEITA TR ON TR.RECEITA = TDPR.RECEITA  AND TR.EXERCICIO = TDPR.EXERCICIO  JOIN TRIBRECEITATIPO TRT ON TRT.TIPORECEITA = TR.TIPORECEITA  JOIN TRIBCLASSIFICACAORECEITATIPO TCRT ON TCRT.CLASSIFICACAORECEITATIPO = TRT.CLASSIFICACAORECEITATIPO  JOIN    (SELECT MAX(ID) AS ID     FROM TCECONTROLEIMPLANTACAO TCCI2   WHERE TCCI2.ENTIDADE = :entidade  AND TCCI2.EXERCICIO = :exercicio  and TCCI2.SITUACAO = :situacao       ) FILTRO ON FILTRO.ID = TCII.IDCONTROLE where  TCII.SITUACAOLEGAL = :situacaoLegal AND TRT.CLASSIFICACAORECEITATIPO = :idTipoCredito      GROUP BY TR.receita, TR.descricao  ORDER BY TR.receita";
    }

    private String getSqlDebitoParcelaTributos() {
        return "SELECT TDPR.TIPOCADASTRO,         TDPR.CADASTROGERAL,         TDPR.EXERCICIO,         TDPR.GUIARECOLHIMENTO AS DIVIDA,         TDPR.SUBDIVIDA,         TDPR.PARCELA,         TDPR.RECEITA AS TRIBUTO,         TDPR.VALOR AS valorOriginal,         TCII.VALOR AS valorCorrecao,        DEBITO.IDDEBITO  FROM TCECONTROLEIMPLANTACAOITEM TCII  JOIN TRIBDEBITOPARCELARECEITA TDPR ON TDPR.IDDEBITOPARCELARECEITA = TCII.IDDEBITOPARCELARECEITA  JOIN TRIBDEBITO DEBITO ON DEBITO.ENTIDADE = TDPR.ENTIDADE  AND DEBITO.EXERCICIO = TDPR.EXERCICIO  AND DEBITO.TIPOCADASTRO = TDPR.TIPOCADASTRO  AND DEBITO.CADASTROGERAL = TDPR.CADASTROGERAL  AND DEBITO.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO  AND DEBITO.SUBDIVIDA = TDPR.SUBDIVIDA  JOIN TRIBRECEITA TR ON TR.RECEITA = TDPR.RECEITA  AND TR.EXERCICIO = TDPR.EXERCICIO  JOIN TRIBRECEITATIPO TRT ON TRT.TIPORECEITA = TR.TIPORECEITA  JOIN TRIBCLASSIFICACAORECEITATIPO TCRT ON TCRT.CLASSIFICACAORECEITATIPO = TRT.CLASSIFICACAORECEITATIPO  JOIN    (SELECT MAX(TCCI2.ID) AS ID     FROM TCECONTROLEIMPLANTACAO TCCI2     JOIN TCECONTROLEIMPLANTACAOITEM ITEM ON ITEM.IDCONTROLE = TCCI2.ID     JOIN TRIBDEBITOPARCELARECEITA TDPR ON TDPR.IDDEBITOPARCELARECEITA = ITEM.IDDEBITOPARCELARECEITA     JOIN TRIBRECEITA TR ON TR.RECEITA = TDPR.RECEITA     AND TR.EXERCICIO = TDPR.EXERCICIO     JOIN TRIBRECEITATIPO TRT ON TRT.TIPORECEITA = TR.TIPORECEITA     WHERE TCCI2.ENTIDADE = :entidade       AND TCCI2.EXERCICIO = :exercicio       AND TCCI2.SITUACAO = :situacao)  FILTRO ON FILTRO.ID = TCII.IDCONTROLE  WHERE TCII.SITUACAOLEGAL = :situacaoLegal  AND TRT.CLASSIFICACAORECEITATIPO = :idTipoCredito AND TR.RECEITA = :receita";
    }

    private String getSqlInformationFromLastImplantacaoSaldo() {
        return "SELECT TCCI.DATACRIACAO,  TCCI.DATAREFERENCIA, TCCI.USUARIOCRIACAO,        P.NOME AS usuario FROM TCECONTROLEIMPLANTACAO TCCI INNER JOIN PESSOA P ON P.PESSOA =   (SELECT MAX(P2.PESSOA)    FROM PESSOA P2    WHERE P2.CNPJ_CPF = TCCI.USUARIOCRIACAO) WHERE TCCI.ID =     (SELECT MAX(ID) AS ID      FROM TCECONTROLEIMPLANTACAO TCCI2      WHERE TCCI2.ENTIDADE = :entidade        AND TCCI2.EXERCICIO = :exercicio        AND TCCI2.SITUACAO = :situacao)";
    }

    @Generated
    public ImplantacaoSaldoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

