/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.repository.DebitoEmAbertoDTORowMapper;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.FiltroExtratoDebitoDTO;
import br.com.elotech.tributos.service.ContextService;
import java.sql.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoEmAbertoRepository {
    private static final String SQL_DEBITOS = "br/com/elotech/tributos/repository/find-debito-aberto.sql";
    private static final String SQL_EXTRATO_DEBITOS = "br/com/elotech/tributos/repository/extrato-debito-contribuinte.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ContextService contextService;

    public List<DebitoEmAbertoDTO> loadDebitoEmAberto(String filtro, Boolean somenteConstituidos) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SQL_DEBITOS)).append(" and ( ").append(filtro).append(" ) ");
        if (somenteConstituidos.booleanValue()) {
            sql.append(" and TRIBDEBITO.CONSTITUIDO = 'S'");
        }
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new DebitoEmAbertoDTORowMapper());
    }

    public List<ExtratoDebitoDTO> loadExtratoDebitosByFilter(String filtro) {
        String sql = FileUtils.readResourceAsString((String)SQL_EXTRATO_DEBITOS) + " and " + filtro;
        return this.jdbcTemplate.query(sql.replace("$[FILTROTODOSCADASTROS]", "0 as FILTROTODOSCADASTROS"), (SqlParameterSource)new MapSqlParameterSource(), (RowMapper)new ElotechBeanPropertyRowMapper(ExtratoDebitoDTO.class));
    }

    public List<ExtratoDebitoDTO> loadExtratoDebitosByFiltro(FiltroExtratoDebitoDTO filtro) {
        String sql = FileUtils.readResourceAsString((String)SQL_EXTRATO_DEBITOS).replace("$[FILTROTODOSCADASTROS]", filtro.getTodosCadastros() != false ? "1 as FILTROTODOSCADASTROS" : "0 as FILTROTODOSCADASTROS") + " and ( " + filtro.buildFilter() + " )  ORDER BY TD.IDDEBITO, TDP.PARCELA ";
        return this.jdbcTemplate.query(sql, (SqlParameterSource)this.getParameterSource(filtro), (RowMapper)new ElotechBeanPropertyRowMapper(ExtratoDebitoDTO.class));
    }

    private MapSqlParameterSource getParameterSource(FiltroExtratoDebitoDTO filtro) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("DATAATUAL", (Object)Date.valueOf(this.contextService.getDataAtual()));
        if (Objects.nonNull(filtro.getDataLancamentoInicial())) {
            params.addValue("DATALANCAMENTOINICIAL", (Object)filtro.getDataLancamentoInicial());
        }
        if (Objects.nonNull(filtro.getDataLancamentoFinal())) {
            params.addValue("DATALANCAMENTOFINAL", (Object)filtro.getDataLancamentoFinal());
        }
        if (Objects.nonNull(filtro.getDataVencimentoInicial())) {
            params.addValue("DATAVENCIMENTOINICIAL", (Object)filtro.getDataVencimentoInicial());
        }
        if (Objects.nonNull(filtro.getDataVencimentoFinal())) {
            params.addValue("DATAVENCIMENTOFINAL", (Object)filtro.getDataVencimentoFinal());
        }
        return params;
    }

    @Generated
    public DebitoEmAbertoRepository(NamedParameterJdbcTemplate jdbcTemplate, ContextService contextService) {
        this.jdbcTemplate = jdbcTemplate;
        this.contextService = contextService;
    }
}

