/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.TipoCertidaoDebitos;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import br.com.elotech.tributos.dto.RastreamentoProprietarioDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class RastreamentoCadastroDTO {
    private Long idCadastro;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long id;
    private String situacao;
    private TipoCertidaoDebitos tipoCertidaoDebitos;
    private String tipoLogradouro;
    private String logradouro;
    private String numero;
    private String bairro;
    private String cidade;
    private String unidadeFederacao;
    @JsonIgnore
    private List<RastreamentoDebitoDTO> debitos;
    @JsonIgnore
    private Set<RastreamentoProprietarioDTO> proprietarios;

    public static Set<RastreamentoCadastroDTO> agruparPorCadastro(List<RastreamentoProprietarioDTO> proprietarios) {
        Map<Long, List<RastreamentoProprietarioDTO>> proprietariosAgrupados = proprietarios.stream().collect(Collectors.groupingBy(RastreamentoProprietarioDTO::getIdCadastro));
        HashSet<RastreamentoCadastroDTO> cadastros = new HashSet<RastreamentoCadastroDTO>();
        proprietariosAgrupados.forEach((id, listProprietarios) -> {
            RastreamentoCadastroDTO cadastro = new RastreamentoCadastroDTO();
            cadastro.setId(id);
            cadastro.setIdCadastro(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getIdCadastro());
            cadastro.setTipoCadastro(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getTipoCadastro());
            cadastro.setCadastroGeral(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getCadastroGeral());
            cadastro.setSituacao(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getSituacao());
            cadastro.setProprietarios(listProprietarios.stream().collect(Collectors.toSet()));
            cadastro.setTipoLogradouro(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getTipoLogradouro());
            cadastro.setLogradouro(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getLogradouro());
            cadastro.setNumero(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getNumero());
            cadastro.setBairro(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getBairro());
            cadastro.setCidade(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getCidade());
            cadastro.setUnidadeFederacao(((RastreamentoProprietarioDTO)listProprietarios.get(0)).getUnidadeFederacao());
            cadastros.add(cadastro);
        });
        return cadastros;
    }

    public Boolean getRecursoAdministrativo() {
        if (Objects.isNull(this.debitos) || this.debitos.isEmpty()) {
            return Boolean.FALSE;
        }
        return this.debitos.stream().anyMatch(RastreamentoDebitoDTO::getRecursoAdministrativo);
    }

    public static TipoCertidaoDebitos getTipoCertidaoDebitos(Set<RastreamentoCadastroDTO> cadastros) {
        if (cadastros.stream().map(RastreamentoCadastroDTO::getTipoCertidaoDebitos).anyMatch(arg_0 -> TipoCertidaoDebitos.POSITIVA.equals(arg_0))) {
            return TipoCertidaoDebitos.POSITIVA;
        }
        if (cadastros.stream().map(RastreamentoCadastroDTO::getTipoCertidaoDebitos).anyMatch(arg_0 -> TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA.equals(arg_0))) {
            return TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA;
        }
        return TipoCertidaoDebitos.NEGATIVA;
    }

    public void calculaSituacaoDebitos(Boolean parametroCertidaoNegativaSemContrato, Boolean parametroConsideraContencioso) {
        if (Objects.nonNull(this.debitos)) {
            Boolean hasValorVencido = this.debitos.stream().anyMatch(debito -> debito.getVencido() != false && BigDecimal.ZERO.compareTo(debito.getValor()) < 0);
            Boolean hasValorAVencer = this.debitos.stream().anyMatch(debito -> debito.getAVencer() != false && BigDecimal.ZERO.compareTo(debito.getValor()) < 0);
            Boolean existeParcelamento = this.debitos.stream().anyMatch(RastreamentoDebitoDTO::existeParcelamento);
            Boolean todosDebitosVencidosTemContencioso = this.debitos.stream().filter(debito -> debito.getVencido() != false && BigDecimal.ZERO.compareTo(debito.getValor()) < 0).map(RastreamentoDebitoDTO::getIdContencioso).allMatch(Objects::nonNull);
            if (hasValorVencido.booleanValue()) {
                this.tipoCertidaoDebitos = TipoCertidaoDebitos.POSITIVA;
                if (parametroConsideraContencioso.booleanValue() && todosDebitosVencidosTemContencioso.booleanValue()) {
                    this.tipoCertidaoDebitos = TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA;
                }
            } else {
                this.tipoCertidaoDebitos = !hasValorAVencer.booleanValue() || parametroCertidaoNegativaSemContrato.booleanValue() && !existeParcelamento.booleanValue() ? TipoCertidaoDebitos.NEGATIVA : TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA;
            }
        } else {
            this.tipoCertidaoDebitos = TipoCertidaoDebitos.NEGATIVA;
        }
    }

    public Boolean certidaoPositivaDebitoCadastrosVinculados() {
        return Objects.nonNull(this.proprietarios) && this.proprietarios.stream().anyMatch(RastreamentoProprietarioDTO::getCertidaoPositivaDebitos);
    }

    public Boolean getCertidaoPositivaDebito() {
        return this.certidaoPositivaDebitoCadastro() != false || this.certidaoPositivaDebitoCadastrosVinculados() != false;
    }

    public Boolean certidaoPositivaDebitoCadastro() {
        return Objects.nonNull(this.tipoCertidaoDebitos) && !TipoCertidaoDebitos.NEGATIVA.equals((Object)this.tipoCertidaoDebitos);
    }

    @JsonProperty(value="proprietarios")
    public List<RastreamentoProprietarioDTO> getSortedProprietarios() {
        if (Objects.nonNull(this.proprietarios)) {
            return this.proprietarios.stream().sorted(Comparator.comparing(RastreamentoProprietarioDTO::getCpfCnpj)).collect(Collectors.toList());
        }
        return new ArrayList<RastreamentoProprietarioDTO>();
    }

    public String getSituacaoDebitos() {
        return this.tipoCertidaoDebitos.getSituacaoDebito();
    }

    @Generated
    public RastreamentoCadastroDTO() {
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public TipoCertidaoDebitos getTipoCertidaoDebitos() {
        return this.tipoCertidaoDebitos;
    }

    @Generated
    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    @Generated
    public List<RastreamentoDebitoDTO> getDebitos() {
        return this.debitos;
    }

    @Generated
    public Set<RastreamentoProprietarioDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setTipoCertidaoDebitos(TipoCertidaoDebitos tipoCertidaoDebitos) {
        this.tipoCertidaoDebitos = tipoCertidaoDebitos;
    }

    @Generated
    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    @Generated
    public void setDebitos(List<RastreamentoDebitoDTO> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setProprietarios(Set<RastreamentoProprietarioDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public String toString() {
        return "RastreamentoCadastroDTO(idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", id=" + this.getId() + ", situacao=" + this.getSituacao() + ", tipoCertidaoDebitos=" + this.getTipoCertidaoDebitos() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", logradouro=" + this.getLogradouro() + ", numero=" + this.getNumero() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", unidadeFederacao=" + this.getUnidadeFederacao() + ", debitos=" + this.getDebitos() + ", proprietarios=" + this.getProprietarios() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RastreamentoCadastroDTO)) {
            return false;
        }
        RastreamentoCadastroDTO other = (RastreamentoCadastroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RastreamentoCadastroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

