/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.SituacaoVencimentoEnum;
import br.com.elotech.tributos.domain.TipoExtratoDebitoEnum;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroExtratoDebitoDTO {
    private List<Long> idsCadastro;
    private Boolean todosCadastros = Boolean.FALSE;
    private TipoExtratoDebitoEnum filtroCard;
    private LocalDate dataLancamentoInicial;
    private LocalDate dataLancamentoFinal;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private Long situacaoLegal;
    private Long situacaoParcela;
    private String ano;
    private String divida;
    private SituacaoVencimentoEnum situacaoVencimento;

    public String buildFilter() {
        ArrayList<String> filtros = new ArrayList<String>();
        filtros.add(String.format("tcg.idkey in (%s)", StringUtils.join((Iterable)this.idsCadastro, (String)", ")));
        if (Objects.nonNull(this.filtroCard) && !TipoExtratoDebitoEnum.TODOS.equals((Object)this.filtroCard)) {
            filtros.add(this.filtroCard.getFiltro());
        }
        if (Objects.nonNull(this.dataLancamentoInicial)) {
            filtros.add("tdp.datalancamento >= :DATALANCAMENTOINICIAL");
        }
        if (Objects.nonNull(this.dataLancamentoFinal)) {
            filtros.add("tdp.datalancamento <= :DATALANCAMENTOFINAL");
        }
        if (Objects.nonNull(this.dataVencimentoInicial)) {
            filtros.add("tdp.datavencimento >= :DATAVENCIMENTOINICIAL");
        }
        if (Objects.nonNull(this.dataVencimentoFinal)) {
            filtros.add("tdp.datavencimento <= :DATAVENCIMENTOFINAL");
        }
        if (Objects.nonNull(this.situacaoLegal)) {
            filtros.add(String.format("tdp.situacaolegal = %s", this.situacaoLegal));
        }
        if (Objects.nonNull(this.situacaoParcela)) {
            filtros.add(String.format("tsp.situacaoparcela = %s", this.situacaoParcela));
        }
        if (StringUtils.isNotBlank((CharSequence)this.ano)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.ano, (String)"td.exercicio"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.divida, (String)"td.guiarecolhimento"));
        }
        if (SituacaoVencimentoEnum.VENCIDOS.equals((Object)this.situacaoVencimento)) {
            filtros.add("tdp.datavencimento < :DATAATUAL");
        }
        if (SituacaoVencimentoEnum.A_VENCER.equals((Object)this.situacaoVencimento)) {
            filtros.add("tdp.datavencimento >= :DATAATUAL");
        }
        return String.join((CharSequence)" and ", filtros);
    }

    @Generated
    public FiltroExtratoDebitoDTO() {
    }

    @Generated
    public List<Long> getIdsCadastro() {
        return this.idsCadastro;
    }

    @Generated
    public Boolean getTodosCadastros() {
        return this.todosCadastros;
    }

    @Generated
    public TipoExtratoDebitoEnum getFiltroCard() {
        return this.filtroCard;
    }

    @Generated
    public LocalDate getDataLancamentoInicial() {
        return this.dataLancamentoInicial;
    }

    @Generated
    public LocalDate getDataLancamentoFinal() {
        return this.dataLancamentoFinal;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getSituacaoParcela() {
        return this.situacaoParcela;
    }

    @Generated
    public String getAno() {
        return this.ano;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public SituacaoVencimentoEnum getSituacaoVencimento() {
        return this.situacaoVencimento;
    }

    @Generated
    public void setIdsCadastro(List<Long> idsCadastro) {
        this.idsCadastro = idsCadastro;
    }

    @Generated
    public void setTodosCadastros(Boolean todosCadastros) {
        this.todosCadastros = todosCadastros;
    }

    @Generated
    public void setFiltroCard(TipoExtratoDebitoEnum filtroCard) {
        this.filtroCard = filtroCard;
    }

    @Generated
    public void setDataLancamentoInicial(LocalDate dataLancamentoInicial) {
        this.dataLancamentoInicial = dataLancamentoInicial;
    }

    @Generated
    public void setDataLancamentoFinal(LocalDate dataLancamentoFinal) {
        this.dataLancamentoFinal = dataLancamentoFinal;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setSituacaoParcela(Long situacaoParcela) {
        this.situacaoParcela = situacaoParcela;
    }

    @Generated
    public void setAno(String ano) {
        this.ano = ano;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSituacaoVencimento(SituacaoVencimentoEnum situacaoVencimento) {
        this.situacaoVencimento = situacaoVencimento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroExtratoDebitoDTO)) {
            return false;
        }
        FiltroExtratoDebitoDTO other = (FiltroExtratoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$idsCadastro = this.getIdsCadastro();
        List other$idsCadastro = other.getIdsCadastro();
        if (this$idsCadastro == null ? other$idsCadastro != null : !((Object)this$idsCadastro).equals(other$idsCadastro)) {
            return false;
        }
        Boolean this$todosCadastros = this.getTodosCadastros();
        Boolean other$todosCadastros = other.getTodosCadastros();
        if (this$todosCadastros == null ? other$todosCadastros != null : !((Object)this$todosCadastros).equals(other$todosCadastros)) {
            return false;
        }
        TipoExtratoDebitoEnum this$filtroCard = this.getFiltroCard();
        TipoExtratoDebitoEnum other$filtroCard = other.getFiltroCard();
        if (this$filtroCard == null ? other$filtroCard != null : !this$filtroCard.equals(other$filtroCard)) {
            return false;
        }
        LocalDate this$dataLancamentoInicial = this.getDataLancamentoInicial();
        LocalDate other$dataLancamentoInicial = other.getDataLancamentoInicial();
        if (this$dataLancamentoInicial == null ? other$dataLancamentoInicial != null : !((Object)this$dataLancamentoInicial).equals(other$dataLancamentoInicial)) {
            return false;
        }
        LocalDate this$dataLancamentoFinal = this.getDataLancamentoFinal();
        LocalDate other$dataLancamentoFinal = other.getDataLancamentoFinal();
        if (this$dataLancamentoFinal == null ? other$dataLancamentoFinal != null : !((Object)this$dataLancamentoFinal).equals(other$dataLancamentoFinal)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        Long this$situacaoLegal = this.getSituacaoLegal();
        Long other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        Long this$situacaoParcela = this.getSituacaoParcela();
        Long other$situacaoParcela = other.getSituacaoParcela();
        if (this$situacaoParcela == null ? other$situacaoParcela != null : !((Object)this$situacaoParcela).equals(other$situacaoParcela)) {
            return false;
        }
        String this$ano = this.getAno();
        String other$ano = other.getAno();
        if (this$ano == null ? other$ano != null : !this$ano.equals(other$ano)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        SituacaoVencimentoEnum this$situacaoVencimento = this.getSituacaoVencimento();
        SituacaoVencimentoEnum other$situacaoVencimento = other.getSituacaoVencimento();
        return !(this$situacaoVencimento == null ? other$situacaoVencimento != null : !this$situacaoVencimento.equals(other$situacaoVencimento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroExtratoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $idsCadastro = this.getIdsCadastro();
        result = result * 59 + ($idsCadastro == null ? 43 : ((Object)$idsCadastro).hashCode());
        Boolean $todosCadastros = this.getTodosCadastros();
        result = result * 59 + ($todosCadastros == null ? 43 : ((Object)$todosCadastros).hashCode());
        TipoExtratoDebitoEnum $filtroCard = this.getFiltroCard();
        result = result * 59 + ($filtroCard == null ? 43 : $filtroCard.hashCode());
        LocalDate $dataLancamentoInicial = this.getDataLancamentoInicial();
        result = result * 59 + ($dataLancamentoInicial == null ? 43 : ((Object)$dataLancamentoInicial).hashCode());
        LocalDate $dataLancamentoFinal = this.getDataLancamentoFinal();
        result = result * 59 + ($dataLancamentoFinal == null ? 43 : ((Object)$dataLancamentoFinal).hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        Long $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        Long $situacaoParcela = this.getSituacaoParcela();
        result = result * 59 + ($situacaoParcela == null ? 43 : ((Object)$situacaoParcela).hashCode());
        String $ano = this.getAno();
        result = result * 59 + ($ano == null ? 43 : $ano.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        SituacaoVencimentoEnum $situacaoVencimento = this.getSituacaoVencimento();
        result = result * 59 + ($situacaoVencimento == null ? 43 : $situacaoVencimento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroExtratoDebitoDTO(idsCadastro=" + this.getIdsCadastro() + ", todosCadastros=" + this.getTodosCadastros() + ", filtroCard=" + this.getFiltroCard() + ", dataLancamentoInicial=" + this.getDataLancamentoInicial() + ", dataLancamentoFinal=" + this.getDataLancamentoFinal() + ", dataVencimentoInicial=" + this.getDataVencimentoInicial() + ", dataVencimentoFinal=" + this.getDataVencimentoFinal() + ", situacaoLegal=" + this.getSituacaoLegal() + ", situacaoParcela=" + this.getSituacaoParcela() + ", ano=" + this.getAno() + ", divida=" + this.getDivida() + ", situacaoVencimento=" + this.getSituacaoVencimento() + ")";
    }
}

