/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.requerimento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItem;
import br.com.elotech.tributos.domain.requerimento.RequerimentoObservacao;
import br.com.elotech.tributos.domain.requerimento.RequerimentoObservacaoId;
import br.com.elotech.tributos.domain.requerimento.RequerimentoParcela;
import br.com.elotech.tributos.domain.requerimento.RequerimentoParcelaId;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;

@Table(name="tribrequerimento")
@Entity
public class Requerimento
implements EloEntity<RequerimentoId> {
    @EmbeddedId
    private RequerimentoId id;
    @ManyToOne
    @JoinColumn(name="pessoa")
    private Pessoa pessoa;
    @ManyToOne
    @JoinColumn(name="tiporequerimento")
    @JsonIgnoreProperties(value={"divida"})
    private TipoRequerimento tipoRequerimento;
    private LocalDate dataRequerimento;
    private LocalDate data;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral")})
    @JsonIgnoreProperties(value={"proprietarios", "cadastroGeralIsencoes", "cadastroImobiliarioAvaliacoes", "cadastroImobiliarioSegmentos", "cadastroImobiliarioTestadas", "boletinsImobiliarioTerreno", "imobiliarioTestadasGenericas"})
    private CadastroGeral cadastroGeral;
    private Long idProcesso;
    private Long exercicioProcesso;
    private String usuario;
    private Long exercicioDebito;
    @Column(name="guiarecolhimento")
    private Long divida;
    private Long subDivida;
    private Long numeroParcelas;
    @JsonIgnoreProperties(value={"requerimento"})
    @OneToMany(mappedBy="requerimento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<RequerimentoObservacao> observacoes = new ArrayList();
    @JsonIgnoreProperties(value={"requerimento"})
    @OneToMany(mappedBy="requerimento", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="descricao")
    private List<RequerimentoItem> itens = new ArrayList();
    @JsonIgnoreProperties(value={"requerimento"})
    @OneToMany(mappedBy="requerimento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<RequerimentoParcela> parcelas = new ArrayList();
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exerciciobloqueto", referencedColumnName="exercicioBloqueto")), @JoinColumnOrFormula(column=@JoinColumn(name="bloqueto", referencedColumnName="bloqueto"))})
    private Bloqueto boleto;

    public BigDecimal getValorTotalItens() {
        return this.itens.stream().map(RequerimentoItem::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorTotalParcelas() {
        return this.parcelas.stream().map(RequerimentoParcela::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void addObservacoes(List<String> observacoes) {
        AtomicLong sequenciaObservacao = new AtomicLong(1L);
        this.getObservacoes().addAll(observacoes.stream().map(observacaoDto -> {
            RequerimentoObservacao observacao = new RequerimentoObservacao();
            observacao.setId(new RequerimentoObservacaoId(this.getId(), Long.valueOf(sequenciaObservacao.getAndIncrement())));
            observacao.setObservacao(observacaoDto);
            return observacao;
        }).collect(Collectors.toList()));
    }

    public void addParcela(LocalDate dataVencimento) {
        RequerimentoParcelaId parcelaId = new RequerimentoParcelaId(this.getId());
        RequerimentoParcela parcela = new RequerimentoParcela();
        parcela.setId(parcelaId);
        parcela.setDataVencimento(dataVencimento);
        parcela.setValor(this.getValorTotalItens());
        this.getParcelas().add(parcela);
        this.setNumeroParcelas(Long.valueOf(this.getParcelas().size()));
    }

    @Generated
    public Requerimento() {
    }

    @Generated
    public RequerimentoId getId() {
        return this.id;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public TipoRequerimento getTipoRequerimento() {
        return this.tipoRequerimento;
    }

    @Generated
    public LocalDate getDataRequerimento() {
        return this.dataRequerimento;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getNumeroParcelas() {
        return this.numeroParcelas;
    }

    @Generated
    public List<RequerimentoObservacao> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<RequerimentoItem> getItens() {
        return this.itens;
    }

    @Generated
    public List<RequerimentoParcela> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public Bloqueto getBoleto() {
        return this.boleto;
    }

    @Generated
    public void setId(RequerimentoId id) {
        this.id = id;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoRequerimento(TipoRequerimento tipoRequerimento) {
        this.tipoRequerimento = tipoRequerimento;
    }

    @Generated
    public void setDataRequerimento(LocalDate dataRequerimento) {
        this.dataRequerimento = dataRequerimento;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setExercicioDebito(Long exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setNumeroParcelas(Long numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    @Generated
    public void setObservacoes(List<RequerimentoObservacao> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setItens(List<RequerimentoItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setParcelas(List<RequerimentoParcela> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setBoleto(Bloqueto boleto) {
        this.boleto = boleto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Requerimento)) {
            return false;
        }
        Requerimento other = (Requerimento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RequerimentoId this$id = this.getId();
        RequerimentoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Requerimento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequerimentoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Requerimento(id=" + this.getId() + ")";
    }
}

