/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config.outbox;

import br.com.elotech.multitenant.client.TenantClient;
import br.com.elotech.multitenant.domain.Tenant;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.multitenant.hook.TenantAfterCreateDataSource;
import br.com.elotech.outbox.publisher.SchedulerPublisher;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutBoxRegisterScheduleTenant
implements TenantAfterCreateDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OutBoxRegisterScheduleTenant.class);
    private final SchedulerPublisher schedulerPublisher;
    private final TenantClient tenantClient;

    public DataSource process(DataSource dataSource) {
        String tenantId = TenantContextHolder.getTenant().getId();
        log.info("Registrando Outbox Scheduler para o tenant {}", (Object)tenantId);
        this.schedulerPublisher.registerPolling(() -> this.poolingOutboxEvents(tenantId));
        return dataSource;
    }

    private void poolingOutboxEvents(String tenantId) {
        Tenant tenant = (Tenant)this.tenantClient.getTenant(tenantId).orElseThrow(() -> {
            log.info(String.format("Tenant '%s' not found.", tenantId));
            return new IllegalStateException(String.format("O tenant '%s' n\u00e3o est\u00e1 registrado. N\u00e3o ser\u00e1 poss\u00edvel prosseguir.", tenantId));
        });
        if (!tenant.isAtivo()) {
            log.info(String.format("Tenant '%s' is disabled.", tenantId));
            throw new IllegalArgumentException(String.format("O tenant '%s' n\u00e3o est\u00e1 ativo", tenantId));
        }
        log.debug("Outbox polling for tenant {}", (Object)tenant.getId());
        TenantContextHolder.setTenant((Tenant)tenant);
    }

    @Generated
    public OutBoxRegisterScheduleTenant(SchedulerPublisher schedulerPublisher, TenantClient tenantClient) {
        this.schedulerPublisher = schedulerPublisher;
        this.tenantClient = tenantClient;
    }
}

