/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.annotations.AutoCompleteDetail;
import br.com.elotech.tributos.calculo.annotations.AutoCompleteParameter;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.TabelaValorColuna;
import br.com.elotech.tributos.calculo.dto.AuxiliaresCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.calculo.dto.FuncaoDetalheDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioSegmentoDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioTestadaDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioTestadaGenericaDTO;
import br.com.elotech.tributos.calculo.dto.MobiliarioAtividadeDTO;
import br.com.elotech.tributos.calculo.dto.MobiliarioCnaeDTO;
import br.com.elotech.tributos.calculo.dto.MobiliarioDTO;
import br.com.elotech.tributos.calculo.dto.MobiliarioServicoDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.repository.CalculoTributoRepository;
import br.com.elotech.tributos.calculo.repository.CalculoTributoScriptRepository;
import br.com.elotech.tributos.calculo.service.CalculoTributoService;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.CalculoTributoScript;
import br.com.elotech.tributos.domain.calculo.TipoCalculoTributo;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import br.com.elotech.tributos.repository.camposdinamicos.CampoRepository;
import br.com.elotech.tributos.service.camposdinamicos.GrupoCampoService;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CalculoTributoService
extends CrudService<CalculoTributo, Long> {
    private final CalculoTributoRepository calculoTributoRepository;
    private final CalculoTributoScriptRepository calculoTributoScriptRepository;
    private final TabelaValorService tabelaValorService;
    private final GrupoCampoService grupoCampoService;
    private final CampoRepository campoRepository;

    public CalculoTributoService(CalculoTributoRepository calculoTributoRepository, CalculoTributoScriptRepository calculoTributoScriptRepository, TabelaValorService tabelaValorService, GrupoCampoService grupoCampoService, CampoRepository campoRepository) {
        this.calculoTributoRepository = calculoTributoRepository;
        this.calculoTributoScriptRepository = calculoTributoScriptRepository;
        this.tabelaValorService = tabelaValorService;
        this.grupoCampoService = grupoCampoService;
        this.campoRepository = campoRepository;
    }

    protected void beforeSave(CalculoTributo entity, Authentication authentication) {
        Optional identificadorDuplicado = entity.getIdentificadorDuplicado();
        if (identificadorDuplicado.isPresent()) {
            throw new EloValidationException(String.format("Identificador %s est\u00e1 duplicado.", identificadorDuplicado.get()));
        }
        this.calculoTributoRepository.existsCalculoTributoComConflito(entity.getId(), entity.getExercicio(), entity.getDivida().getId(), entity.getTributo().getId()).ifPresent(calculoTributo -> {
            throw new EloValidationException(String.format("J\u00e1 existe um registro para o exerc\u00edcio %d, d\u00edvida %d e tributo %s.", entity.getExercicio(), entity.getDivida().getDivida(), entity.getTributo().getTributo()));
        });
        this.validaCamposDinamicos(entity);
        entity.getScript().forEach(linha -> linha.setCalculoTributo(entity));
    }

    private void validaCamposDinamicos(CalculoTributo calculoTributo) {
        List camposDinamicosTributo = calculoTributo.getScript().stream().filter(calculoTributoScript -> Objects.nonNull(calculoTributoScript.getCampoDinamico())).map(CalculoTributoScript::getCampoDinamico).collect(Collectors.toList());
        List ocorrenciasOutrosTributos = this.getCamposDinamicosCalculoPorDivida(calculoTributo.getDivida().getTipoDivida()).stream().filter(calculoTributoScript -> Objects.nonNull(calculoTributoScript.getCampoDinamico())).filter(calculoTributoScript -> !calculoTributo.getTributo().getTributo().equals(calculoTributoScript.getTributo()) && camposDinamicosTributo.stream().anyMatch(campo -> campo.equals((Object)calculoTributoScript.getCampoDinamico()))).collect(Collectors.toList());
        if (Boolean.FALSE.equals(ocorrenciasOutrosTributos.isEmpty())) {
            throw new EloValidationException(String.format("Existem campos din\u00e2micos selecionados em outros Tributos:%n%s", ocorrenciasOutrosTributos.stream().map(calculoTributoScript -> String.format("%s-%s (%s)", calculoTributoScript.getTributo(), calculoTributoScript.getIdentificador(), calculoTributoScript.getCampoDinamico().getIdentificador())).collect(Collectors.joining(", "))));
        }
    }

    public List<CalculoTributo> findByDividasAndExercicio(List<Divida> divida, Long exercicio) {
        return this.calculoTributoRepository.findByDividaInAndExercicio(divida, exercicio);
    }

    public List<CalculoTributo> findByDividasAndExercicioJoinFetchScript(List<Divida> divida, Long exercicio) {
        List idsDividas = divida.stream().map(Divida::getId).collect(Collectors.toList());
        List tributos = this.calculoTributoRepository.findByDividasAndExercicioJoinFetchScript(idsDividas, exercicio);
        tributos.forEach(calculoTributo -> calculoTributo.getScript().forEach(calculoTributoScript -> {
            if (Objects.nonNull(calculoTributoScript.getCampoDinamico())) {
                Campo campo = (Campo)Hibernate.unproxy((Object)calculoTributoScript.getCampoDinamico());
                Hibernate.initialize((Object)campo.getGrupoCampo());
                calculoTributoScript.setCampoDinamico(campo);
            }
        }));
        return tributos;
    }

    public AuxiliaresCalculoDTO getAuxiliares(Long exercicio, TipoDivida tipoDivida) {
        AuxiliaresCalculoDTO result = new AuxiliaresCalculoDTO();
        result.setFuncoes(this.getFuncoesFromContext());
        result.setTabelasValor(this.getTabelasValor(exercicio));
        if (Objects.nonNull(tipoDivida)) {
            result.setCamposDinamicos(this.getCamposDinamicos(tipoDivida));
            result.setCamposFixos(this.getCamposFixos(tipoDivida));
            result.setCamposDinamicosOutrosTributos(this.getCamposDinamicosCalculoPorDivida(tipoDivida));
        }
        return result;
    }

    private List<CampoDetalheDTO> getCamposFixos(TipoDivida tipoDivida) {
        ArrayList<CampoDetalheDTO> result = new ArrayList<CampoDetalheDTO>();
        if (TipoCadastro.IMOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida))) {
            result.addAll(this.getCamposFixos(ImobiliarioDTO.class, CampoDetalheDTO.OrigemCampoDetalhe.CADASTRO));
            result.addAll(this.getCamposFixos(ImobiliarioSegmentoDTO.class, CampoDetalheDTO.OrigemCampoDetalhe.SEGMENTO));
            result.addAll(this.getCamposFixos(ImobiliarioTestadaDTO.class, CampoDetalheDTO.OrigemCampoDetalhe.TESTADA));
            result.addAll(this.getCamposFixos(ImobiliarioTestadaGenericaDTO.class, CampoDetalheDTO.OrigemCampoDetalhe.TESTADA_GENERICA));
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida))) {
            result.addAll(this.getCamposFixos(MobiliarioDTO.class, CampoDetalheDTO.OrigemCampoDetalhe.CADASTRO));
            result.addAll(this.getCamposFixos(MobiliarioAtividadeDTO.class, CampoDetalheDTO.OrigemCampoDetalhe.ATIVIDADE));
            result.addAll(this.getCamposFixos(MobiliarioCnaeDTO.class, CampoDetalheDTO.OrigemCampoDetalhe.CNAE));
            result.addAll(this.getCamposFixos(MobiliarioServicoDTO.class, CampoDetalheDTO.OrigemCampoDetalhe.SERVICO));
        }
        return result;
    }

    @VisibleForTesting
    List<CampoDetalheDTO> getCamposFixos(Class classToExtract, CampoDetalheDTO.OrigemCampoDetalhe origem) {
        return Stream.of(classToExtract.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AutoCompleteDetail.class)).map(field -> {
            AutoCompleteDetail annotation = field.getAnnotation(AutoCompleteDetail.class);
            return new CampoDetalheDTO(field.getName(), annotation.label(), origem, this.parseClass(field.getType()));
        }).sorted(Comparator.comparing(CampoDetalheDTO::getOrigem).thenComparing(CampoDetalheDTO::getNome)).collect(Collectors.toList());
    }

    private TipoCampo parseClass(Class<?> type) {
        if (type.equals(Long.class)) {
            return TipoCampo.INTEIRO;
        }
        if (type.equals(Double.class)) {
            return TipoCampo.DECIMAL;
        }
        return TipoCampo.TEXTO;
    }

    private List<CampoDetalheDTO> getCamposDinamicos(TipoDivida tipoDivida) {
        if (TipoCadastro.IMOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida))) {
            return this.grupoCampoService.getCampoDetalhesPorFuncionalidade(Arrays.asList(FuncionalidadeCampo.TERRENO, FuncionalidadeCampo.SEGMENTO, FuncionalidadeCampo.LOGRADOURO));
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida))) {
            return this.grupoCampoService.getCampoDetalhesPorFuncionalidade(Collections.singletonList(FuncionalidadeCampo.MOBILIARIO));
        }
        return new ArrayList<CampoDetalheDTO>();
    }

    public List<CalculoTributoScript> getCamposDinamicosCalculoPorDivida(TipoDivida tipoDivida) {
        return this.calculoTributoScriptRepository.findByCampoDinamicoNotNullAndCalculoTributoDividaTipoDividaIs(tipoDivida);
    }

    public List<Campo> getCamposDinamicosCalculo(String search, TipoDivida tipoDivida, TipoCalculoTributo tipoCalculoTributo) {
        ArrayList<Campo> campos = new ArrayList<Campo>();
        if (TipoCalculoTributo.SEGMENTO.equals((Object)tipoCalculoTributo)) {
            campos.addAll(this.campoRepository.findAllByArmazenaResultadoCalculoTrueAndGrupoCampoFuncionalidadeIn(Collections.singletonList(FuncionalidadeCampo.SEGMENTO)));
        } else {
            switch (1.$SwitchMap$br$com$elotech$tributos$domain$TipoCadastro[Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida).ordinal()]) {
                case 1: {
                    campos.addAll(this.campoRepository.findAllByArmazenaResultadoCalculoTrueAndGrupoCampoFuncionalidadeIn(Collections.singletonList(FuncionalidadeCampo.TERRENO)));
                    break;
                }
                case 2: {
                    campos.addAll(this.campoRepository.findAllByArmazenaResultadoCalculoTrueAndGrupoCampoFuncionalidadeIn(Collections.singletonList(FuncionalidadeCampo.MOBILIARIO)));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)search)) {
            return campos.stream().filter(item -> item.getIdentificador().toLowerCase().contains(search.toLowerCase()) || item.getDescricao().toLowerCase().contains(search.toLowerCase())).collect(Collectors.toList());
        }
        return campos;
    }

    private List<FuncaoDetalheDTO> getTabelasValor(Long exercicio) {
        return this.tabelaValorService.findByExercicio(exercicio).stream().map(tabelaValor -> {
            FuncaoDetalheDTO detail = new FuncaoDetalheDTO();
            detail.setNome(tabelaValor.getNome());
            detail.setDescricao(tabelaValor.getDescricao());
            List colunasParametros = tabelaValor.getColunasParametros();
            detail.setNumeroParametros(Integer.valueOf(colunasParametros.size()));
            String nomeParametros = colunasParametros.stream().map(TabelaValorColuna::getDescricao).collect(Collectors.joining(", "));
            detail.setNomeParametros(nomeParametros);
            return detail;
        }).sorted(Comparator.comparing(FuncaoDetalheDTO::getNome)).collect(Collectors.toList());
    }

    private List<FuncaoDetalheDTO> getFuncoesFromContext() {
        return Stream.of(CalculoContext.class.getDeclaredMethods()).filter(field -> field.isAnnotationPresent(AutoCompleteDetail.class)).map(method -> {
            if (Stream.of(method.getParameters()).anyMatch(parameter -> !parameter.isAnnotationPresent(AutoCompleteParameter.class))) {
                throw new CalculoException(String.format("O m\u00e9todo %s possui par\u00e2metros sem a anota\u00e7\u00e3o @AutoCompleteParameter", method.getName()));
            }
            AutoCompleteDetail annotation = method.getAnnotation(AutoCompleteDetail.class);
            FuncaoDetalheDTO detail = new FuncaoDetalheDTO();
            detail.setNome(method.getName());
            detail.setDescricao(annotation.label());
            detail.setNumeroParametros(Integer.valueOf(method.getParameterCount()));
            String nomeParametros = Stream.of(method.getParameters()).map(parameter -> {
                AutoCompleteParameter parameterAnnotation = parameter.getAnnotation(AutoCompleteParameter.class);
                return parameterAnnotation.value();
            }).collect(Collectors.joining(", "));
            detail.setNomeParametros(nomeParametros);
            return detail;
        }).sorted(Comparator.comparing(FuncaoDetalheDTO::getNome)).collect(Collectors.toList());
    }
}

