/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.dto.VariavelDTO;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public class CalculoResultadoDTO {
    private String identificadorValor;
    private String identificadorValorBase;
    private String identificadorCondicao;
    private String identificadorAliquota;
    private ClassificacaoTipoTributo classificacaoTipoTributo;
    private Map<String, Double> cache;
    private Map<String, List<VariavelDTO>> trace;

    public Double getValor() {
        return Optional.ofNullable((Double)this.cache.get(this.identificadorValor)).orElse(0.0);
    }

    public Double getValorBase() {
        return Optional.ofNullable((Double)this.cache.get(this.identificadorValorBase)).orElse(0.0);
    }

    public Double getValorCondicao() {
        return Optional.ofNullable((Double)this.cache.get(this.identificadorCondicao)).orElse(0.0);
    }

    public Double getValorAliquota() {
        return Optional.ofNullable(this.identificadorAliquota).map(this.cache::get).orElse(0.0);
    }

    public Boolean ignoradoPorCondicaoCalculo() {
        if (StringUtils.isBlank((String)this.identificadorCondicao)) {
            return Boolean.FALSE;
        }
        Double valorCondicao = (Double)this.cache.get(this.identificadorCondicao);
        return valorCondicao.compareTo(0.0) == 0;
    }

    @Generated
    public CalculoResultadoDTO() {
    }

    @Generated
    public String getIdentificadorValor() {
        return this.identificadorValor;
    }

    @Generated
    public String getIdentificadorValorBase() {
        return this.identificadorValorBase;
    }

    @Generated
    public String getIdentificadorCondicao() {
        return this.identificadorCondicao;
    }

    @Generated
    public String getIdentificadorAliquota() {
        return this.identificadorAliquota;
    }

    @Generated
    public ClassificacaoTipoTributo getClassificacaoTipoTributo() {
        return this.classificacaoTipoTributo;
    }

    @Generated
    public Map<String, Double> getCache() {
        return this.cache;
    }

    @Generated
    public Map<String, List<VariavelDTO>> getTrace() {
        return this.trace;
    }

    @Generated
    public void setIdentificadorValor(String identificadorValor) {
        this.identificadorValor = identificadorValor;
    }

    @Generated
    public void setIdentificadorValorBase(String identificadorValorBase) {
        this.identificadorValorBase = identificadorValorBase;
    }

    @Generated
    public void setIdentificadorCondicao(String identificadorCondicao) {
        this.identificadorCondicao = identificadorCondicao;
    }

    @Generated
    public void setIdentificadorAliquota(String identificadorAliquota) {
        this.identificadorAliquota = identificadorAliquota;
    }

    @Generated
    public void setClassificacaoTipoTributo(ClassificacaoTipoTributo classificacaoTipoTributo) {
        this.classificacaoTipoTributo = classificacaoTipoTributo;
    }

    @Generated
    public void setCache(Map<String, Double> cache) {
        this.cache = cache;
    }

    @Generated
    public void setTrace(Map<String, List<VariavelDTO>> trace) {
        this.trace = trace;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoResultadoDTO)) {
            return false;
        }
        CalculoResultadoDTO other = (CalculoResultadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$identificadorValor = this.getIdentificadorValor();
        String other$identificadorValor = other.getIdentificadorValor();
        if (this$identificadorValor == null ? other$identificadorValor != null : !this$identificadorValor.equals(other$identificadorValor)) {
            return false;
        }
        String this$identificadorValorBase = this.getIdentificadorValorBase();
        String other$identificadorValorBase = other.getIdentificadorValorBase();
        if (this$identificadorValorBase == null ? other$identificadorValorBase != null : !this$identificadorValorBase.equals(other$identificadorValorBase)) {
            return false;
        }
        String this$identificadorCondicao = this.getIdentificadorCondicao();
        String other$identificadorCondicao = other.getIdentificadorCondicao();
        if (this$identificadorCondicao == null ? other$identificadorCondicao != null : !this$identificadorCondicao.equals(other$identificadorCondicao)) {
            return false;
        }
        String this$identificadorAliquota = this.getIdentificadorAliquota();
        String other$identificadorAliquota = other.getIdentificadorAliquota();
        if (this$identificadorAliquota == null ? other$identificadorAliquota != null : !this$identificadorAliquota.equals(other$identificadorAliquota)) {
            return false;
        }
        ClassificacaoTipoTributo this$classificacaoTipoTributo = this.getClassificacaoTipoTributo();
        ClassificacaoTipoTributo other$classificacaoTipoTributo = other.getClassificacaoTipoTributo();
        if (this$classificacaoTipoTributo == null ? other$classificacaoTipoTributo != null : !this$classificacaoTipoTributo.equals(other$classificacaoTipoTributo)) {
            return false;
        }
        Map this$cache = this.getCache();
        Map other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        Map this$trace = this.getTrace();
        Map other$trace = other.getTrace();
        return !(this$trace == null ? other$trace != null : !((Object)this$trace).equals(other$trace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoResultadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identificadorValor = this.getIdentificadorValor();
        result = result * 59 + ($identificadorValor == null ? 43 : $identificadorValor.hashCode());
        String $identificadorValorBase = this.getIdentificadorValorBase();
        result = result * 59 + ($identificadorValorBase == null ? 43 : $identificadorValorBase.hashCode());
        String $identificadorCondicao = this.getIdentificadorCondicao();
        result = result * 59 + ($identificadorCondicao == null ? 43 : $identificadorCondicao.hashCode());
        String $identificadorAliquota = this.getIdentificadorAliquota();
        result = result * 59 + ($identificadorAliquota == null ? 43 : $identificadorAliquota.hashCode());
        ClassificacaoTipoTributo $classificacaoTipoTributo = this.getClassificacaoTipoTributo();
        result = result * 59 + ($classificacaoTipoTributo == null ? 43 : $classificacaoTipoTributo.hashCode());
        Map $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        Map $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : ((Object)$trace).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoResultadoDTO(identificadorValor=" + this.getIdentificadorValor() + ", identificadorValorBase=" + this.getIdentificadorValorBase() + ", identificadorCondicao=" + this.getIdentificadorCondicao() + ", identificadorAliquota=" + this.getIdentificadorAliquota() + ", classificacaoTipoTributo=" + this.getClassificacaoTipoTributo() + ", cache=" + this.getCache() + ", trace=" + this.getTrace() + ")";
    }
}

