/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.domain.TabelaValorCelula;
import br.com.elotech.tributos.calculo.domain.TipoCampo;
import br.com.elotech.tributos.calculo.dto.TabelaValorParametroDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TABELAVALORCOLUNA")
public class TabelaValorColuna
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="STABELAVALORCOLUNA", applyOnMerge=true)
    private Long id;
    @NotNull
    private Long coluna;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TipoCampo tipo;
    @NotBlank
    @Length(max=250)
    private @NotBlank @Length(max=250) String descricao;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idtabelavalor", updatable=false)
    private TabelaValor tabelaValor;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="coluna")
    @OrderBy(value="linha")
    private List<TabelaValorCelula> celulas = new ArrayList();

    public String getDescricao() {
        return StringUtils.lowerCase((String)this.descricao);
    }

    public void setDescricao(String descricao) {
        this.descricao = StringUtils.lowerCase((String)descricao);
    }

    public static TabelaValorColuna of(TabelaValorParametroDTO dto) {
        TabelaValorColuna tabelaValorColuna = new TabelaValorColuna();
        tabelaValorColuna.setId(dto.getId());
        tabelaValorColuna.setDescricao(dto.getNome());
        tabelaValorColuna.setColuna(dto.getOrdem());
        tabelaValorColuna.setTipo(dto.getTipo());
        return tabelaValorColuna;
    }

    public void addCelula(TabelaValorCelula celula) {
        celula.setColuna(this);
        this.celulas.add(celula);
    }

    public String getReferenciaColuna() {
        if ("resultado".equalsIgnoreCase(this.getDescricao())) {
            return this.getDescricao();
        }
        return this.coluna.toString();
    }

    @Generated
    public TabelaValorColuna() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getColuna() {
        return this.coluna;
    }

    @Generated
    public TipoCampo getTipo() {
        return this.tipo;
    }

    @Generated
    public TabelaValor getTabelaValor() {
        return this.tabelaValor;
    }

    @Generated
    public List<TabelaValorCelula> getCelulas() {
        return this.celulas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setColuna(Long coluna) {
        this.coluna = coluna;
    }

    @Generated
    public void setTipo(TipoCampo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setTabelaValor(TabelaValor tabelaValor) {
        this.tabelaValor = tabelaValor;
    }

    @Generated
    public void setCelulas(List<TabelaValorCelula> celulas) {
        this.celulas = celulas;
    }

    @Generated
    public String toString() {
        return "TabelaValorColuna(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabelaValorColuna)) {
            return false;
        }
        TabelaValorColuna other = (TabelaValorColuna)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TabelaValorColuna;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

