/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.implantacaosaldo;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldo;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldoConsultaDTO;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldoItem;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.MudancaMonetariaService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImplantacaoSaldoBatchProcessor
implements ItemProcessor<ImplantacaoSaldoConsultaDTO, ImplantacaoSaldoItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplantacaoSaldoBatchProcessor.class);
    private static final String LOG_PARAM = "SIM-AM - Implanta\u00e7\u00e3o de Saldo - ";
    private final Map<Long, FormaCorrecao> formasDeCorrecao = new ConcurrentHashMap();
    private final Map<Long, FormaCorrecao> outrasFormasDeCorrecao = new ConcurrentHashMap();
    private LocalDate dataReferencia = null;
    private Long idControle = null;
    private StepExecution stepExecution;
    private List<MudancaMonetaria> mudancasMonetarias = new ArrayList();
    private final EntityManager entityManager;
    private final FormaCorrecaoService formaCorrecaoService;
    private final MudancaMonetariaService mudancaMonetariaService;

    public ImplantacaoSaldoBatchProcessor(EntityManager entityManager, FormaCorrecaoService formaCorrecaoService, MudancaMonetariaService mudancaMonetariaService) {
        this.entityManager = entityManager;
        this.formaCorrecaoService = formaCorrecaoService;
        this.mudancaMonetariaService = mudancaMonetariaService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("SIM-AM - Implanta\u00e7\u00e3o de Saldo - Iniciando gera\u00e7\u00e3o de dados");
        this.idControle = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("idControle"));
        this.dataReferencia = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataReferencia")));
        LOGGER.info("SIM-AM - Implanta\u00e7\u00e3o de Saldo - Criando lista das formas de corre\u00e7\u00f5es existentes");
        this.formaCorrecaoService.findAll(Pageable.unpaged()).getContent().stream().map(FormaCorrecao::getId).forEach(idFormaCorrecao -> this.formasDeCorrecao.put(idFormaCorrecao, this.formaCorrecaoService.findOne(idFormaCorrecao)));
        this.mudancasMonetarias = this.mudancaMonetariaService.findByRsql(Optional.empty());
    }

    public ImplantacaoSaldoItem process(ImplantacaoSaldoConsultaDTO item) {
        ImplantacaoSaldoItem implantacaoSaldoItem = new ImplantacaoSaldoItem();
        implantacaoSaldoItem.setImplantacaoSaldo((ImplantacaoSaldo)this.entityManager.getReference(ImplantacaoSaldo.class, (Object)this.idControle));
        implantacaoSaldoItem.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
        implantacaoSaldoItem.setClassificacaoTipoTributo(ClassificacaoTipoTributo.fromValue((Integer)item.getClassificacaoReceita().intValue()));
        implantacaoSaldoItem.setSituacaoLegal(SituacaoLegal.fromValue((Integer)item.getSituacaoLegal().intValue()));
        implantacaoSaldoItem.setSituacaoDebito((SituacaoParcela)this.entityManager.getReference(SituacaoParcela.class, (Object)item.getSituacaoDebito()));
        implantacaoSaldoItem.setDataLancamento(item.getDataLancamento());
        implantacaoSaldoItem.setDataSituacao(item.getDataSituacao());
        implantacaoSaldoItem.setDataDividaAtiva(item.getDataDividaAtiva());
        FormaCorrecao formaCorrecao = null;
        formaCorrecao = Objects.nonNull(item.getFormaCorrecao()) ? (FormaCorrecao)this.formasDeCorrecao.get(item.getFormaCorrecao()) : Optional.ofNullable((FormaCorrecao)this.outrasFormasDeCorrecao.get(item.getIdDivida())).orElseGet(() -> {
            FormaCorrecao fc = this.formaCorrecaoService.getFormaCorrecaoPadrao(item.getIdDivida(), item.getEntidade(), item.getExercicio());
            this.outrasFormasDeCorrecao.put(item.getIdDivida(), fc);
            return fc;
        });
        implantacaoSaldoItem.setValor(CalculoCorrecaoUtils.converteMoedaOuAplicaMudanca((BigDecimal)item.getValor(), (LocalDate)item.getDataLancamento(), (LocalDate)this.dataReferencia, (FormaCorrecao)formaCorrecao, (List)this.mudancasMonetarias));
        return implantacaoSaldoItem;
    }

    @OnProcessError
    public void onProcessError(ImplantacaoSaldoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error("SIM-AM - Implanta\u00e7\u00e3o de Saldo - Erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item));
        throw e;
    }
}

