/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaomonetariada;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.AtualizacaoMonetariaDAParcelamentoReceitaDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class AtualizacaoMonetariaCreditoParcelamentoDABatchReader
extends JdbcCursorItemReader<AtualizacaoMonetariaDAParcelamentoReceitaDTO> {
    public AtualizacaoMonetariaCreditoParcelamentoDABatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataFinal")));
        String entidade = String.valueOf(jobParameters.get("entidade"));
        this.setFetchSize(1000);
        this.setName("atualizacaoMonetariaDAParcelamentoReceitaPrincipal");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoMonetariaDAParcelamentoReceitaDTO.class));
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoMonetariaDAParcelamentoReceitaPrincipal.sql");
        sqlLancamentos = sqlLancamentos.replace(":entidade", entidade);
        sqlLancamentos = sqlLancamentos.replace(":dataInicial", String.format("'%s'", dataInicial));
        sqlLancamentos = sqlLancamentos.replace(":dataFinal", String.format("'%s'", dataFinal));
        this.setSql(sqlLancamentos);
    }
}

