select 3                                                   as idTipoOperacaoCredito,
       case when (tcrt.tributavel = 'S') then 1 else 2 end as idTipoNaturezaCredito,
       trt.classificacaoreceitatipo                        as idTipoCredito,
       tdpd.datadividaativa                                as dtInscricao,
       coalesce(tdpro.valororiginal, tdpro.valor)          as vlInscricao,
       tdpro.iddebitoparcelareceita                        as idDebitoParcelaTributoOrigem,
       tdprd.iddebitoparcelareceita                        as idDebitoParcelaTributoDestino,
       td.formacorrecao                                    as formaCorrecao,
       tgr.idkey                                           as idDivida,
       td.entidade                                         as entidade,
       td.exercicio                                        as exercicio
from tribdebito td
         join tribdebitoparcela tdpo
              on tdpo.entidade = td.entidade
                  and tdpo.exercicio = td.exercicio
                  and tdpo.tipocadastro = td.tipocadastro /*DebitoParcela Origem*/
                  and tdpo.cadastrogeral = td.cadastrogeral
                  and tdpo.guiarecolhimento = td.guiarecolhimento
                  and tdpo.subdivida = td.subdivida
         join tribdebitoparcelareceita tdpro
              on tdpro.entidade = tdpo.entidade
                  and tdpro.exercicio = tdpo.exercicio
                  and tdpro.tipocadastro = tdpo.tipocadastro /*DebitoParcelaReceita Origem*/
                  and tdpro.cadastrogeral = tdpo.cadastrogeral
                  and tdpro.guiarecolhimento = tdpo.guiarecolhimento
                  and tdpro.subdivida = tdpo.subdivida
                  and tdpro.parcela = tdpo.parcela
         join triblivroparcelareceita tlpr
              on tlpr.iddebitoparcelareceita = tdpro.iddebitoparcelareceita
         join triblivro tl
              on tlpr.entidade = tl.entidade
                  and tlpr.exercicio = tl.exercicio
                  and tlpr.livro = tl.livro
         join tribguiarecolhimento tgr
              on td.entidade = tgr.entidade
                  and td.exercicio = tgr.exercicio
                  and td.guiarecolhimento = tgr.guiarecolhimento
         join tribdebitoparcelareceita tdprd
              on tdprd.entidade = tdpro.entidade
                  and tdprd.exercicio = tdpro.exercicio
                  and tdprd.tipocadastro = tdpro.tipocadastro /*DebitoParcelaReceita Destino*/
                  and tdprd.cadastrogeral = tdpro.cadastrogeral
                  and tdprd.guiarecolhimento = tdpro.guiarecolhimento
                  and tdprd.subdivida = tlpr.novasubdivida
                  and tdprd.receita = tdpro.receita
                  and (
                    (tl.englobaparcelas = 'S' and tgr.tipoguiarecolhimento != 'H')
                          or
                      (
                          (tl.englobaparcelas = 'N' or tgr.tipoguiarecolhimento = 'H')
                                  and tdprd.parcela = tdpro.parcela)
                      )
         join tribdebitoparcela tdpd
              on tdpd.entidade = tdprd.entidade
                  and tdpd.exercicio = tdprd.exercicio
                  and tdpd.tipocadastro = tdprd.tipocadastro /*DebitoParcela Destino*/
                  and tdpd.cadastrogeral = tdprd.cadastrogeral
                  and tdpd.guiarecolhimento = tdprd.guiarecolhimento
                  and tdpd.subdivida = tdprd.subdivida
                  and tdpd.parcela = tdprd.parcela
         join tribreceita tr
              on tr.receita = tdprd.receita
                  and tr.exercicio = tdprd.exercicio
                  and tr.entidade = tdprd.entidade
         join tribreceitatipo trt
              on trt.tiporeceita = tr.tiporeceita
         join tribclassificacaoreceitatipo tcrt
              on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
where trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
  and tdpd.situacaolegal IN (1, 2)
  and td.constituido = 'S'
  and tdpd.datadividaativa between :dataInicial and :dataFinal
  and td.entidade = :entidade
  and  coalesce(tdpro.valororiginal, tdpro.valor) > 0
  and not exists(
        select 1
        from tceDebitoInscCreditoDA tdicDA
        where tdicDA.iddebitoparcelareceitaorigem = tdpro.iddebitoparcelareceita
    )
order by tdpd.datadividaativa,
         case
             when (tcrt.tributavel = 'S') then 1
             else 2
             end,
         trt.classificacaoreceitatipo,
         tdprd.iddebitoparcelareceita, tdpro.iddebitoparcelareceita