SELECT :idPessoa AS idPessoa,
       filtro.nrAnoDivida,
       filtro.nrDivida,
       filtro.nrAnoEstorno,
       filtro.cdControleLeiAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo
FROM (
         select extract(year from te.dataestorno) as nrAnoEstorno,
                tic.nrdivida                      as nrDivida,
                tic.nranodivida                   as nrAnoDivida,
                ca.idtce                          as cdControleLeiAto,
                te.dataestorno                    as dtEstorno,
                sum(tdic.valor)                   as vlEstorno,
                substr(tmd.descricao, 0, 250)     as dsMotivo
         from triblivroestornoparcelareceita tlepr
                  join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tlepr.iddebitoparcelareceita
                  join triblivroparcelareceita tlpr on tlpr.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                  join triblivroestorno te on te.idlivroestorno = tlepr.idlivroestorno
                  left join tceDebitoInscCreditoDA tdic on tdic.iddebitoparcelareceitaorigem = tlepr.iddebitoparcelareceita
                  left join tceInscCreditoDA tic on tic.idtceinsccreditoda = tdic.idtceinsccreditoda
                  join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio
                  join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                  join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  left join tribmotivodesconto tmd on tmd.motivodesconto = tlepr.motivocancelamento
                  left join cgato ca on ca.entidade = tmd.entidade and ca.idato = tmd.idato
         where trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
           and te.dataestorno between :dataInicial and :dataFinal
           and tlepr.entidade = :entidade
           and tlpr.estornado = 'S'
         group by te.dataestorno,
                  tic.nrdivida,
                  tic.nranodivida,
                  ca.idtce,
                  tmd.descricao) filtro
ORDER BY filtro.nrAnoDivida,
         filtro.nrDivida