SELECT filtro.idTipoDeducaoCredito,
       filtro.dtDeducao,
       filtro.valor,
       filtro.dsMotivo,
       filtro.entidade,
       filtro.exercicio,
       filtro.idCancelamento,
       filtro.idpagamentobloqueto,
       filtro.iddebitoparcelareceita,
       filtro.idcreditocontribuinteitem
FROM
  (SELECT td.tipotce AS idTipoDeducaoCredito,
          cd.datacancelamento AS dtDeducao,
          coalesce(tcdi.valorAtualizado, tcdi.valor) AS valor,
          substr(md.descricao || '.' || coalesce(cd.motivo, ''), 0, 250) AS dsMotivo,
          tcdi.entidade,
          tcdi.exercicio,
          tcdi.idcancelamento,
          0 AS idpagamentobloqueto,
          tcdi.iddebitoparcelareceita,
          0 AS idcreditocontribuinteitem
   FROM tribcancelamentodebito cd
   JOIN tribcancelamentodebitoitem tcdi ON tcdi.entidade = cd.entidade
   AND tcdi.exercicio = cd.exercicio
   AND tcdi.idcancelamento = cd.idcancelamento
   LEFT JOIN tribmotivodesconto md ON md.motivodesconto = cd.motivocancelamento
   LEFT JOIN tribtipodeducao td ON td.tipodeducao = coalesce(md.tipodeducao, cd.tipodeducao)
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
   JOIN tribreceita tr ON tr.entidade = tdpr.entidade
   AND tr.exercicio = tdpr.exercicio
   AND tr.receita = tdpr.receita
   JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
   JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
   WHERE (cd.datacancelamento BETWEEN :dataInicial AND :dataFinal)
     AND cd.entidade = :entidade
     AND td.tipotce in (1,2,3,4,5,6)
     AND tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
     AND cd.situacaolegal in (1,2)
     AND NOT EXISTS
       (SELECT 1
        FROM tceDeducaoCancelamentoDA tdcda
        WHERE tdcda.entidade = tcdi.entidade
          AND tdcda.exercicio = tcdi.exercicio
          AND tdcda.idcancelamento = tcdi.idcancelamento
          AND tdcda.iddebitoparcelareceita = tcdi.iddebitoparcelareceita )
   UNION ALL SELECT ttd.tipotce AS idTipoDeducaoCredito,
                    tp.datalancamento AS dtDeducao,
                    tpd.valordesconto AS valor,
                    substr(tmd.descricao || '.' || coalesce(tbad.observacao, ''), 0, 250) AS dsMotivo,
                    tp.entidade,
                    tp.exerciciopagamento AS exercicio,
                    0 AS idcancelamento,
                    tpd.idpagamentobloqueto,
                    tpd.iddebitoparcelareceita,
                    0 AS idcreditocontribuinteitem
   FROM tribpagamentodebito tpd
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade
   AND tdp.exercicio = tdpr.exercicio
   AND tdp.tipocadastro = tdpr.tipocadastro
   AND tdp.cadastrogeral = tdpr.cadastrogeral
   AND tdp.guiarecolhimento = tdpr.guiarecolhimento
   AND tdp.subdivida = tdpr.subdivida
   AND tdp.parcela = tdpr.parcela
   JOIN tribpagamentobloqueto tpb ON tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
   JOIN tribpagamento tp ON tp.entidade = tpb.entidade
   AND tp.exerciciopagamento = tpb.exerciciopagamento
   AND tp.pagamento = tpb.pagamento
   LEFT JOIN tribbaixaautomaticadetalhe tbad ON tbad.entidade = tp.entidade
   AND tbad.exerciciopagamento = tp.exerciciopagamento
   AND tbad.pagamento = tp.pagamento
   LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tpb.motivodesconto
   LEFT JOIN tribtipodeducao ttd ON ttd.tipodeducao = tmd.tipodeducao
   JOIN tribreceita tr ON tr.exercicio = tdpr.exercicio
   AND tr.receita = tdpr.receita
   AND tr.entidade = tdpr.entidade
   JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
   JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
   WHERE tp.datalancamento BETWEEN :dataInicial AND :dataFinal
     AND tp.entidade = :entidade
     AND tpd.valordesconto > 0
     AND tdp.situacaolegal in (1,  2)
     AND ttd.tipotce in (1,2,3,4,5,6)
     AND tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
     AND NOT EXISTS
       (SELECT 1
        FROM tceDeducaoPagamentoDA tdpda
        WHERE tdpda.iddebitoparcelareceita = tpd.iddebitoparcelareceita
          AND tdpda.idPagamentoBloqueto = tpd.idPagamentoBloqueto )
   UNION ALL SELECT ttd.tipotce AS idTipoDeducaoCredito,
                    tcc.datacredito AS dtDeducao,
                    tcci.valordesconto AS valor,
                    substr(tmd.descricao, 0, 250) AS dsMotivo,
                    tcc.entidade,
                    tcc.exercicio,
                    0 AS idcancelamento,
                    0 AS idpagamentobloqueto,
                    tcci.iddebitoparcelareceita,
                    tcci.idcreditocontribuinteitem
   FROM tribbaixaautomaticadetalhe tbad
   JOIN tribcreditocontribuinte tcc ON tcc.entidade = tbad.entidade
   AND tcc.exercicio = tbad.exerciciocredito
   AND tcc.creditocontribuinte = tbad.creditocontribuinte
   JOIN tribCreditoContribuinteItem tcci ON tcci.entidade = tcc.entidade
   AND tcci.exercicio = tcc.exercicio
   AND tcci.creditocontribuinte = tcc.creditocontribuinte
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade
   AND tdp.exercicio = tdpr.exercicio
   AND tdp.tipocadastro = tdpr.tipocadastro
   AND tdp.cadastrogeral = tdpr.cadastrogeral
   AND tdp.guiarecolhimento = tdpr.guiarecolhimento
   AND tdp.subdivida = tdpr.subdivida
   AND tdp.parcela = tdpr.parcela
   JOIN tribbloqueto tb ON tb.entidade = tbad.entidade
   AND tb.exerciciobloqueto = tbad.exerciciobloqueto
   AND tb.bloqueto = tbad.bloqueto
   JOIN tribGuiaRecolhimentoFormaPag tgrfp ON tgrfp.entidade = tdpr.entidade
   AND tgrfp.exercicio = tdpr.exercicio
   AND tgrfp.guiarecolhimento = tdpr.guiarecolhimento
   AND tgrfp.formapagamento = tb.formapagamento
   JOIN tribreceita tr ON tr.exercicio = tdpr.exercicio
   AND tr.receita = tdpr.receita
   JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
   JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
   LEFT JOIN tribMotivoDesconto tmd ON tmd.motivodesconto = coalesce(tgrfp.motivodesconto, tb.motivodesconto)
   LEFT JOIN tribTipoDeducao ttd ON ttd.tipodeducao = tmd.tipodeducao
   WHERE tcc.entidade = :entidade
     AND tcc.datacredito BETWEEN :dataInicial AND :dataFinal
     AND tcci.valordesconto > 0
     AND tdp.situacaolegal in (1,2)
     AND ttd.tipotce in (1,2,3,4,5,6)
     AND tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
     AND NOT EXISTS
       (SELECT 1
        FROM tceDeducaoCreditoCreditoDA tdcc
        WHERE tdcc.idCreditoContribuinteItem = tcci.idcreditocontribuinteitem
          AND tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita ) ) filtro
ORDER BY filtro.dtDeducao,
         filtro.idTipoDeducaoCredito