select case when (tr.classificacao = 'J') then 1 
            when (tr.classificacao = 'M') then 2 else 3 end as idTipoAtualizacaoCredito, 
       tp.dataparcelamento as dtAtualizacao, 
       :receitaPrincipal as receitaPrincipal, 
       tr.receita, 
       tr.classificacao, 
       tp.idParcelamento, 
       sum(tdpr.valor) as vlAtualizacao 
from tribparcelamento              tp 
join tribparcelamentodebitoorigem  tpdo  on tpdo.idParcelamento = tp.idparcelamento 
join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo 
join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio 
                                        and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral 
                                        and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida 
join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio 
                                        and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral 
                                        and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida 
                                        and tdpr.parcela = tdp.parcela 
join tribguiarecolhimentoreceita   tgrr  on tgrr.entidade = tdpr.entidade and tgrr.exercicio = tdpr.exercicio 
                                        and tgrr.guiarecolhimento = tdpr.guiarecolhimento and tgrr.receita = :receitaPrincipal 
join tribguiareceitaespelho        tgre  on tgre.entidade = tgrr.entidade and tgre.exercicio = tgrr.exercicio 
                                        and tgre.guiarecolhimento = tgrr.guiarecolhimento 
                                        and (tgre.jurosdestino = tdpr.receita or tgre.multadestino = tdpr.receita or tgre.correcaodestino = tdpr.receita) 
join tribreceita                   tr    on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita 
where tp.idparcelamento = :idparcelamento 
  and tr.classificacao in ('J','M','C') 
  and tgre.receita = :receitaPrincipal 
group by tr.receita, tr.classificacao,  tp.idparcelamento, tgre.receita 
order by tp.idparcelamento,idTipoAtualizacaoCredito
