SELECT DISTINCT
       :idPessoa AS idPessoa,
       tam.nratualizacao,
       tam.nranoatualizacao,
       tlc.nrcredito,
       tlc.nranocredito,
       ca.idtce AS cdControleLeiAto,
       tam.idtipoatualizacaocredito,
       tam.dtatualizacao,
       tam.vlatualizacao
FROM tceAtualizaMoneCred tam
LEFT JOIN tceAtualizaMonePagamento tamp ON tamp.idtceatualizamonecred = tam.idtceatualizamonecred
LEFT JOIN tribpagamentodebito tpd ON tpd.idpagamentobloqueto = tamp.idpagamentobloqueto
AND tpd.iddebitoparcelareceita = tamp.iddebitoparcelareceita
LEFT JOIN tribpagamentobloqueto tpb ON tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
LEFT JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
LEFT JOIN tribguiarecolhimento tgr ON tgr.entidade = tdpr.entidade
AND tgr.exercicio = tdpr.exercicio
AND tgr.guiarecolhimento = tdpr.guiarecolhimento
LEFT JOIN tceAtualizaMoneCredito tamc ON tamc.idtceatualizamonecred = tam.idtceatualizamonecred
LEFT JOIN tribcreditocontribuinteitem tcci ON tcci.idcreditocontribuinteitem = tamc.idcreditocontribuinteitem
AND tcci.iddebitoparcelareceita = tamc.iddebitoparcelareceita
LEFT JOIN tribcreditocontribuinte tcc ON tcc.entidade = tcci.entidade
AND tcc.exercicio = tcci.exercicio
AND tcc.creditocontribuinte = tcci.creditocontribuinte
LEFT JOIN tribdebitoparcelareceita tdprc ON tdprc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
LEFT JOIN tribguiarecolhimento tgrc ON tgrc.entidade = tdprc.entidade
AND tgrc.exercicio = tdprc.exercicio
AND tgrc.guiarecolhimento = tdprc.guiarecolhimento
LEFT JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = coalesce(tpd.iddebitoparcelareceita, tcci.iddebitoparcelareceita)
LEFT JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
LEFT JOIN cgato ca ON ca.entidade = coalesce(tgr.entidade, tgrc.entidade)
AND ca.idato = coalesce(tgr.fundamentolegal, tgrc.fundamentolegal)
WHERE tam.dtatualizacao BETWEEN :dataInicial AND :dataFinal
  AND coalesce(tpb.entidade, tcc.entidade) = :entidade
ORDER BY tam.nratualizacao,
         tam.nranoatualizacao