/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.tributos.dto.SimamGeracaoDadosDTO;
import br.com.elotech.tributos.service.batch.simam.ArrecadacaoCreditoJobStarter;
import br.com.elotech.tributos.service.batch.simam.AtualizacaoCreditoJobStarter;
import br.com.elotech.tributos.service.batch.simam.AtualizacaoMonetariaCreditoDAJobStarter;
import br.com.elotech.tributos.service.batch.simam.DeducaoCreditoDividaAtivaJobStarter;
import br.com.elotech.tributos.service.batch.simam.DeducaoCreditoJobStarter;
import br.com.elotech.tributos.service.batch.simam.ImplantacaoSaldoJobStarter;
import br.com.elotech.tributos.service.batch.simam.InscricaoDividaAtivaImplantacaoSaldoJobStarter;
import br.com.elotech.tributos.service.batch.simam.InscricaoDividaAtivaJobStarter;
import br.com.elotech.tributos.service.batch.simam.LancamentoCreditoImplantacaoSaldoJobStarter;
import br.com.elotech.tributos.service.batch.simam.LancamentoCreditoJobStarter;
import br.com.elotech.tributos.service.simam.SimAmGeracaoDadosService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SimAmGeracaoDadosService {
    private final LancamentoCreditoJobStarter lancamentoCreditoJobStarter;
    private final ImplantacaoSaldoJobStarter implantacaoSaldoJobStarter;
    private final LancamentoCreditoImplantacaoSaldoJobStarter lancamentoCreditoImplantacaoSaldoJobStarter;
    private final DeducaoCreditoJobStarter deducaoCreditoJobStarter;
    private final AtualizacaoCreditoJobStarter atualizacaoCreditoJobStarter;
    private final InscricaoDividaAtivaJobStarter inscricaoDividaAtivaJobStarter;
    private final InscricaoDividaAtivaImplantacaoSaldoJobStarter inscricaoDividaAtivaImplantacaoSaldoJobStarter;
    private final AtualizacaoMonetariaCreditoDAJobStarter atualizacaoMonetariaCreditoDAJobStarter;
    private final DeducaoCreditoDividaAtivaJobStarter deducaoCreditoDividaAtivaJobStarter;
    private final ArrecadacaoCreditoJobStarter arrecadacaoCreditoJobStarter;

    public void iniciarTarefa(SimamGeracaoDadosDTO dados) throws Exception {
        LocalDate dataInicial = Objects.nonNull(dados.getExercicio()) && Objects.nonNull(dados.getCompetencia()) ? LocalDate.of(dados.getExercicio().intValue(), dados.getCompetencia().intValue(), 1) : null;
        LocalDate dataFinal = Objects.nonNull(dataInicial) ? dataInicial.with(TemporalAdjusters.lastDayOfMonth()) : null;
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$simam$TipoProcessamentoDadosSimAm[dados.getTipoArquivo().ordinal()]) {
            case 1: {
                this.implantacaoSaldoJobStarter.startJob(dados.getEntidade(), dados.getExercicio(), dados.getDataFinal());
                break;
            }
            case 2: {
                this.lancamentoCreditoImplantacaoSaldoJobStarter.startJob(dados.getEntidade(), dados.getExercicio());
                break;
            }
            case 3: {
                this.lancamentoCreditoJobStarter.startJob(dados.getEntidade(), dataInicial, dataFinal);
                break;
            }
            case 4: {
                this.inscricaoDividaAtivaJobStarter.startJob(dados.getEntidade(), dataInicial, dataFinal);
                break;
            }
            case 5: {
                this.inscricaoDividaAtivaImplantacaoSaldoJobStarter.startJob(dados.getEntidade(), dados.getExercicio());
                break;
            }
            case 6: {
                this.deducaoCreditoJobStarter.startJob(dataInicial, dataFinal, dados.getEntidade());
                break;
            }
            case 7: {
                this.atualizacaoMonetariaCreditoDAJobStarter.startJob(dataInicial, dataFinal, dados.getEntidade());
                break;
            }
            case 8: {
                this.atualizacaoCreditoJobStarter.startJob(dataInicial, dataFinal, dados.getEntidade());
                break;
            }
            case 9: {
                this.deducaoCreditoDividaAtivaJobStarter.startJob(dataInicial, dataFinal, dados.getEntidade());
                break;
            }
            case 10: {
                this.arrecadacaoCreditoJobStarter.startJob(dataInicial, dataFinal, dados.getEntidade());
                break;
            }
            default: {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Tipo de arquivo n\u00e3o implementado");
            }
        }
    }

    @Generated
    public SimAmGeracaoDadosService(LancamentoCreditoJobStarter lancamentoCreditoJobStarter, ImplantacaoSaldoJobStarter implantacaoSaldoJobStarter, LancamentoCreditoImplantacaoSaldoJobStarter lancamentoCreditoImplantacaoSaldoJobStarter, DeducaoCreditoJobStarter deducaoCreditoJobStarter, AtualizacaoCreditoJobStarter atualizacaoCreditoJobStarter, InscricaoDividaAtivaJobStarter inscricaoDividaAtivaJobStarter, InscricaoDividaAtivaImplantacaoSaldoJobStarter inscricaoDividaAtivaImplantacaoSaldoJobStarter, AtualizacaoMonetariaCreditoDAJobStarter atualizacaoMonetariaCreditoDAJobStarter, DeducaoCreditoDividaAtivaJobStarter deducaoCreditoDividaAtivaJobStarter, ArrecadacaoCreditoJobStarter arrecadacaoCreditoJobStarter) {
        this.lancamentoCreditoJobStarter = lancamentoCreditoJobStarter;
        this.implantacaoSaldoJobStarter = implantacaoSaldoJobStarter;
        this.lancamentoCreditoImplantacaoSaldoJobStarter = lancamentoCreditoImplantacaoSaldoJobStarter;
        this.deducaoCreditoJobStarter = deducaoCreditoJobStarter;
        this.atualizacaoCreditoJobStarter = atualizacaoCreditoJobStarter;
        this.inscricaoDividaAtivaJobStarter = inscricaoDividaAtivaJobStarter;
        this.inscricaoDividaAtivaImplantacaoSaldoJobStarter = inscricaoDividaAtivaImplantacaoSaldoJobStarter;
        this.atualizacaoMonetariaCreditoDAJobStarter = atualizacaoMonetariaCreditoDAJobStarter;
        this.deducaoCreditoDividaAtivaJobStarter = deducaoCreditoDividaAtivaJobStarter;
        this.arrecadacaoCreditoJobStarter = arrecadacaoCreditoJobStarter;
    }
}

