/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoManual;
import br.com.elotech.tributos.domain.BoletoManualID;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDebitoDTO;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BoletoManualService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DividaFormaPagamentoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.GeraBoletoException;
import br.com.elotech.tributos.service.exception.ModeloBoletoNotFoundException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GeraBoletoEspecialService {
    private final BoletoRepository boletoRepository;
    private final ContextService contextService;
    private final CadastroGeralService cadastroGeralService;
    private final GeraBoletoService geraBoletoService;
    private final MotivoDeducaoService motivoDeducaoService;
    private final BoletoManualService boletoManualService;
    private final DividaFormaPagamentoService dividaFormaPagamentoService;

    public GeraBoletoEspecialService(BoletoRepository boletoRepository, ContextService contextService, CadastroGeralService cadastroGeralService, GeraBoletoService geraBoletoService, MotivoDeducaoService motivoDeducaoService, BoletoManualService boletoManualService, DividaFormaPagamentoService dividaFormaPagamentoService) {
        this.boletoRepository = boletoRepository;
        this.contextService = contextService;
        this.cadastroGeralService = cadastroGeralService;
        this.geraBoletoService = geraBoletoService;
        this.motivoDeducaoService = motivoDeducaoService;
        this.boletoManualService = boletoManualService;
        this.dividaFormaPagamentoService = dividaFormaPagamentoService;
    }

    public Bloqueto geraBoletoEspecial(BoletoEspecialDTO boletoEspecialDTO) {
        if (boletoEspecialDTO.getDebitos().isEmpty()) {
            throw new EloValidationException("N\u00e3o foi selecionado nenhum d\u00e9bito para a emiss\u00e3o de boleto especial.");
        }
        if (boletoEspecialDTO.hasDebitoWithCadastroDiferente().booleanValue()) {
            throw new EloValidationException("Foram selecionados d\u00e9bitos de cadastros diferentes para a emiss\u00e3o do boleto especial.");
        }
        if (LocalDate.now().isAfter(boletoEspecialDTO.getDataVencimento())) {
            throw new EloValidationException("A nova data de vencimento deve ser maior ou igual \u00e0 data atual.");
        }
        Long divida = ((BoletoEspecialDebitoDTO)boletoEspecialDTO.getDebitos().get(0)).getDivida();
        Long formaPagamento = this.geraBoletoService.getFormaPagamento();
        Long exercicioAtual = this.contextService.getExercicioAtual();
        Long entidade = this.contextService.getEntidadePrincipal();
        this.validaEmissaoBoletoEspecial(exercicioAtual, formaPagamento, boletoEspecialDTO.getDebitos());
        CadastroGeralResumidoDTO cadastroGeralResumido = boletoEspecialDTO.getCadastroGeral();
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(cadastroGeralResumido.getTipoCadastro(), cadastroGeralResumido.getCadastroGeral()).orElseThrow(() -> new CadastroNaoEncontradoException(cadastroGeralResumido.getTipoCadastro(), cadastroGeralResumido.getCadastroGeral()));
        MotivoDeducao motivoDeducao = (MotivoDeducao)this.motivoDeducaoService.findById((Serializable)boletoEspecialDTO.getMotivoDeducao()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o motivo dedu\u00e7\u00e3o %d.", boletoEspecialDTO.getMotivoDeducao())));
        ModeloBoleto modeloBoleto = (ModeloBoleto)this.boletoRepository.findModeloBoleto(entidade, exercicioAtual, divida, formaPagamento).orElseThrow(() -> new ModeloBoletoNotFoundException(entidade, exercicioAtual, divida, formaPagamento));
        this.geraBoletoService.validaModeloBoleto(modeloBoleto);
        Bloqueto boleto = new Bloqueto();
        boleto.setDataEmissao(LocalDate.now());
        boleto.setOrigemEmissao(OrigemEmissao.AISE);
        boleto.setTipoBloqueto(TipoBloqueto.PARCELADO);
        boleto.setEntidade(entidade);
        boleto.setExercicioBloqueto(exercicioAtual);
        boleto.setDireitoDescontoCotaUnica(Boolean.FALSE);
        boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        boleto.setDataVencimento(boletoEspecialDTO.getDataVencimento());
        boleto.setDataLimitePagamento(this.geraBoletoService.getDataLimiteVencimentoBoletoEspecial(boleto, divida, formaPagamento));
        boleto.setUsuario(SecurityUtils.getUserAise());
        boleto.setFormaPagamento(formaPagamento);
        boleto.setMotivoDeducao(motivoDeducao);
        boleto.setObservacao(boletoEspecialDTO.getObservacao());
        boleto.setCadastroGeral(cadastroGeral);
        boleto.setPessoa(this.geraBoletoService.getPessoaBoleto(cadastroGeral));
        boleto.setModeloBloqueto(modeloBoleto);
        this.boletoRepository.geraCodigoBoleto(boleto);
        boleto.getDebitos().addAll(boletoEspecialDTO.getDebitos().stream().map(boletoEspecialDebitoDTO -> BoletoDebito.of((Bloqueto)boleto, (BoletoEspecialDebitoDTO)boletoEspecialDebitoDTO)).collect(Collectors.toList()));
        boleto.atualizaValoresBoleto();
        CodigoBarrasDTO codigoBarrasDTO = modeloBoleto.getConvenio().getTipoCodigoBarras().getNossoNumero().gerar(boleto);
        this.geraBoletoService.validaDadosCodigoBarras(codigoBarrasDTO);
        boleto.setCodigoBarras(codigoBarrasDTO);
        boleto.setNossoNumero(codigoBarrasDTO.getNossoNumero());
        this.boletoRepository.save((Object)boleto);
        BoletoManual boletoManual = new BoletoManual();
        boletoManual.setDataReferencia(LocalDate.now());
        boletoManual.setNovoVencimento(boletoEspecialDTO.getDataVencimento());
        boletoManual.setObservacao(boletoEspecialDTO.getObservacao());
        boletoManual.setId(BoletoManualID.from((Bloqueto)boleto));
        boletoManual.setFiltro("");
        if (Objects.nonNull(boletoEspecialDTO.getProcesso())) {
            boletoManual.setIdProcesso(boletoEspecialDTO.getProcesso().getId().getIdProcesso());
            boletoManual.setExercicioProcesso(boletoEspecialDTO.getProcesso().getId().getExercicio());
        }
        this.boletoManualService.save((EloEntity)boletoManual, null);
        return boleto;
    }

    private void validaEmissaoBoletoEspecial(Long exercicioAtual, Long formaPagamento, List<BoletoEspecialDebitoDTO> listaDebitosBoletoDTO) {
        List listDividaFormaPagamentoConvenio = this.dividaFormaPagamentoService.findDividaFormaPagamentoByIdDebitoAndFormaPagamentoAndExercicio(Collections.singletonList(listaDebitosBoletoDTO.get(0).getIdDebito()), formaPagamento, exercicioAtual);
        this.geraBoletoService.validaFormaPagamento(listDividaFormaPagamentoConvenio, formaPagamento);
        this.geraBoletoService.validaConvenio(listDividaFormaPagamentoConvenio);
        this.podeEmitirBoletoEspecial(listaDebitosBoletoDTO);
    }

    private void podeEmitirBoletoEspecial(List<BoletoEspecialDebitoDTO> debitos) {
        debitos.forEach(debito -> {
            if (!debito.getEmiteBoleto().booleanValue()) {
                throw GeraBoletoException.guiaNaoEmiteBoleto((Long)debito.getDivida(), (Long)debito.getExercicio());
            }
            TipoSituacaoParcela tipoSituacaoParcela = TipoSituacaoParcela.fromValue((Long)debito.getTipoSituacaoParcela());
            if (TipoSituacaoParcela.RECURSO_ADMINISTRATIVO.equals((Object)tipoSituacaoParcela) || TipoSituacaoParcela.SUBJUDICE.equals((Object)tipoSituacaoParcela) || TipoSituacaoParcela.DIVIDA_SUSPENSA.equals((Object)tipoSituacaoParcela)) {
                throw GeraBoletoException.situacaoParcelaInvalida((String)tipoSituacaoParcela.getDescricao(), (Long)debito.getExercicio(), (Long)debito.getDivida(), (Long)debito.getSubDivida(), (Long)debito.getParcela());
            }
        });
    }
}

