/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioProfundidade;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenerica;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastralItem;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.DebitosEmAbertoComTotalizadorDTO;
import br.com.elotech.tributos.dto.EnderecoCorrespondenciaDTO;
import br.com.elotech.tributos.dto.LogradouroDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioCopiaDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioEnderecoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioRowDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioUnificacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.LoteamentoDTO;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.facet.FacetCadastroImobiliario;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.imobiliario.CadastroImobiliarioRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioSituacaoService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.EnderecoCorrespondenciaService;
import br.com.elotech.tributos.service.HibernateSearchService;
import br.com.elotech.tributos.service.ParametroEntidadeService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SequenceCadastroGeralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import br.com.elotech.tributos.validator.CadastroImobiliarioValidator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CadastroImobiliarioService
extends CrudService<CadastroImobiliario, Long> {
    private static final int DUAS_CASAS_DECIMAIS = 2;
    private static final int QUATRO_CASAS_DECIMAIS = 4;
    private static final String MESSAGE_VALIDATION_REQUIRED = "%s \u00e9 obrigat\u00f3rio";
    private final ParametroEntidadeService parametroEntidadeService;
    private final ParametroGeralService parametroGeralService;
    private final CadastroGeralService cadastroGeralService;
    private final CadastroImobiliarioSituacaoService imobiliarioSituacaoService;
    private final CadastroImobiliarioRepository cadastroImobiliarioRepository;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;
    private final CadastroImobiliarioValidator cadastroImobiliarioValidator;
    private final SetorQuadraService setorQuadraService;
    private final RespostaService respostaService;
    private final HibernateSearchService hibernateSearchService;
    private final SequenceCadastroGeralService sequenceCadastroGeralService;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EnderecoCorrespondenciaService enderecoCorrespondenciaService;
    private final DebitoEmAbertoService debitoEmAbertoService;

    public CadastroImobiliarioService(ParametroEntidadeService parametroEntidadeService, CadastroGeralService cadastroGeralService, CadastroImobiliarioSituacaoService imobiliarioSituacaoService, ParametroGeralService parametroGeralService, CadastroImobiliarioRepository cadastroImobiliarioRepository, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService, CadastroImobiliarioValidator cadastroImobiliarioValidator, SetorQuadraService setorQuadraService, RespostaService respostaService, HibernateSearchService hibernateSearchService, SequenceCadastroGeralService sequenceCadastroGeralService, SequenceGeneratorRepository sequenceGeneratorRepository, EnderecoCorrespondenciaService enderecoCorrespondenciaService, AiseDebitoService aiseDebitoService, DebitoEmAbertoService debitoEmAbertoService) {
        this.parametroEntidadeService = parametroEntidadeService;
        this.cadastroGeralService = cadastroGeralService;
        this.imobiliarioSituacaoService = imobiliarioSituacaoService;
        this.cadastroImobiliarioValidator = cadastroImobiliarioValidator;
        this.parametroGeralService = parametroGeralService;
        this.cadastroImobiliarioRepository = cadastroImobiliarioRepository;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
        this.setorQuadraService = setorQuadraService;
        this.respostaService = respostaService;
        this.hibernateSearchService = hibernateSearchService;
        this.sequenceCadastroGeralService = sequenceCadastroGeralService;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.enderecoCorrespondenciaService = enderecoCorrespondenciaService;
        this.debitoEmAbertoService = debitoEmAbertoService;
    }

    protected void beforeSave(CadastroImobiliario cadastroImobiliario, Authentication authentication) {
        this.cadastroGeralService.validaCadastroGeralExclusaoLogica((CadastroGeral)cadastroImobiliario);
        cadastroImobiliario.setDataAlteracao(LocalDate.now());
        cadastroImobiliario.setUsuario(SecurityUtils.getUserAise());
        this.setInscricaoCadastral(cadastroImobiliario);
        this.setProfundidadeMedia(cadastroImobiliario);
        this.calculaAreasBaseadasNosSegmentos(cadastroImobiliario);
        this.atualizaAreaTotalInscricao(cadastroImobiliario);
        this.setArredondamentoArea(cadastroImobiliario);
        if (Objects.nonNull(cadastroImobiliario.getSituacaoImobiliario())) {
            this.imobiliarioSituacaoService.setAtualSituacao(cadastroImobiliario);
        }
        this.cadastroImobiliarioValidator.validaCadastroImobiliario(cadastroImobiliario);
        this.setEnderecoLocalizacao(cadastroImobiliario);
        this.setPessoaCadastroGeral(cadastroImobiliario);
        if (!this.informaCadastroManual().booleanValue() && Objects.isNull(cadastroImobiliario.getCadastroGeral())) {
            cadastroImobiliario.setCadastroGeral(this.getCadastroGeralBySequence());
            cadastroImobiliario.atualizaReferenciaSegmentos();
            cadastroImobiliario.atualizaReferenciaObservacoes();
        }
        super.beforeSave((EloEntity)cadastroImobiliario, authentication);
    }

    private void calculaAreasBaseadasNosSegmentos(CadastroImobiliario cadastroImobiliario) {
        BigDecimal areaUnidadeConstruida = cadastroImobiliario.getSegmentos().stream().map(CadastroImobiliarioSegmento::getAreaConstruida).reduce(BigDecimal.ZERO, BigDecimal::add);
        cadastroImobiliario.setAreaUnidadeConstruida(areaUnidadeConstruida);
        Boolean utilizaSituacaoSegmento = this.utilizaSituacaoSegmento();
        BigDecimal areaTotalConstruida = cadastroImobiliario.getAreaTotalSegmentos(utilizaSituacaoSegmento);
        cadastroImobiliario.setAreaTotalConstruida(areaTotalConstruida);
    }

    private void atualizaAreaTotalInscricao(CadastroImobiliario cadastroImobiliario) {
        String inscricaoSemUnidade = this.montaInscricaoCadastralSemUnidade(cadastroImobiliario);
        List cadastrosMesmaInscricao = this.cadastroImobiliarioRepository.getCadastrosMesmaInscricao(inscricaoSemUnidade, cadastroImobiliario.getId());
        Boolean utilizaSituacaoSegmento = this.utilizaSituacaoSegmento();
        BigDecimal areaCadastrosMesmaInscricao = cadastrosMesmaInscricao.stream().reduce(BigDecimal.ZERO, (acc, curr) -> acc.add(curr.getAreaTotalSegmentos(utilizaSituacaoSegmento)), BigDecimal::add);
        BigDecimal areaTotalInscricao = cadastroImobiliario.getAreaTotalConstruida().add(areaCadastrosMesmaInscricao);
        cadastroImobiliario.setAreaTotalInscricao(areaTotalInscricao);
        cadastrosMesmaInscricao.forEach(cadastro -> {
            cadastro.setAreaTotalInscricao(areaTotalInscricao);
            this.cadastroImobiliarioRepository.save(cadastro);
        });
    }

    private void setPessoaCadastroGeral(CadastroImobiliario cadastroImobiliario) {
        Proprietario proprietarioPrincipal = cadastroImobiliario.getProprietarios().stream().filter(proprietario -> proprietario.getPrincipal() != false && TipoVinculo.PRINCIPAL.equals((Object)proprietario.getVinculo().getTipoVinculo())).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o h\u00e1 um propriet\u00e1rio marcado como principal"));
        cadastroImobiliario.setPessoa(proprietarioPrincipal.getPessoa());
    }

    private void setEnderecoLocalizacao(CadastroImobiliario cadastroImobiliario) {
        Boolean utilizaTestadaGenerica = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA);
        if (utilizaTestadaGenerica.booleanValue()) {
            cadastroImobiliario.getTestadasGenericas().stream().filter(CadastroImobiliarioTestadaGenerica::getPrincipal).findFirst().ifPresent(testadaGenerica -> {
                Logradouro logradouro = (Logradouro)this.getEm().getReference(Logradouro.class, (Object)testadaGenerica.getLogradouro().getId());
                cadastroImobiliario.setCidade(logradouro.getCidade());
                cadastroImobiliario.setLogradouro(logradouro);
                cadastroImobiliario.setNumero(testadaGenerica.getNumero());
            });
        } else {
            cadastroImobiliario.getTestadas().stream().filter(CadastroImobiliarioTestada::getPrincipal).findFirst().ifPresent(testada -> {
                LogradouroTestada logradouroTestada = (LogradouroTestada)this.getEm().getReference(LogradouroTestada.class, (Object)testada.getLogradouroTestada().getId());
                cadastroImobiliario.setCidade(logradouroTestada.getLogradouro().getCidade());
                cadastroImobiliario.setLogradouro(logradouroTestada.getLogradouro());
                cadastroImobiliario.setNumero(testada.getNumero());
            });
        }
    }

    private void setProfundidadeMedia(CadastroImobiliario cadastroImobiliario) {
        List profundidades = cadastroImobiliario.getProfundidades();
        BigDecimal soma = profundidades.stream().map(CadastroImobiliarioProfundidade::getProfundidade).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (soma.compareTo(BigDecimal.ZERO) > 0) {
            cadastroImobiliario.setProfundidadeMedia(soma.divide(new BigDecimal(profundidades.size()), 4, RoundingMode.HALF_UP));
        }
    }

    private void setArredondamentoArea(CadastroImobiliario cadastroImobiliario) {
        int casasDecimais = this.parametroCasasDecimaisImobiliario().intValue();
        if (casasDecimais < 2 || casasDecimais > 4) {
            casasDecimais = 2;
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaLote())) {
            cadastroImobiliario.setAreaLote(cadastroImobiliario.getAreaLote().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaUtilLote())) {
            cadastroImobiliario.setAreaUtilLote(cadastroImobiliario.getAreaUtilLote().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaPrivativa())) {
            cadastroImobiliario.setAreaPrivativa(cadastroImobiliario.getAreaPrivativa().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaComum())) {
            cadastroImobiliario.setAreaComum(cadastroImobiliario.getAreaComum().setScale(casasDecimais, 4));
        }
    }

    private Long parametroCasasDecimaisImobiliario() {
        return this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.CASAS_DECIMAIS_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean parametroValidaInscricaoDuplicada() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_INSCRICAO_DUPLICADA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public Boolean utilizaSituacaoSegmento() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.UTILIZA_SITUACAO_SEGMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean informaCadastroManual() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.INFORMA_CADASTRO_MANUAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public CadastroImobiliario findByTipoCadastroAndCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroImobiliario cadastroImobiliarioEntity = this.cadastroImobiliarioRepository.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
        return cadastroImobiliarioEntity;
    }

    public CadastroImobiliarioDTO saveDTO(CadastroImobiliarioDTO cadastroImobiliarioDTO, Boolean novoCadastro) {
        return this.saveDTOWithFlush(cadastroImobiliarioDTO, novoCadastro, Boolean.TRUE);
    }

    public CadastroImobiliarioDTO saveDTOWithFlush(CadastroImobiliarioDTO cadastroImobiliarioDTO, Boolean novoCadastro, Boolean flush) {
        CadastroImobiliario cadastroImobiliarioToSave = cadastroImobiliarioDTO.toEntity();
        cadastroImobiliarioToSave.getTestadas().forEach(testada -> {
            Long idSetorQuadra = testada.getLogradouroTestada().getSetorQuadra().getId();
            testada.getLogradouroTestada().setSetorQuadra((SetorQuadra)this.setorQuadraService.findById((Serializable)idSetorQuadra).orElseThrow(() -> new EloValidationException(String.format("Quadra n\u00e3o encontrado com id %d", idSetorQuadra))));
        });
        CadastroImobiliario prepared = this.prepareToSave(cadastroImobiliarioToSave, novoCadastro);
        this.validaRespostasCamposDinamicos(prepared);
        CadastroImobiliario saved = (CadastroImobiliario)this.save((EloEntity)prepared, null);
        if (Boolean.TRUE.equals(flush)) {
            this.getEm().flush();
        }
        return this.loadDTO(saved);
    }

    public CadastroImobiliarioDTO loadDTO(CadastroImobiliario cadastroImobiliario) {
        CadastroImobiliarioDTO retorno = CadastroImobiliarioDTO.from((CadastroImobiliario)cadastroImobiliario);
        this.preencheEnderecoCorrespondencia(retorno);
        retorno.setRespostasTerreno(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.TERRENO, retorno.getId()));
        retorno.getSegmentos().forEach(segmentoDTO -> segmentoDTO.setRespostasSegmento(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.SEGMENTO, segmentoDTO.getId())));
        return retorno;
    }

    private void preencheEnderecoCorrespondencia(CadastroImobiliarioDTO cadastroImobiliarioDTO) {
        Optional.ofNullable(cadastroImobiliarioDTO.getTipoEnderecoCorrespondencia()).ifPresent(tipoEnderecoCorrespondencia -> {
            EnderecoCorrespondenciaDTO enderecoCorrespondenciaDTO = this.enderecoCorrespondenciaService.findEnderecoCorrespondenciaByIdAndTipo(cadastroImobiliarioDTO.getId(), tipoEnderecoCorrespondencia);
            cadastroImobiliarioDTO.setEnderecoCorrespondencia(enderecoCorrespondenciaDTO.getLogradouroDescricao());
            cadastroImobiliarioDTO.setBairroCorrespondencia(enderecoCorrespondenciaDTO.getBairroDescricao());
            cadastroImobiliarioDTO.setCidadeUfCorrespondencia(enderecoCorrespondenciaDTO.getCidadeDescricao());
            cadastroImobiliarioDTO.setComplementoCorrespondencia(enderecoCorrespondenciaDTO.getComplemento());
            cadastroImobiliarioDTO.setNumeroCorrespondencia(enderecoCorrespondenciaDTO.getNumero());
            cadastroImobiliarioDTO.setUfCorrespondencia(enderecoCorrespondenciaDTO.getUnidadeFederacao());
            cadastroImobiliarioDTO.setCepCorrespondencia(enderecoCorrespondenciaDTO.getCep());
        });
    }

    private CadastroImobiliario prepareToSave(CadastroImobiliario cadastroImobiliarioToSave, Boolean novoCadastro) {
        if (!novoCadastro.booleanValue() && cadastroImobiliarioToSave.getId() != null) {
            CadastroImobiliario cadastroImobiliarioFound = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)cadastroImobiliarioToSave.getId()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", cadastroImobiliarioToSave.getId())));
            return cadastroImobiliarioFound.merge(cadastroImobiliarioToSave);
        }
        cadastroImobiliarioToSave.atualizaReferenciaCamposDinamicos();
        return cadastroImobiliarioToSave;
    }

    private void validaRespostasCamposDinamicos(CadastroImobiliario cadastroImobiliario) {
        this.respostaService.validaRespostas(cadastroImobiliario.getRespostaTerrenos(), FuncionalidadeCampo.TERRENO);
        cadastroImobiliario.getSegmentos().forEach(segmento -> this.respostaService.validaRespostas(segmento.getRespostasSegmento(), FuncionalidadeCampo.SEGMENTO));
    }

    private void setInscricaoCadastral(CadastroImobiliario cadastroImobiliario) {
        ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
        configuracao.validaConfiguracao();
        ArrayList<String> inscricaoCadastral = new ArrayList<String>();
        ArrayList inconsistenciaInscricaoCadastral = new ArrayList();
        if (Boolean.TRUE.equals(configuracao.getQuadricula().getAtivo())) {
            String quadriculaFormatada = Optional.ofNullable(cadastroImobiliario.getQuadriculaLocalizacao()).map(quadricula -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, quadricula.getId(), configuracao.getQuadricula());
                return configuracao.getQuadricula().formatarValor(quadricula.getId());
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getQuadricula().getDescricao())));
            inscricaoCadastral.add(quadriculaFormatada);
        }
        if (Boolean.TRUE.equals(configuracao.getDistrito().getAtivo())) {
            String distritoFormatado = Optional.ofNullable(cadastroImobiliario.getDistritoLocalizacao()).map(distrito -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, distrito.getId(), configuracao.getDistrito());
                return configuracao.getDistrito().formatarValor(distrito.getId());
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getDistrito().getDescricao())));
            inscricaoCadastral.add(distritoFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getSetor().getAtivo())) {
            String setorFormatado = Optional.ofNullable(cadastroImobiliario.getSetorLocalizacao()).map(setor -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, setor.getSetor(), configuracao.getSetor());
                return configuracao.getSetor().formatarValor(setor.getSetor());
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getSetor().getDescricao())));
            inscricaoCadastral.add(setorFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getQuadra().getAtivo())) {
            String quadraFormatada = Optional.ofNullable(cadastroImobiliario.getQuadraLocalizacao()).map(quadra -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, quadra.getQuadra(), configuracao.getQuadra());
                return configuracao.getQuadra().formatarValor(quadra.getQuadra());
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getQuadra().getDescricao())));
            inscricaoCadastral.add(quadraFormatada);
        }
        if (Boolean.TRUE.equals(configuracao.getLote().getAtivo())) {
            String loteFormatado = Optional.ofNullable(cadastroImobiliario.getLoteLocalizacao()).map(lote -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, lote, configuracao.getLote());
                return configuracao.getLote().formatarValor(lote);
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getLote().getDescricao())));
            inscricaoCadastral.add(loteFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getUnidade().getAtivo())) {
            String unidadeFormatada = Optional.ofNullable(cadastroImobiliario.getUnidadeLocalizacao()).map(unidade -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, unidade, configuracao.getUnidade());
                return configuracao.getUnidade().formatarValor(unidade);
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getUnidade().getDescricao())));
            inscricaoCadastral.add(unidadeFormatada);
        }
        if (!inconsistenciaInscricaoCadastral.isEmpty()) {
            throw new EloValidationException(String.format("Inscri\u00e7\u00e3o cadastral inv\u00e1lida. %s", String.join((CharSequence)" ", inconsistenciaInscricaoCadastral)));
        }
        String inscricaoCadastralSemSeparador = String.join((CharSequence)"", inscricaoCadastral);
        if (this.parametroValidaInscricaoDuplicada().booleanValue()) {
            this.validaInscricaoCadastralDuplicada(inscricaoCadastralSemSeparador, cadastroImobiliario.getId());
        }
        cadastroImobiliario.setInscricaoCadastral(inscricaoCadastralSemSeparador);
    }

    private void getInconsistenciaInscricaoCadastral(List<String> inconsistenciaInscricaoCadastral, String campo, ConfiguracaoInscricaoCadastralItem configuracaoItem) {
        if (campo.length() > configuracaoItem.getTamanho().intValue()) {
            inconsistenciaInscricaoCadastral.add(String.format("Tamanho m\u00e1ximo de %s permitido: %d.", configuracaoItem.getDescricao(), configuracaoItem.getTamanho()));
        }
    }

    private void validaInscricaoCadastralDuplicada(String inscricaoCadastral, Long idkeyCadastro) {
        List inscricoesDuplicadas = this.cadastroImobiliarioRepository.findDuplicadosByInscricaoCadastralAndId(inscricaoCadastral, idkeyCadastro);
        if (!inscricoesDuplicadas.isEmpty()) {
            throw new EloValidationException(String.format("Inscri\u00e7\u00e3o cadastral duplicada. Encontrada no Cadastro: %s - %d", ((CadastroImobiliario)inscricoesDuplicadas.get(0)).getTipoCadastro().getDescricao(), ((CadastroImobiliario)inscricoesDuplicadas.get(0)).getCadastroGeral()));
        }
    }

    public String montaInscricaoCadastralSemUnidade(CadastroImobiliario cadastroImobiliario) {
        ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
        configuracao.validaConfiguracao();
        ArrayList<String> inscricaoCadastral = new ArrayList<String>();
        if (Boolean.TRUE.equals(configuracao.getQuadricula().getAtivo())) {
            String quadriculaFormatada = configuracao.getQuadricula().formatarValor(cadastroImobiliario.getQuadriculaLocalizacao().getId());
            inscricaoCadastral.add(quadriculaFormatada);
        }
        if (Boolean.TRUE.equals(configuracao.getDistrito().getAtivo())) {
            String distritoFormatado = configuracao.getDistrito().formatarValor(cadastroImobiliario.getDistritoLocalizacao().getDistrito());
            inscricaoCadastral.add(distritoFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getSetor().getAtivo())) {
            String setorFormatado = configuracao.getSetor().formatarValor(cadastroImobiliario.getSetorLocalizacao().getSetor());
            inscricaoCadastral.add(setorFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getQuadra().getAtivo())) {
            String quadraFormatada = configuracao.getQuadra().formatarValor(cadastroImobiliario.getQuadraLocalizacao().getQuadra());
            inscricaoCadastral.add(quadraFormatada);
        }
        if (Boolean.TRUE.equals(configuracao.getLote().getAtivo())) {
            String loteFormatado = configuracao.getLote().formatarValor(cadastroImobiliario.getLoteLocalizacao());
            inscricaoCadastral.add(loteFormatado);
        }
        return String.join((CharSequence)"", inscricaoCadastral);
    }

    public Boolean existsQuadriculaLocalizacao(String quadricula) {
        return this.cadastroImobiliarioRepository.existsByQuadriculaLocalizacaoId(quadricula);
    }

    public CadastroSearchDTO<CadastroImobiliarioRowDTO> searchCadastrosImobiliarios(CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        List<String> searchFields = Arrays.asList("cep", "pessoa.nome", "pessoa.cnpjCpf", "pessoa.nomeFantasia", "pessoa.rg", "proprietarios.pessoa.nome", "proprietarios.pessoa.cnpjCpf", "proprietarios.pessoa.nomeFantasia", "proprietarios.pessoa.rg", "enderecoFormatado", "loteamento.descricao", "complementoLote", "inscricaoCadastral");
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.getEm(), CadastroImobiliario.class, pageable, searchParams.getSearch(), searchFields, Arrays.asList(FacetCadastroImobiliario.values()));
        Query query = hibernateSearchParams.getQueryBuilder().bool().must(hibernateSearchParams.createQueryWithSpecificField("tipoCadastroDescricao", TipoCadastro.IMOBILIARIO.getDescricao())).should((Query)new BoostQuery(hibernateSearchParams.createQueryWithSpecificField("cadastroGeral", searchParams.getSearch()), 1.5f)).should(hibernateSearchParams.createFuzzyQuery()).createQuery();
        return this.hibernateSearchService.geraCadastroSearchDTO(query, hibernateSearchParams, searchParams.getFacets(), CadastroImobiliarioRowDTO::from);
    }

    public Boolean existsCadastroImobiliarioAssociadoLoteamento(Long idLoteamento) {
        return this.cadastroImobiliarioRepository.existsByLoteamentoId(idLoteamento);
    }

    public Boolean existsCadastroImobiliarioAssociadoLogradouroTestada(Long idLogradouroTestada) {
        return this.cadastroImobiliarioRepository.existsByTestadasLogradouroTestadaId(idLogradouroTestada);
    }

    public CadastroImobiliarioEnderecoDTO getEnderecoByCadastroImobiliario(Long CadastroGeralImobiliario) {
        CadastroImobiliario cadastroImobiliario = Optional.ofNullable(this.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, CadastroGeralImobiliario)).orElseThrow(() -> new EloValidationException("Cadastro Imobili\u00e1rio n\u00e3o encontrado"));
        CadastroImobiliarioEnderecoDTO cadastroImobiliarioEnderecoDTO = new CadastroImobiliarioEnderecoDTO();
        cadastroImobiliarioEnderecoDTO.setId(cadastroImobiliario.getId());
        cadastroImobiliarioEnderecoDTO.setTipoCadastro(cadastroImobiliario.getTipoCadastro());
        cadastroImobiliarioEnderecoDTO.setCadastroGeral(cadastroImobiliario.getCadastroGeral());
        cadastroImobiliarioEnderecoDTO.setCidade(cadastroImobiliario.getCidade());
        Optional.ofNullable(cadastroImobiliario.getLogradouro()).ifPresent(logradouro -> cadastroImobiliarioEnderecoDTO.setLogradouro(LogradouroDTO.from((Logradouro)logradouro)));
        cadastroImobiliarioEnderecoDTO.setNumero(cadastroImobiliario.getNumero());
        Optional.ofNullable(cadastroImobiliario.getCep()).ifPresent(cep -> cadastroImobiliarioEnderecoDTO.setCep(cep.toString()));
        cadastroImobiliarioEnderecoDTO.setComplemento(cadastroImobiliario.getComplemento());
        Optional.ofNullable(cadastroImobiliario.getBairro()).ifPresent(bairro -> cadastroImobiliarioEnderecoDTO.setBairro(BairroDTO.from((Bairro)bairro)));
        Optional.ofNullable(cadastroImobiliario.getLoteamento()).ifPresent(loteamento -> cadastroImobiliarioEnderecoDTO.setLoteamento(LoteamentoDTO.from((Loteamento)cadastroImobiliario.getLoteamento())));
        return cadastroImobiliarioEnderecoDTO;
    }

    public List<CadastroImobiliarioSituacao> getSituacoes(Long id) {
        if (!this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SITUACAO_IMOBILIARIO).booleanValue()) {
            throw new EloValidationException("O sistema est\u00e1 configurado para n\u0101o utilizar situa\u00e7\u0101o no cadastro imobili\u00e1rio");
        }
        return this.cadastroImobiliarioRepository.findById((Object)id).map(CadastroImobiliario::getSituacoes).map(situacoes -> {
            situacoes.sort(Comparator.comparingLong(CadastroImobiliarioSituacao::getSequencia).reversed());
            return situacoes;
        }).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", id)));
    }

    public List<CadastroImobiliarioSituacao> createSituacao(Long id, CadastroImobiliarioSituacao novaSituacao) {
        if (!this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SITUACAO_IMOBILIARIO).booleanValue()) {
            throw new EloValidationException("O sistema est\u00e1 configurado para n\u0101o utilizar situa\u00e7\u0101o no cadastro imobili\u00e1rio");
        }
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Cadastro imobili\u00e1rio com id %d n\u00e3o encontrado", id)));
        if (cadastroImobiliario.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro imobili\u00e1rio %d se encontra em exclus\u0101o l\u00f3gica.", cadastroImobiliario.getCadastroGeral()));
        }
        CadastroImobiliarioSituacao situacaoAtual = cadastroImobiliario.getSituacaoAtual();
        if (Objects.nonNull(situacaoAtual)) {
            situacaoAtual.setAtual(Boolean.FALSE);
            situacaoAtual.setDataAlteracao(LocalDate.now());
        }
        novaSituacao.setSequencia(Long.valueOf(cadastroImobiliario.getUltimaSequenciaSituacao() + 1L));
        novaSituacao.setUsuarioInclusao(SecurityUtils.getUserAise());
        novaSituacao.setDataInclusao(LocalDate.now());
        cadastroImobiliario.getSituacoes().add(novaSituacao);
        this.save((EloEntity)cadastroImobiliario, null);
        List result = cadastroImobiliario.getSituacoes();
        result.sort(Comparator.comparingLong(CadastroImobiliarioSituacao::getSequencia).reversed());
        return result;
    }

    public void deleteById(Long id) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro imobili\u00e1rio com o id: %d, para realizar a exclus\u00e3o.", id)));
        this.cadastroImobiliarioRepository.delete((Object)cadastroImobiliario);
    }

    public CadastroImobiliarioDTO copiar(Long id, CadastroImobiliarioCopiaDTO cadastroCopia) {
        CadastroImobiliario cadastroImobiliarioToCopy = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", id)));
        if (this.informaCadastroManual().booleanValue() && Objects.isNull(cadastroCopia.getCadastroGeral())) {
            throw new EloValidationException("O c\u00f3digo do cadastro deve ser informado.");
        }
        Long novoCodigoCadastroGeral = this.informaCadastroManual() != false ? cadastroCopia.getCadastroGeral() : this.getCadastroGeralBySequence();
        CadastroImobiliario newCadastroImobiliario = cadastroImobiliarioToCopy.copy(novoCodigoCadastroGeral);
        return CadastroImobiliarioDTO.from((CadastroImobiliario)((CadastroImobiliario)this.cadastroImobiliarioRepository.save((Object)newCadastroImobiliario)));
    }

    private Long getCadastroGeralBySequence() {
        CadastroImobiliario cadastroImobiliario = new CadastroImobiliario();
        cadastroImobiliario.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        String sequenceNome = this.sequenceCadastroGeralService.getExpression((CadastroGeral)cadastroImobiliario);
        return this.sequenceGeneratorRepository.getNextVal(sequenceNome);
    }

    public Long validateAndGetCadastroGeralSequence(Long cadastroGeral) {
        if (!this.informaCadastroManual().booleanValue() && Objects.isNull(cadastroGeral)) {
            return this.getCadastroGeralBySequence();
        }
        return cadastroGeral;
    }

    public List<CadastroImobiliarioUnificacaoDTO> findImobiliariosElegiveisUnificacao(Long idCadastro) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)idCadastro).orElseThrow(() -> new EloValidationException(String.format("Cadastro imobili\u00e1rio com %d n\u00e3o encontrado", idCadastro)));
        List cadastrosImobiliariosUnificacao = this.cadastroImobiliarioRepository.getImobiliariosElegiveisUnificacao(cadastroImobiliario.getCadastroGeral(), cadastroImobiliario.getDistritoLocalizacao().getDistrito(), cadastroImobiliario.getSetorLocalizacao().getSetor(), cadastroImobiliario.getQuadraLocalizacao().getQuadra());
        return cadastrosImobiliariosUnificacao.stream().map(cadastroImobiliarioMap -> {
            CadastroImobiliarioUnificacaoDTO cadastroImobiliarioUnificacaoDTO = CadastroImobiliarioUnificacaoDTO.from((CadastroImobiliario)cadastroImobiliarioMap);
            String filtro = this.createStringFilter(cadastroImobiliarioUnificacaoDTO.getCadastroGeral(), cadastroImobiliarioUnificacaoDTO.getTipoCadastro());
            DebitosEmAbertoComTotalizadorDTO debitos = this.debitoEmAbertoService.loadDebitosAbertosAgrupados(filtro, Boolean.TRUE);
            cadastroImobiliarioUnificacaoDTO.setDebitos(debitos);
            cadastroImobiliarioUnificacaoDTO.setDebitosAbertos(Boolean.valueOf(debitos.getValorTotal().compareTo(BigDecimal.ZERO) > 0));
            return cadastroImobiliarioUnificacaoDTO;
        }).collect(Collectors.toList());
    }

    private String createStringFilter(Long cadastroGeral, Long tipoCadastro) {
        return String.format(" TRIBDEBITO.TIPOCADASTRO  = %d  and TRIBDEBITO.CADASTROGERAL  = %d ", tipoCadastro, cadastroGeral);
    }
}

