/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.GeraCarnePorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.AiseCarneService;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneAiseDTO;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/carne"})
public class CarneResource {
    private final AiseCarneService aiseCarneService;
    private final AisePdfService aisePdfService;
    private final CarneService carneService;

    public CarneResource(AiseCarneService aiseCarneService, AisePdfService aisePdfService, CarneService carneService) {
        this.aiseCarneService = aiseCarneService;
        this.aisePdfService = aisePdfService;
        this.carneService = carneService;
    }

    @PostMapping
    public ImpressaoDTO geraCarneAise(@RequestBody DebitoCarneAiseDTO params) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(this.aiseCarneService.geraCarne(params).getNumeroCarne()));
    }

    @PostMapping(value={"/gerar"})
    public ImpressaoDTO geraCarne(@RequestBody DebitoCarneDTO debitoCarne) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(this.carneService.geraCarne(debitoCarne).getNumeroCarne()));
    }

    @PostMapping(path={"/gera-carne-forma-pagamento"})
    public ImpressaoDTO geraBloquetoPorFormaPagamento(@RequestBody GeraCarnePorFormaPagamentoDTO params, HttpServletResponse response) {
        CarneDTO carneDTO = this.aiseCarneService.geraCarnePorFormaPagamento(params);
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(carneDTO.getNumeroCarne()));
    }

    @PostMapping(path={"/gera-carne-forma-pagamento/gerar"})
    public ImpressaoDTO geraCarnePorFormaPagamento(@RequestBody DebitoAgrupadoPorFormaPagamentoDTO params, HttpServletResponse response) {
        CarneDTO carneDTO = this.carneService.geraCarnePorFormaPagamento(params);
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(carneDTO.getNumeroCarne()));
    }
}

