/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoDTO;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LancamentoCreditoCustomRepositoryImpl
implements LancamentoCreditoCustomRepository {
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String CONTROLE = "idControle";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public LancamentoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    private String getSqlCargeExistenteLancamentoCredito() {
        return "SELECT DISTINCT  A.IDTIPONATUREZACREDITO||'-'||A.IDTIPOCREDITO||'-'||A.IDTIPOOPERACAOCREDITO||'-'||TDPR.EXERCICIO||'-'||TGR.GUIARECOLHIMENTO||'-'||to_char(A.DTLANCAMENTO, 'yyyy-MM-dd') AS CHAVE,  A.IDTCELANCCREDITO AS ID,  A.NRCREDITO,  A.NRANOCREDITO FROM TCELANCCREDITO A JOIN TCEDEBITOLANCCREDITO B  ON A.IDTCELANCCREDITO = B.IDTCELANCCREDITO JOIN TRIBDEBITOPARCELARECEITA TDPR  ON B.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA JOIN TRIBGUIARECOLHIMENTO TGR  ON TDPR.ENTIDADE = TGR.ENTIDADE AND TDPR.EXERCICIO = TGR.EXERCICIO AND TDPR.GUIARECOLHIMENTO = TGR.GUIARECOLHIMENTO LEFT JOIN CGATO ATO  ON TGR.ENTIDADE = ATO.ENTIDADE AND TGR.FUNDAMENTOLEGAL = ATO.IDATO WHERE TDPR.ENTIDADE = :entidade AND A.DTLANCAMENTO BETWEEN :dataInicial AND :dataFinal ORDER BY A.IDTCELANCCREDITO  ";
    }

    private String getSqlCargeExistenteLancamentoCreditoImplantacaoSaldo() {
        return "SELECT DISTINCT  A.IDTIPONATUREZACREDITO||'-'||A.IDTIPOCREDITO||'-'||A.IDTIPOOPERACAOCREDITO||'-'||TDPR.EXERCICIO||'-'||TGR.GUIARECOLHIMENTO||'-'||to_char(A.DTLANCAMENTO, 'yyyy-MM-dd') AS CHAVE,  A.IDTCELANCCREDITO AS ID,  A.NRCREDITO,  A.NRANOCREDITO FROM TCELANCCREDITO A JOIN TCEDEBITOLANCCREDITO B  ON A.IDTCELANCCREDITO = B.IDTCELANCCREDITO JOIN TRIBDEBITOPARCELARECEITA TDPR  ON B.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA JOIN TRIBGUIARECOLHIMENTO TGR  ON TDPR.ENTIDADE = TGR.ENTIDADE AND TDPR.EXERCICIO = TGR.EXERCICIO AND TDPR.GUIARECOLHIMENTO = TGR.GUIARECOLHIMENTO JOIN TCECONTROLEIMPLANTACAOITEM TCII  ON TDPR.IDDEBITOPARCELARECEITA = TCII.IDDEBITOPARCELARECEITA LEFT JOIN CGATO ATO  ON TGR.ENTIDADE = ATO.ENTIDADE AND TGR.FUNDAMENTOLEGAL = ATO.IDATO WHERE TCII.IDCONTROLE = :idControle ORDER BY A.IDTCELANCCREDITO ";
    }

    public List<LancamentoCreditoCargaExistenteDTO> getCargaExistenteLancamentoCredito(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = this.getSqlCargeExistenteLancamentoCredito();
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(LancamentoCreditoCargaExistenteDTO.class));
    }

    public List<LancamentoCreditoCargaExistenteDTO> getCargaExistenteLancamentoCreditoImplantacaoSaldo(Long idControle) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(CONTROLE, (Object)idControle);
        String sql = this.getSqlCargeExistenteLancamentoCreditoImplantacaoSaldo();
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(LancamentoCreditoCargaExistenteDTO.class));
    }

    private String getSqlLancamentos() {
        return "SELECT DISTINCT   :idPessoa AS IDPESSOA,   A.NRANOCREDITO,   A.NRCREDITO,   A.IDTIPONATUREZACREDITO,   A.IDTIPOCREDITO,   A.IDTIPOOPERACAOCREDITO,   A.DTLANCAMENTO,   A.VLLANCAMENTO,   ATO.IDTCE AS CDCONTROLELEIATO FROM TCELANCCREDITO A JOIN TCEDEBITOLANCCREDITO B ON A.IDTCELANCCREDITO = B.IDTCELANCCREDITO JOIN TRIBDEBITOPARCELARECEITA TDPR ON B.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA JOIN TRIBGUIARECOLHIMENTO TGR  ON TDPR.ENTIDADE = TGR.ENTIDADE AND TDPR.EXERCICIO = TGR.EXERCICIO AND TDPR.GUIARECOLHIMENTO = TGR.GUIARECOLHIMENTO LEFT JOIN CGATO ATO  ON TGR.ENTIDADE = ATO.ENTIDADE AND TGR.FUNDAMENTOLEGAL = ATO.IDATO WHERE A.DTLANCAMENTO BETWEEN :dataInicial AND :dataFinal ORDER BY A.NRANOCREDITO, A.NRCREDITO ";
    }

    public List<LancamentoCreditoDTO> findLancamentos(@Param(value="entidade") Long entidade, @Param(value="idPessoa") Long idPessoa, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = this.getSqlLancamentos();
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(LancamentoCreditoDTO.class));
    }
}

