/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.simam.EstornoLancamentoCreditoDTO;
import br.com.elotech.tributos.repository.simam.EstornoLancamentoCreditoRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstornoLancamentoCreditoRepositoryImpl
implements EstornoLancamentoCreditoRepository {
    private static final String PESSOA = "idPessoa";
    private static final String ENTIDADE = "entidade";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String SQL_LANCAMENTOS = "select        :idPessoa AS idPessoa,        extract( year from cd.datacancelamento ) as nrAnoEstorno,        tlc.nrCredito,        tlc.nrAnoCredito,        ca.idtce as cdControleLeiAto,        cd.datacancelamento as dtEstorno,        substr(md.descricao  || '. ' || cd.motivo, 0, 250) as dsMotivo,        sum( tcdi.valor ) as vlEstorno from tribcancelamentodebito          cd left join tribmotivodesconto         md   on md.motivodesconto  = cd.motivocancelamento left join tribtipodeducao            td   on td.tipodeducao = coalesce(md.tipodeducao, cd.tipodeducao)      join tribcancelamentodebitoitem tcdi on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and tcdi.idcancelamento = cd.idcancelamento      join tceDebitoLancCredito       tdlc on tdlc.iddebitoParcelareceita = tcdi.iddebitoparcelareceita      join tcelanccredito             tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito left join cgato                      ca   on ca.entidade = cd.entidade and ca.idato = coalesce(md.idato, cd.idato) where (cd.datacancelamento between :dataInicial and :dataFinal)   and cd.entidade = :entidade   and td.tipotce = 8 /*estorno*/group by tlc.nrCredito,          tlc.nrAnoCredito,          ca.idtce,          cd.datacancelamento,          substr(md.descricao  || '. ' || cd.motivo, 0, 250)";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<EstornoLancamentoCreditoDTO> findLancamentos(Entidade entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)entidade.getIdentificacaoTce());
        parameters.addValue(ENTIDADE, (Object)entidade.getId());
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        return this.namedParameterJdbcTemplate.query(SQL_LANCAMENTOS, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoLancamentoCreditoDTO.class));
    }

    @Generated
    public EstornoLancamentoCreditoRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

