/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoDACargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoDividaAtivaDTO;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoDACustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AtualizacaoMonetariaCreditoDACustomRepositoryImpl
implements AtualizacaoMonetariaCreditoDACustomRepository {
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<AtualizacaoDividaAtivaDTO> findLancamentos(@Param(value="idPessoa") Long idPessoa, @Param(value="entidade") Long entidade, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoMonetariaDALancamentos.sql");
        sqlLancamentos = sqlLancamentos.replace(":entidade", entidade.toString());
        sqlLancamentos = sqlLancamentos.replace(":idPessoa", idPessoa.toString());
        sqlLancamentos = sqlLancamentos.replace(":dataInicial", String.format("'%s'", dataInicial));
        sqlLancamentos = sqlLancamentos.replace(":dataFinal", String.format("'%s'", dataFinal));
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoDividaAtivaDTO.class));
    }

    public List<AtualizacaoCreditoDACargaExistenteDTO> getCargaExistente(LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoMonetariaDACargaExistente.sql");
        sqlLancamentos = sqlLancamentos.replace(":dataInicial", String.format("'%s'", dataInicial));
        sqlLancamentos = sqlLancamentos.replace(":dataFinal", String.format("'%s'", dataFinal));
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoDACargaExistenteDTO.class));
    }

    @Generated
    public AtualizacaoMonetariaCreditoDACustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

