/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoDTO;
import br.com.elotech.tributos.repository.simam.AtualizacaoCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AtualizacaoCreditoCustomRepositoryImpl
implements AtualizacaoCreditoCustomRepository {
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<AtualizacaoCreditoCargaExistenteDTO> getCargaExistente(LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = this.getSqlCargaExistente();
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoCargaExistenteDTO.class));
    }

    public List<AtualizacaoCreditoDTO> findAtualizacoes(Long idPessoa, Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/atualizacaoCreditoLancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoDTO.class));
    }

    private String getSqlCargaExistente() {
        return "SELECT tam.idtipoatualizacaocredito|| '-' ||tlc.NRCREDITO|| '-' ||tlc.NRANOCREDITO|| '-' ||to_char(tam.dtatualizacao, 'yyyy-MM-dd') AS chave,        tam.idtceatualizamonecred AS id,        tam.idtipoatualizacaocredito,        tam.dtatualizacao,        tlc.nrcredito,        tlc.nranocredito FROM tceAtualizaMoneCred tam LEFT JOIN tceAtualizaMonePagamento tamp ON tamp.idtceatualizamonecred = tam.idtceatualizamonecred LEFT JOIN tceAtualizaMoneCredito tamc ON tamc.idtceatualizamonecred = tam.idtceatualizamonecred JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = coalesce(tamp.iddebitoparcelareceita, tamc.iddebitoparcelareceita) JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito WHERE tam.dtatualizacao BETWEEN :dataInicial AND :dataFinal";
    }

    @Generated
    public AtualizacaoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

