/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTO;
import br.com.elotech.tributos.repository.projections.CadastroGeralResponsavelProjection;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ProprietarioRepository
extends CrudRepository<Proprietario, Long> {
    @Query(value="SELECT     CG.CADASTROGERAL as cadastroGeral,     CG.IDCADASTROGERALISS as idCadastroGeralIss,     P.PESSOA as pessoa,     CG.TIPOCADASTRO as tipoCadastro,      CAST('PR' AS VARCHAR(2)) AS tipoVinculo  FROM PESSOA P  JOIN TRIBPROPRIETARIO PP ON      P.PESSOA = PP.PESSOA  JOIN TRIBCADASTROGERAL CG ON      PP.TIPOCADASTRO = CG.TIPOCADASTRO      AND PP.CADASTROGERAL = CG.CADASTROGERAL  JOIN TRIBVINCULO V ON      PP.VINCULO = V.VINCULO  WHERE P.CNPJ_CPF = ?1      AND CG.EXCLUSAOLOGICA = 'N' ", nativeQuery=true)
    public Stream<CadastroGeralResponsavelProjection> findResponsavel(String var1);

    @Query(value="SELECT  new br.com.elotech.tributos.dto.AtendimentoPessoaDTO(       pessoa.id as codigoPessoa,        pessoa.tipoPessoa as tipoPessoa,        pessoa.nome as nome,        pessoa.cnpjCpf as cnpjCpf,        count(distinct cg.id) as quantidadeCadastros  )  FROM Pessoa pessoa  left outer join Proprietario prop on prop.pessoa.id = pessoa.id  join CadastroGeral cg on cg.id = prop.cadastroGeral.id or cg.pessoa.id = pessoa.id WHERE (pessoa.cnpjCpf like :search OR UPPER(pessoa.nome) LIKE :search OR CAST(pessoa.id AS string) LIKE :search )  and cg.exclusaoLogica = false  GROUP BY pessoa.id, pessoa.tipoPessoa, pessoa.nome, pessoa.cnpjCpf ")
    public Page<AtendimentoPessoaDTO> findPessoa(@Param(value="search") String var1, Pageable var2);
}

