/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.DebitoParcelaTributoCotaUnicaDTO;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoCotaUnicaRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private static final String SQL_DISPONIVEL_WEB = "br/com/elotech/tributos/repository/find-debito-disponivel-web.sql";
    private static final String SQL_DISPONIVEL_WEB_POR_CADASTROS = "br/com/elotech/tributos/repository/find-debito-disponivel-web-por-cadastros.sql";

    public DebitoCotaUnicaRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoParcelaTributoCotaUnicaDTO> findAllDebitoParcelaReceitaDisponivelWeb(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, LocalDate dataVencimento) {
        String sql = FileUtils.readResourceAsString((String)SQL_DISPONIVEL_WEB);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("tipoCadastro", (Object)tipoCadastro);
        parameters.addValue("cadastroGeral", (Object)cadastroGeral);
        parameters.addValue("dataVencimento", (Object)Date.valueOf(dataVencimento), 91);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelaTributoCotaUnicaDTO.class));
    }

    public List<DebitoParcelaTributoCotaUnicaDTO> findAllDebitoParcelaReceitaDisponivelWeb(Long entidade, Long exercicio, LocalDate dataVencimento, List<Long> idsCadastro) {
        if (idsCadastro.isEmpty()) {
            return new ArrayList<DebitoParcelaTributoCotaUnicaDTO>();
        }
        String sql = FileUtils.readResourceAsString((String)SQL_DISPONIVEL_WEB_POR_CADASTROS);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("dataVencimento", (Object)Date.valueOf(dataVencimento), 91);
        String cadastros = idsCadastro.stream().map(cadastro -> String.format("(cg.idkey = %d)", cadastro)).collect(Collectors.joining(" or "));
        StringBuilder comandoSQL = new StringBuilder(sql).append(String.format(" AND ( %s ) ", cadastros));
        return this.jdbcTemplate.query(comandoSQL.toString(), (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelaTributoCotaUnicaDTO.class));
    }
}

