/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.TipoCapitalSocial;
import br.com.elotech.tributos.domain.TipoRegistroMercantil;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocial;
import br.com.elotech.tributos.dto.ContratoSocialPessoaDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import io.jsonwebtoken.lang.Assert;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ContratoSocialDTO {
    private Long id;
    private Long sequencia;
    private TipoCapitalSocial tipoCapitalSocial;
    private TipoRegistroMercantil tipoRegistroMercantil;
    private String contratoCartorioAlteracao;
    private String contratoRegistroAlteracao;
    private String contratoAverbacaoAlteracao;
    private LocalDate contratoDataAlteracao;
    private BigDecimal capitalSocial = BigDecimal.ZERO;
    private BigDecimal valorCotas = BigDecimal.ZERO;
    private String usuario;
    private Long numeroAlteracao;
    private String numeroJuntaComercial;
    private LocalDate dataRegistroJuntaComercial;
    private String observacaoDescricaoAlteracao;
    private Long cadastroMobiliario;
    private List<ContratoSocialPessoaDTO> pessoas = new ArrayList();

    public static ContratoSocialDTO from(ContratoSocial contratoSocial) {
        ContratoSocialDTO dto = new ContratoSocialDTO();
        dto.setId(contratoSocial.getId());
        dto.setSequencia(contratoSocial.getSequencia());
        dto.setTipoCapitalSocial(contratoSocial.getTipoCapitalSocial());
        dto.setTipoRegistroMercantil(contratoSocial.getTipoRegistroMercantil());
        dto.setContratoCartorioAlteracao(contratoSocial.getContratoCartorioAlteracao());
        dto.setContratoRegistroAlteracao(contratoSocial.getContratoRegistroAlteracao());
        dto.setContratoAverbacaoAlteracao(contratoSocial.getContratoAverbacaoAlteracao());
        dto.setContratoDataAlteracao(contratoSocial.getContratoDataAlteracao());
        dto.setCapitalSocial(contratoSocial.getCapitalSocial());
        dto.setValorCotas(contratoSocial.getValorCotas());
        dto.setUsuario(contratoSocial.getUsuario());
        dto.setNumeroAlteracao(contratoSocial.getNumeroAlteracao());
        dto.setNumeroJuntaComercial(contratoSocial.getNumeroJuntaComercial());
        dto.setDataRegistroJuntaComercial(contratoSocial.getDataRegistroJuntaComercial());
        dto.setObservacaoDescricaoAlteracao(contratoSocial.getObservacaoDescricaoAlteracao());
        dto.getPessoas().addAll(contratoSocial.getPessoas().stream().map(ContratoSocialPessoaDTO::from).collect(Collectors.toList()));
        return dto;
    }

    public ContratoSocial toEntity() {
        Assert.notNull((Object)this.cadastroMobiliario, (String)"Erro ao fazer convers\u00e3o de dados: Id do cadastro mobili\u00e1rio est\u00e1 nulo.");
        ContratoSocial contratoSocial = new ContratoSocial();
        contratoSocial.setId(this.id);
        contratoSocial.setSequencia(this.sequencia);
        contratoSocial.setTipoCapitalSocial(this.tipoCapitalSocial);
        contratoSocial.setTipoRegistroMercantil(this.tipoRegistroMercantil);
        contratoSocial.setContratoCartorioAlteracao(this.contratoCartorioAlteracao);
        contratoSocial.setContratoRegistroAlteracao(this.contratoRegistroAlteracao);
        contratoSocial.setContratoAverbacaoAlteracao(this.contratoAverbacaoAlteracao);
        contratoSocial.setContratoDataAlteracao(this.contratoDataAlteracao);
        contratoSocial.setCapitalSocial(this.capitalSocial);
        contratoSocial.setValorCotas(this.valorCotas);
        contratoSocial.setUsuario(SecurityUtils.getUserAise());
        contratoSocial.setNumeroAlteracao(this.numeroAlteracao);
        contratoSocial.setNumeroJuntaComercial(this.numeroJuntaComercial);
        contratoSocial.setDataRegistroJuntaComercial(this.dataRegistroJuntaComercial);
        contratoSocial.setObservacaoDescricaoAlteracao(this.observacaoDescricaoAlteracao);
        contratoSocial.getPessoas().addAll(this.pessoas.stream().map(ContratoSocialPessoaDTO::toEntity).collect(Collectors.toList()));
        return contratoSocial;
    }

    @Generated
    public ContratoSocialDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public TipoCapitalSocial getTipoCapitalSocial() {
        return this.tipoCapitalSocial;
    }

    @Generated
    public TipoRegistroMercantil getTipoRegistroMercantil() {
        return this.tipoRegistroMercantil;
    }

    @Generated
    public String getContratoCartorioAlteracao() {
        return this.contratoCartorioAlteracao;
    }

    @Generated
    public String getContratoRegistroAlteracao() {
        return this.contratoRegistroAlteracao;
    }

    @Generated
    public String getContratoAverbacaoAlteracao() {
        return this.contratoAverbacaoAlteracao;
    }

    @Generated
    public LocalDate getContratoDataAlteracao() {
        return this.contratoDataAlteracao;
    }

    @Generated
    public BigDecimal getCapitalSocial() {
        return this.capitalSocial;
    }

    @Generated
    public BigDecimal getValorCotas() {
        return this.valorCotas;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getNumeroAlteracao() {
        return this.numeroAlteracao;
    }

    @Generated
    public String getNumeroJuntaComercial() {
        return this.numeroJuntaComercial;
    }

    @Generated
    public LocalDate getDataRegistroJuntaComercial() {
        return this.dataRegistroJuntaComercial;
    }

    @Generated
    public String getObservacaoDescricaoAlteracao() {
        return this.observacaoDescricaoAlteracao;
    }

    @Generated
    public Long getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    @Generated
    public List<ContratoSocialPessoaDTO> getPessoas() {
        return this.pessoas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setTipoCapitalSocial(TipoCapitalSocial tipoCapitalSocial) {
        this.tipoCapitalSocial = tipoCapitalSocial;
    }

    @Generated
    public void setTipoRegistroMercantil(TipoRegistroMercantil tipoRegistroMercantil) {
        this.tipoRegistroMercantil = tipoRegistroMercantil;
    }

    @Generated
    public void setContratoCartorioAlteracao(String contratoCartorioAlteracao) {
        this.contratoCartorioAlteracao = contratoCartorioAlteracao;
    }

    @Generated
    public void setContratoRegistroAlteracao(String contratoRegistroAlteracao) {
        this.contratoRegistroAlteracao = contratoRegistroAlteracao;
    }

    @Generated
    public void setContratoAverbacaoAlteracao(String contratoAverbacaoAlteracao) {
        this.contratoAverbacaoAlteracao = contratoAverbacaoAlteracao;
    }

    @Generated
    public void setContratoDataAlteracao(LocalDate contratoDataAlteracao) {
        this.contratoDataAlteracao = contratoDataAlteracao;
    }

    @Generated
    public void setCapitalSocial(BigDecimal capitalSocial) {
        this.capitalSocial = capitalSocial;
    }

    @Generated
    public void setValorCotas(BigDecimal valorCotas) {
        this.valorCotas = valorCotas;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setNumeroAlteracao(Long numeroAlteracao) {
        this.numeroAlteracao = numeroAlteracao;
    }

    @Generated
    public void setNumeroJuntaComercial(String numeroJuntaComercial) {
        this.numeroJuntaComercial = numeroJuntaComercial;
    }

    @Generated
    public void setDataRegistroJuntaComercial(LocalDate dataRegistroJuntaComercial) {
        this.dataRegistroJuntaComercial = dataRegistroJuntaComercial;
    }

    @Generated
    public void setObservacaoDescricaoAlteracao(String observacaoDescricaoAlteracao) {
        this.observacaoDescricaoAlteracao = observacaoDescricaoAlteracao;
    }

    @Generated
    public void setCadastroMobiliario(Long cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    @Generated
    public void setPessoas(List<ContratoSocialPessoaDTO> pessoas) {
        this.pessoas = pessoas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContratoSocialDTO)) {
            return false;
        }
        ContratoSocialDTO other = (ContratoSocialDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        TipoCapitalSocial this$tipoCapitalSocial = this.getTipoCapitalSocial();
        TipoCapitalSocial other$tipoCapitalSocial = other.getTipoCapitalSocial();
        if (this$tipoCapitalSocial == null ? other$tipoCapitalSocial != null : !this$tipoCapitalSocial.equals(other$tipoCapitalSocial)) {
            return false;
        }
        TipoRegistroMercantil this$tipoRegistroMercantil = this.getTipoRegistroMercantil();
        TipoRegistroMercantil other$tipoRegistroMercantil = other.getTipoRegistroMercantil();
        if (this$tipoRegistroMercantil == null ? other$tipoRegistroMercantil != null : !this$tipoRegistroMercantil.equals(other$tipoRegistroMercantil)) {
            return false;
        }
        String this$contratoCartorioAlteracao = this.getContratoCartorioAlteracao();
        String other$contratoCartorioAlteracao = other.getContratoCartorioAlteracao();
        if (this$contratoCartorioAlteracao == null ? other$contratoCartorioAlteracao != null : !this$contratoCartorioAlteracao.equals(other$contratoCartorioAlteracao)) {
            return false;
        }
        String this$contratoRegistroAlteracao = this.getContratoRegistroAlteracao();
        String other$contratoRegistroAlteracao = other.getContratoRegistroAlteracao();
        if (this$contratoRegistroAlteracao == null ? other$contratoRegistroAlteracao != null : !this$contratoRegistroAlteracao.equals(other$contratoRegistroAlteracao)) {
            return false;
        }
        String this$contratoAverbacaoAlteracao = this.getContratoAverbacaoAlteracao();
        String other$contratoAverbacaoAlteracao = other.getContratoAverbacaoAlteracao();
        if (this$contratoAverbacaoAlteracao == null ? other$contratoAverbacaoAlteracao != null : !this$contratoAverbacaoAlteracao.equals(other$contratoAverbacaoAlteracao)) {
            return false;
        }
        LocalDate this$contratoDataAlteracao = this.getContratoDataAlteracao();
        LocalDate other$contratoDataAlteracao = other.getContratoDataAlteracao();
        if (this$contratoDataAlteracao == null ? other$contratoDataAlteracao != null : !((Object)this$contratoDataAlteracao).equals(other$contratoDataAlteracao)) {
            return false;
        }
        BigDecimal this$capitalSocial = this.getCapitalSocial();
        BigDecimal other$capitalSocial = other.getCapitalSocial();
        if (this$capitalSocial == null ? other$capitalSocial != null : !((Object)this$capitalSocial).equals(other$capitalSocial)) {
            return false;
        }
        BigDecimal this$valorCotas = this.getValorCotas();
        BigDecimal other$valorCotas = other.getValorCotas();
        if (this$valorCotas == null ? other$valorCotas != null : !((Object)this$valorCotas).equals(other$valorCotas)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        Long this$numeroAlteracao = this.getNumeroAlteracao();
        Long other$numeroAlteracao = other.getNumeroAlteracao();
        if (this$numeroAlteracao == null ? other$numeroAlteracao != null : !((Object)this$numeroAlteracao).equals(other$numeroAlteracao)) {
            return false;
        }
        String this$numeroJuntaComercial = this.getNumeroJuntaComercial();
        String other$numeroJuntaComercial = other.getNumeroJuntaComercial();
        if (this$numeroJuntaComercial == null ? other$numeroJuntaComercial != null : !this$numeroJuntaComercial.equals(other$numeroJuntaComercial)) {
            return false;
        }
        LocalDate this$dataRegistroJuntaComercial = this.getDataRegistroJuntaComercial();
        LocalDate other$dataRegistroJuntaComercial = other.getDataRegistroJuntaComercial();
        if (this$dataRegistroJuntaComercial == null ? other$dataRegistroJuntaComercial != null : !((Object)this$dataRegistroJuntaComercial).equals(other$dataRegistroJuntaComercial)) {
            return false;
        }
        String this$observacaoDescricaoAlteracao = this.getObservacaoDescricaoAlteracao();
        String other$observacaoDescricaoAlteracao = other.getObservacaoDescricaoAlteracao();
        if (this$observacaoDescricaoAlteracao == null ? other$observacaoDescricaoAlteracao != null : !this$observacaoDescricaoAlteracao.equals(other$observacaoDescricaoAlteracao)) {
            return false;
        }
        Long this$cadastroMobiliario = this.getCadastroMobiliario();
        Long other$cadastroMobiliario = other.getCadastroMobiliario();
        if (this$cadastroMobiliario == null ? other$cadastroMobiliario != null : !((Object)this$cadastroMobiliario).equals(other$cadastroMobiliario)) {
            return false;
        }
        List this$pessoas = this.getPessoas();
        List other$pessoas = other.getPessoas();
        return !(this$pessoas == null ? other$pessoas != null : !((Object)this$pessoas).equals(other$pessoas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContratoSocialDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        TipoCapitalSocial $tipoCapitalSocial = this.getTipoCapitalSocial();
        result = result * 59 + ($tipoCapitalSocial == null ? 43 : $tipoCapitalSocial.hashCode());
        TipoRegistroMercantil $tipoRegistroMercantil = this.getTipoRegistroMercantil();
        result = result * 59 + ($tipoRegistroMercantil == null ? 43 : $tipoRegistroMercantil.hashCode());
        String $contratoCartorioAlteracao = this.getContratoCartorioAlteracao();
        result = result * 59 + ($contratoCartorioAlteracao == null ? 43 : $contratoCartorioAlteracao.hashCode());
        String $contratoRegistroAlteracao = this.getContratoRegistroAlteracao();
        result = result * 59 + ($contratoRegistroAlteracao == null ? 43 : $contratoRegistroAlteracao.hashCode());
        String $contratoAverbacaoAlteracao = this.getContratoAverbacaoAlteracao();
        result = result * 59 + ($contratoAverbacaoAlteracao == null ? 43 : $contratoAverbacaoAlteracao.hashCode());
        LocalDate $contratoDataAlteracao = this.getContratoDataAlteracao();
        result = result * 59 + ($contratoDataAlteracao == null ? 43 : ((Object)$contratoDataAlteracao).hashCode());
        BigDecimal $capitalSocial = this.getCapitalSocial();
        result = result * 59 + ($capitalSocial == null ? 43 : ((Object)$capitalSocial).hashCode());
        BigDecimal $valorCotas = this.getValorCotas();
        result = result * 59 + ($valorCotas == null ? 43 : ((Object)$valorCotas).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        Long $numeroAlteracao = this.getNumeroAlteracao();
        result = result * 59 + ($numeroAlteracao == null ? 43 : ((Object)$numeroAlteracao).hashCode());
        String $numeroJuntaComercial = this.getNumeroJuntaComercial();
        result = result * 59 + ($numeroJuntaComercial == null ? 43 : $numeroJuntaComercial.hashCode());
        LocalDate $dataRegistroJuntaComercial = this.getDataRegistroJuntaComercial();
        result = result * 59 + ($dataRegistroJuntaComercial == null ? 43 : ((Object)$dataRegistroJuntaComercial).hashCode());
        String $observacaoDescricaoAlteracao = this.getObservacaoDescricaoAlteracao();
        result = result * 59 + ($observacaoDescricaoAlteracao == null ? 43 : $observacaoDescricaoAlteracao.hashCode());
        Long $cadastroMobiliario = this.getCadastroMobiliario();
        result = result * 59 + ($cadastroMobiliario == null ? 43 : ((Object)$cadastroMobiliario).hashCode());
        List $pessoas = this.getPessoas();
        result = result * 59 + ($pessoas == null ? 43 : ((Object)$pessoas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContratoSocialDTO(id=" + this.getId() + ", sequencia=" + this.getSequencia() + ", tipoCapitalSocial=" + this.getTipoCapitalSocial() + ", tipoRegistroMercantil=" + this.getTipoRegistroMercantil() + ", contratoCartorioAlteracao=" + this.getContratoCartorioAlteracao() + ", contratoRegistroAlteracao=" + this.getContratoRegistroAlteracao() + ", contratoAverbacaoAlteracao=" + this.getContratoAverbacaoAlteracao() + ", contratoDataAlteracao=" + this.getContratoDataAlteracao() + ", capitalSocial=" + this.getCapitalSocial() + ", valorCotas=" + this.getValorCotas() + ", usuario=" + this.getUsuario() + ", numeroAlteracao=" + this.getNumeroAlteracao() + ", numeroJuntaComercial=" + this.getNumeroJuntaComercial() + ", dataRegistroJuntaComercial=" + this.getDataRegistroJuntaComercial() + ", observacaoDescricaoAlteracao=" + this.getObservacaoDescricaoAlteracao() + ", cadastroMobiliario=" + this.getCadastroMobiliario() + ", pessoas=" + this.getPessoas() + ")";
    }
}

