/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.calculo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.TipoCalculoTributoScript;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@Table(name="calculotributoscript")
@Entity
public class CalculoTributoScript
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="SEQ_CALCULOTRIBUTOSCRIPT", applyOnMerge=true)
    private Long id;
    @ManyToOne
    @JoinColumn(name="IDCALCULOTRIBUTO")
    @JsonIgnore
    @MetaModelIgnore
    private CalculoTributo calculoTributo;
    private Long ordem;
    private String identificador;
    private Boolean obrigatorio = Boolean.FALSE;
    @Enumerated(value=EnumType.STRING)
    private TipoCalculoTributoScript tipo;
    private String expressao;
    private String expressaoVerdadeira;
    private String expressaoFalsa;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idcampodinamico", referencedColumnName="id")
    @JsonIgnoreProperties(value={"validacoes", "alternativas"})
    private Campo campoDinamico;

    public String getTributo() {
        return Optional.ofNullable(this.calculoTributo).map(CalculoTributo::getTributo).map(Tributo::getTributo).orElse("");
    }

    public static CalculoTributoScript expressaoCondicional(String identificador, String condicao, String expressaoVerdadeira, String expressaoFalsa, Boolean obrigatoria) {
        CalculoTributoScript linha = new CalculoTributoScript();
        linha.tipo = TipoCalculoTributoScript.CONDICIONAL;
        linha.identificador = identificador;
        linha.expressao = condicao;
        linha.expressaoVerdadeira = expressaoVerdadeira;
        linha.expressaoFalsa = expressaoFalsa;
        linha.obrigatorio = obrigatoria;
        return linha;
    }

    public static CalculoTributoScript expressaoCondicional(String identificador, String condicao, String expressaoVerdadeira, String expressaoFalsa) {
        return CalculoTributoScript.expressaoCondicional((String)identificador, (String)condicao, (String)expressaoVerdadeira, (String)expressaoFalsa, (Boolean)Boolean.FALSE);
    }

    public static CalculoTributoScript expressao(String identificador, String expressao, Boolean obrigatoria) {
        CalculoTributoScript linha = new CalculoTributoScript();
        linha.tipo = TipoCalculoTributoScript.NORMAL;
        linha.identificador = identificador;
        linha.expressao = expressao;
        linha.obrigatorio = obrigatoria;
        return linha;
    }

    public static CalculoTributoScript expressao(String identificador, String expressao) {
        return CalculoTributoScript.expressao((String)identificador, (String)expressao, (Boolean)Boolean.FALSE);
    }

    @Generated
    public CalculoTributoScript() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CalculoTributo getCalculoTributo() {
        return this.calculoTributo;
    }

    @Generated
    public Long getOrdem() {
        return this.ordem;
    }

    @Generated
    public String getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Boolean getObrigatorio() {
        return this.obrigatorio;
    }

    @Generated
    public TipoCalculoTributoScript getTipo() {
        return this.tipo;
    }

    @Generated
    public String getExpressao() {
        return this.expressao;
    }

    @Generated
    public String getExpressaoVerdadeira() {
        return this.expressaoVerdadeira;
    }

    @Generated
    public String getExpressaoFalsa() {
        return this.expressaoFalsa;
    }

    @Generated
    public Campo getCampoDinamico() {
        return this.campoDinamico;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCalculoTributo(CalculoTributo calculoTributo) {
        this.calculoTributo = calculoTributo;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setObrigatorio(Boolean obrigatorio) {
        this.obrigatorio = obrigatorio;
    }

    @Generated
    public void setTipo(TipoCalculoTributoScript tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setExpressao(String expressao) {
        this.expressao = expressao;
    }

    @Generated
    public void setExpressaoVerdadeira(String expressaoVerdadeira) {
        this.expressaoVerdadeira = expressaoVerdadeira;
    }

    @Generated
    public void setExpressaoFalsa(String expressaoFalsa) {
        this.expressaoFalsa = expressaoFalsa;
    }

    @Generated
    public void setCampoDinamico(Campo campoDinamico) {
        this.campoDinamico = campoDinamico;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoTributoScript)) {
            return false;
        }
        CalculoTributoScript other = (CalculoTributoScript)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoTributoScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoTributoScript(id=" + this.getId() + ", ordem=" + this.getOrdem() + ", identificador=" + this.getIdentificador() + ", expressao=" + this.getExpressao() + ", expressaoVerdadeira=" + this.getExpressaoVerdadeira() + ", expressaoFalsa=" + this.getExpressaoFalsa() + ")";
    }
}

