/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroIsencaoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.calculo.dto.InconsistenciaCalculoDTO;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CadastroCalculoRoot {
    private Long id;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private List<CadastroCalculoDTO> children = new ArrayList();
    private Map<CalculoTributo, CalculoResultadoDTO> resultado = new HashMap();
    private List<InconsistenciaCalculoDTO> inconsistencias = new ArrayList();
    private List<CadastroIsencaoDTO> isencoes = new ArrayList();

    public void addInconsistencia(String tributo, Long idDivida, String mensagem) {
        InconsistenciaCalculoDTO inconsistencia = new InconsistenciaCalculoDTO();
        inconsistencia.setTributo(tributo);
        inconsistencia.setMessage(mensagem);
        inconsistencia.setIdDivida(idDivida);
        this.inconsistencias.add(inconsistencia);
    }

    public void addResultado(CalculoTributo tributo, CalculoContext context) {
        CalculoResultadoDTO resultadoDTO = new CalculoResultadoDTO();
        resultadoDTO.setClassificacaoTipoTributo(tributo.getTributo().getTipoTributo().getClassificacaoTipoTributo());
        resultadoDTO.setCache(context.getCache());
        resultadoDTO.setIdentificadorValor(tributo.getIdentificadorResultado());
        resultadoDTO.setIdentificadorValorBase(tributo.getIdentificadorBaseCalculo());
        resultadoDTO.setIdentificadorCondicao(tributo.getIdentificadorCondicao());
        resultadoDTO.setIdentificadorAliquota(tributo.getIdentificadorAliquota());
        resultadoDTO.setTrace(context.getTrace());
        this.resultado.put(tributo, resultadoDTO);
    }

    @Generated
    public CadastroCalculoRoot() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public List<CadastroCalculoDTO> getChildren() {
        return this.children;
    }

    @Generated
    public Map<CalculoTributo, CalculoResultadoDTO> getResultado() {
        return this.resultado;
    }

    @Generated
    public List<InconsistenciaCalculoDTO> getInconsistencias() {
        return this.inconsistencias;
    }

    @Generated
    public List<CadastroIsencaoDTO> getIsencoes() {
        return this.isencoes;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setChildren(List<CadastroCalculoDTO> children) {
        this.children = children;
    }

    @Generated
    public void setResultado(Map<CalculoTributo, CalculoResultadoDTO> resultado) {
        this.resultado = resultado;
    }

    @Generated
    public void setInconsistencias(List<InconsistenciaCalculoDTO> inconsistencias) {
        this.inconsistencias = inconsistencias;
    }

    @Generated
    public void setIsencoes(List<CadastroIsencaoDTO> isencoes) {
        this.isencoes = isencoes;
    }

    @Generated
    public String toString() {
        return "CadastroCalculoRoot(id=" + this.getId() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", children=" + this.getChildren() + ", resultado=" + this.getResultado() + ", inconsistencias=" + this.getInconsistencias() + ", isencoes=" + this.getIsencoes() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroCalculoRoot)) {
            return false;
        }
        CadastroCalculoRoot other = (CadastroCalculoRoot)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        return !(this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroCalculoRoot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        return result;
    }
}

