/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.domain.TabelaValorCelula;
import br.com.elotech.tributos.calculo.domain.TabelaValorColuna;
import br.com.elotech.tributos.calculo.domain.TipoCampo;
import br.com.elotech.tributos.calculo.dto.TabelaValorDTO;
import br.com.elotech.tributos.calculo.dto.TabelaValorParametroDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TABELAVALOR")
public class TabelaValor
implements EloEntity<Long> {
    public static final String COLUNA_RESULTADO = "resultado";
    @Id
    @Column
    @EloSequence(sequenceName="STABELAVALOR")
    private Long id;
    @NotBlank
    @Length(max=250)
    private @NotBlank @Length(max=250) String nome;
    @NotBlank
    @Length(max=250)
    private @NotBlank @Length(max=250) String descricao;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    @NotEmpty
    @JsonIgnore
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="tabelaValor")
    @OrderBy(value="coluna")
    private List<TabelaValorColuna> colunas = new ArrayList();

    public String getNome() {
        return StringUtils.lowerCase((String)this.nome);
    }

    public void setNome(String nome) {
        this.nome = StringUtils.lowerCase((String)nome);
    }

    @JsonIgnore
    public String geraAssinaturaTabelaValor() {
        String tipoRetornoOpenL = "DoubleValue";
        String prefixoArgumento = "arg";
        Long maiorColuna = this.colunas.stream().map(TabelaValorColuna::getColuna).max(Long::compareTo).orElse(0L);
        String arguments = this.getColunasOrdenadas().stream().filter(coluna -> coluna.getColuna() < maiorColuna).map(coluna -> String.format("%s %s%d", coluna.getTipo().getDescricao(), "arg", coluna.getColuna())).collect(Collectors.joining(","));
        return String.format("%s %s(%s)", "DoubleValue", this.getNome(), arguments);
    }

    public static TabelaValor of(TabelaValorDTO dto) {
        TabelaValor tabelaValor = new TabelaValor();
        tabelaValor.setId(dto.getId());
        tabelaValor.setNome(dto.getNome());
        tabelaValor.setDescricao(dto.getDescricao());
        tabelaValor.setEntidade(dto.getEntidade());
        tabelaValor.setExercicio(dto.getExercicio());
        dto.getParametros().forEach(parametro -> {
            TabelaValorColuna tabelaValorColuna = TabelaValorColuna.of((TabelaValorParametroDTO)parametro);
            tabelaValor.addColunaECelulas(tabelaValorColuna, dto.getLinhas(), parametro.getReferenciaParametro());
        });
        tabelaValor.geraColunaResultado(dto.getLinhas());
        return tabelaValor;
    }

    public void addColuna(TabelaValorColuna coluna) {
        coluna.setTabelaValor(this);
        this.colunas.add(coluna);
    }

    public void addColunaECelulas(TabelaValorColuna tabelaValorColuna, List<Map<String, String>> linhas, String referenciaColuna) {
        for (int linha = 0; linha < linhas.size(); ++linha) {
            String valorCelula = linhas.get(linha).get(referenciaColuna);
            if (!StringUtils.isNotBlank((CharSequence)valorCelula)) continue;
            TabelaValorCelula tabelaValorCelula = new TabelaValorCelula();
            tabelaValorCelula.setLinha(Long.valueOf(linha + 1));
            tabelaValorCelula.setValor(valorCelula);
            tabelaValorColuna.addCelula(tabelaValorCelula);
        }
        this.addColuna(tabelaValorColuna);
    }

    public void geraColunaResultado(List<Map<String, String>> linhas) {
        TabelaValorColuna tabelaValorColuna = new TabelaValorColuna();
        tabelaValorColuna.setDescricao(COLUNA_RESULTADO);
        tabelaValorColuna.setTipo(TipoCampo.DOUBLE);
        tabelaValorColuna.setColuna(Long.valueOf(this.getColunas().stream().map(TabelaValorColuna::getColuna).max(Long::compare).orElse(0L) + 1L));
        this.addColunaECelulas(tabelaValorColuna, linhas, tabelaValorColuna.getDescricao());
    }

    public void merge(TabelaValor tabelaValorAtualizada) {
        this.setDescricao(tabelaValorAtualizada.getDescricao());
        this.setNome(tabelaValorAtualizada.getNome());
        tabelaValorAtualizada.getColunas().forEach(colunaAtualizada -> {
            TabelaValorColuna colunaExistente;
            if (colunaAtualizada.getDescricao().equalsIgnoreCase(COLUNA_RESULTADO)) {
                colunaAtualizada.setId((Long)this.colunas.stream().filter(coluna -> coluna.getDescricao().equalsIgnoreCase(colunaAtualizada.getDescricao())).map(TabelaValorColuna::getId).findFirst().orElse(null));
            }
            if (Objects.nonNull(colunaExistente = (TabelaValorColuna)this.colunas.stream().filter(coluna -> Objects.nonNull(colunaAtualizada.getId()) && colunaAtualizada.equals(coluna)).findFirst().orElse(null))) {
                colunaExistente.setDescricao(colunaAtualizada.getDescricao());
                colunaExistente.setTipo(colunaAtualizada.getTipo());
                colunaExistente.setColuna(colunaAtualizada.getColuna());
                colunaAtualizada.getCelulas().forEach(celulaAtualizada -> {
                    TabelaValorCelula celulaSalva = colunaExistente.getCelulas().stream().filter(celula -> celula.getLinha().equals(celulaAtualizada.getLinha())).findFirst().orElse(null);
                    if (Objects.nonNull(celulaSalva)) {
                        celulaSalva.setValor(celulaAtualizada.getValor());
                    } else {
                        colunaExistente.addCelula(celulaAtualizada);
                    }
                });
                colunaExistente.getCelulas().removeIf(tabelaValorCelula -> colunaAtualizada.getCelulas().stream().noneMatch(celulaAtualizada -> celulaAtualizada.getLinha().equals(tabelaValorCelula.getLinha())));
            } else {
                this.addColuna(colunaAtualizada);
            }
        });
        this.colunas.removeIf(colunaAntiga -> tabelaValorAtualizada.getColunas().stream().noneMatch(arg_0 -> ((TabelaValorColuna)colunaAntiga).equals(arg_0)));
    }

    public List<TabelaValorColuna> getColunasOrdenadas() {
        return this.getColunas().stream().sorted(Comparator.comparing(TabelaValorColuna::getColuna)).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<TabelaValorColuna> getColunasParametros() {
        return this.getColunasOrdenadas().stream().filter(coluna -> !coluna.getDescricao().equals(COLUNA_RESULTADO)).collect(Collectors.toList());
    }

    @Generated
    public TabelaValor() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public List<TabelaValorColuna> getColunas() {
        return this.colunas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setColunas(List<TabelaValorColuna> colunas) {
        this.colunas = colunas;
    }

    @Generated
    public String toString() {
        return "TabelaValor(id=" + this.getId() + ", nome=" + this.getNome() + ", descricao=" + this.getDescricao() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", colunas=" + this.getColunas() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabelaValor)) {
            return false;
        }
        TabelaValor other = (TabelaValor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TabelaValor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

