/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoCreditoBatchReader
extends JdbcCursorItemReader<LancamentoCreditoConsultaDTO> {
    public LancamentoCreditoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, ObjectMapper objectMapper) throws Exception {
        Long entidade = (Long)jobParameters.get("entidade");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataFinal")));
        this.setFetchSize(1000);
        this.setName("simamLancamentoCreditoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(LancamentoCreditoConsultaDTO.class));
        String sqlBase = "SELECT CASE WHEN (tcrt.tributavel = 'S') THEN 1 ELSE 2 END AS idTipoNaturezaCredito,  trt.classificacaoreceitatipo AS idTipoCredito,  1 AS idTipoOperacaoCredito,  CASE   WHEN td.datacontabilizacao IS NOT NULL THEN td.datacontabilizacao   WHEN td.datacontabilizacao IS NULL AND tgr.tipoguiarecolhimento <> 'H' THEN td.datainclusao   WHEN td.datacontabilizacao IS NULL AND tgr.tipoguiarecolhimento  = 'H' THEN tdp.datalancamento   END AS dtlancamento,  coalesce(tdpr.valororiginal, tdpr.valor) AS vlLancamento,  tdpr.iddebitoparcelareceita,  td.entidade,  tdpr.exercicio,  tgr.idkey as idDivida,  tdpr.guiarecolhimento AS divida,  td.formacorrecao FROM tribdebitoparcelareceita tdpr JOIN tribdebitoparcela tdp   ON tdp.entidade = tdpr.entidade  AND tdp.exercicio = tdpr.exercicio  AND tdp.tipocadastro = tdpr.tipocadastro  AND tdp.cadastrogeral = tdpr.cadastrogeral  AND tdp.guiarecolhimento = tdpr.guiarecolhimento  AND tdp.subdivida = tdpr.subdivida  AND tdp.parcela = tdpr.parcela JOIN tribdebito td   ON td.entidade = tdp.entidade  AND td.exercicio = tdp.exercicio  AND td.tipocadastro = tdp.tipocadastro  AND td.cadastrogeral = tdp.cadastrogeral  AND td.guiarecolhimento = tdp.guiarecolhimento  AND td.subdivida = tdp.subdivida JOIN tribguiarecolhimento tgr   ON td.entidade = tgr.entidade  AND td.exercicio = tgr.exercicio  AND td.guiarecolhimento = tgr.guiarecolhimento JOIN tribreceita tr   ON tr.receita = tdpr.receita  AND tr.exercicio = tdpr.exercicio  AND tr.entidade = tdpr.entidade JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita JOIN tribclassificacaoreceitatipo tcrt   ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo  WHERE trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)   and ((tdp.situacaolegal = 0) or (tdp.situacaolegal in (1,2) and tdp.datadividaativa BETWEEN :dataInicial AND :dataFinal))   AND td.entidade = :entidade   AND td.constituido = 'S'   AND ((td.datacontabilizacao BETWEEN :dataInicial AND :dataFinal) OR      (td.datacontabilizacao IS NULL AND tgr.tipoguiarecolhimento <> 'H' AND td.datainclusao BETWEEN :dataInicial AND :dataFinal) OR      (td.datacontabilizacao IS NULL AND tgr.tipoguiarecolhimento  = 'H' AND tdp.datalancamento BETWEEN :dataInicial AND :dataFinal))  and coalesce(tdpr.valororiginal, tdpr.valor) > 0  AND not exists(            select 1            from tribparcelamentodebitoorigem tpdo            where tpdo.iddebitonovo = td.iddebito           )   AND NOT EXISTS (SELECT 1 FROM tcedebitolanccredito tdlc                   WHERE tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita)   and not exists(select 1                 from triblivroparcelareceita tlpr                          inner join tribdebitoparcelareceita tdpro                                     on tlpr.iddebitoparcelareceita = tdpro.iddebitoparcelareceita                          inner join tribdebitoparcelareceita tdprd on tdprd.entidade = tdpro.entidade                     and tdprd.exercicio = tdpro.exercicio                     and tdprd.tipocadastro = tdpro.tipocadastro                     and tdprd.cadastrogeral = tdpro.cadastrogeral                     and tdprd.guiarecolhimento = tdpro.guiarecolhimento                     and tdprd.subdivida = tlpr.novasubdivida                     and tdprd.receita = tdpro.receita                 where tdprd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita                   and tdprd.subdivida != tdpro.subdivida) ORDER BY dtlancamento ASC, idTipoNaturezaCredito ASC, idTipoCredito ASC, exercicio ASC, divida ASC";
        String sqlComParametros = sqlBase.replace(":dataInicial", StringUtils.wrap((String)dataInicial.toString(), (String)"'")).replace(":dataFinal", StringUtils.wrap((String)dataFinal.toString(), (String)"'")).replace(":entidade", entidade.toString());
        this.setSql(sqlComParametros);
    }
}

