/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.deducaocredito;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoDeducaoEnum;
import br.com.elotech.tributos.domain.simam.DeducaoCancelamento;
import br.com.elotech.tributos.domain.simam.DeducaoCancelamentoId;
import br.com.elotech.tributos.domain.simam.DeducaoCredito;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoConsultaDTO;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCredito;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCreditoId;
import br.com.elotech.tributos.domain.simam.DeducaoIsencao;
import br.com.elotech.tributos.domain.simam.DeducaoIsencaoId;
import br.com.elotech.tributos.domain.simam.DeducaoPagamento;
import br.com.elotech.tributos.domain.simam.DeducaoPagamentoId;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.domain.simam.TipoDeducaoCredito;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class DeducaoCreditoBatchProcessor
implements ItemProcessor<DeducaoCreditoConsultaDTO, TipoDeducaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeducaoCreditoBatchProcessor.class);
    private AtomicLong ultimoNrDeducao = new AtomicLong(0L);
    private Long nrAnoDeducao;
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final DeducaoCreditoRepository deducaoCreditoRepository;
    private final EntidadeRepository entidadeRepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("SIM-AM - Dedu\u00e7\u00e3o Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LOGGER.info("SIM-AM - Dedu\u00e7\u00e3o Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
        this.nrAnoDeducao = dataInicial.getYear();
        LOGGER.info("SIM-AM - Dedu\u00e7\u00e3o Cr\u00e9dito - atualizando \u00faltimo NrDeducao");
        this.ultimoNrDeducao.set(this.deducaoCreditoRepository.findNextNrDeducaoByExercicio(Long.valueOf(dataInicial.getYear())));
    }

    public TipoDeducaoCredito process(DeducaoCreditoConsultaDTO item) {
        Long finalId = this.sequenceGeneratorRepository.getNextVal("S05IDTCEDEDUCAOCREDITO");
        DeducaoCredito deducaoCredito = new DeducaoCredito();
        deducaoCredito.setId(finalId);
        deducaoCredito.setDtDeducao(item.getDtDeducao());
        deducaoCredito.setVlDeducao(item.getValor());
        deducaoCredito.setIdTipoDeducaoCredito(TipoDeducaoEnum.fromValue((Long)item.getIdTipoDeducaoCredito()));
        deducaoCredito.setMotivo(item.getDsMotivo());
        deducaoCredito.setNrAnoDeducao(this.nrAnoDeducao);
        deducaoCredito.setNrDeducao(Long.valueOf(this.ultimoNrDeducao.getAndIncrement()));
        LOGGER.info("SIM-AM - Dedu\u00e7\u00e3o Cr\u00e9dito - gerando novo registro -> {} ({}/{})", new Object[]{finalId, deducaoCredito.getNrDeducao(), deducaoCredito.getNrAnoDeducao()});
        this.deducaoCreditoRepository.saveAndFlush((Object)deducaoCredito);
        if (Objects.isNull(item.getIdCancelamento()) && Objects.isNull(item.getIdpagamentobloqueto()) && Objects.isNull(item.getIddebitoreceita()) && Objects.isNull(item.getIdcreditocontribuinteitem())) {
            return null;
        }
        if (Objects.nonNull(item.getIdCancelamento())) {
            DeducaoCancelamentoId id = new DeducaoCancelamentoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIddebitoparcelareceita()));
            id.setEntidade((Entidade)this.entidadeRepository.getOne((Object)item.getEntidade()));
            id.setExercicio(item.getExercicio());
            id.setIdCancelamento(item.getIdCancelamento());
            DeducaoCancelamento deducaoCancelamento = new DeducaoCancelamento();
            deducaoCancelamento.setId(id);
            return deducaoCancelamento;
        }
        if (Objects.nonNull(item.getIdpagamentobloqueto())) {
            DeducaoPagamentoId id = new DeducaoPagamentoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setIdPagamentoBoleto(item.getIdpagamentobloqueto());
            id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIddebitoparcelareceita()));
            DeducaoPagamento deducaoPagamento = new DeducaoPagamento();
            deducaoPagamento.setId(id);
            return deducaoPagamento;
        }
        if (Objects.nonNull(item.getIddebitoreceita())) {
            DeducaoIsencaoId id = new DeducaoIsencaoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setIdDebitoReceita(item.getIddebitoreceita());
            DeducaoIsencao deducaoIsencao = new DeducaoIsencao();
            deducaoIsencao.setId(id);
            return deducaoIsencao;
        }
        if (Objects.nonNull(item.getIdcreditocontribuinteitem())) {
            DeducaoCreditoCreditoId id = new DeducaoCreditoCreditoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setCreditoContribuinteItem(item.getIdcreditocontribuinteitem());
            id.setIdDebitoParcelaReceita(item.getIddebitoparcelareceita());
            DeducaoCreditoCredito deducaoCreditoCredito = new DeducaoCreditoCredito();
            deducaoCreditoCredito.setId(id);
            return deducaoCreditoCredito;
        }
        return null;
    }

    @OnProcessError
    public void onProcessError(LancamentoCreditoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error("SIM-AM - Dedu\u00e7\u00e3o Cr\u00e9dito - erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item));
        throw e;
    }

    @Generated
    public DeducaoCreditoBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, DeducaoCreditoRepository deducaoCreditoRepository, EntidadeRepository entidadeRepository) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.deducaoCreditoRepository = deducaoCreditoRepository;
        this.entidadeRepository = entidadeRepository;
    }
}

