/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaomonetariada;

import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoDA;
import br.com.elotech.tributos.domain.simam.AtualizacaoMonetariaCreditoParcelamentoDAId;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.domain.simam.TipoAtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.simam.AtualizacaoMonetariaDAParcelamentoDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoMonetariaDAParcelamentoNrDividaDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoMonetariaDAParcelamentoReceitaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoDARepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoParcelamentoDARepository;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class AtualizacaoMonetariaCreditoParcelamentoDABatchProcessor
implements ItemProcessor<AtualizacaoMonetariaDAParcelamentoReceitaDTO, TipoAtualizacaoMonetariaCreditoDA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtualizacaoMonetariaCreditoParcelamentoDABatchProcessor.class);
    private static String PREFIXO = "SIM-AM - Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa (Parcelamento) - ";
    private AtomicLong ultimoNrAtualizacao = new AtomicLong(0L);
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private Long nrAnoAtualizacao;
    private StepExecution stepExecution;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final AtualizacaoMonetariaCreditoDARepository atualizacaoMonetariaCreditoDARepository;
    private final AtualizacaoMonetariaCreditoParcelamentoDARepository atualizacaoMonetariaCreditoParcelamentoDARepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info(PREFIXO + "Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LOGGER.info(PREFIXO + "Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
        this.nrAnoAtualizacao = dataInicial.getYear();
        LOGGER.info(PREFIXO + "Atualizando \u00faltimo NrAtualizacao");
        this.ultimoNrAtualizacao.set(this.atualizacaoMonetariaCreditoDARepository.findNextNrAtualizacaoByExercicio(Long.valueOf(dataInicial.getYear())));
        LOGGER.info(PREFIXO + "load da carga existente");
        this.atualizacaoMonetariaCreditoDARepository.getCargaExistente(dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceAtualizamoneCredDA()));
    }

    public TipoAtualizacaoMonetariaCreditoDA process(AtualizacaoMonetariaDAParcelamentoReceitaDTO item) {
        List parcelamentoReceita = this.atualizacaoMonetariaCreditoParcelamentoDARepository.loadParcelamentoDA(item.getReceita(), item.getIdParcelamento());
        for (AtualizacaoMonetariaDAParcelamentoDTO parcelamento : parcelamentoReceita) {
            List nrDividas = this.atualizacaoMonetariaCreditoParcelamentoDARepository.loadParcelamentoDANrDivida(ClassificacaoTributo.fromValue((String)parcelamento.getClassificacao()), parcelamento.getIdParcelamento(), parcelamento.getReceitaPrincipal(), parcelamento.getReceita());
            for (AtualizacaoMonetariaDAParcelamentoNrDividaDTO divida : nrDividas) {
                String chave = String.format("%d-%d-%d-%s", parcelamento.getIdTipoAtualizacaoCredito(), divida.getNrDivida(), divida.getNrAnoDivida(), parcelamento.getDtAtualizacao().toString());
                Long l = this.cargaExistente.compute(chave, (k, v) -> {
                    if (Objects.nonNull(v)) {
                        return v;
                    }
                    BigDecimal valor = Optional.of(divida).map(AtualizacaoMonetariaDAParcelamentoNrDividaDTO::getPercentual).filter(percentual -> percentual.signum() > 0).map(percentual -> percentual.divide(new BigDecimal(100.0)).multiply(parcelamento.getVlAtualizacao())).orElse(BigDecimal.ZERO);
                    Long nextId = this.sequenceGeneratorRepository.getNextVal("S05IDTCEATUALIZAMONECREDDA");
                    AtualizacaoMonetariaCreditoDA atualizacao = new AtualizacaoMonetariaCreditoDA();
                    atualizacao.setId(nextId);
                    atualizacao.setDtAtualizacao(parcelamento.getDtAtualizacao());
                    atualizacao.setIdTipoAtualizacaoCredito(parcelamento.getIdTipoAtualizacaoCredito());
                    atualizacao.setNrAtualizacao(Long.valueOf(this.ultimoNrAtualizacao.getAndIncrement()));
                    atualizacao.setVlAtualizacao(valor);
                    atualizacao.setNrAnoAtualizacao(this.nrAnoAtualizacao);
                    LOGGER.info(PREFIXO + "Gerando novo registro -> {} ({}/{})", new Object[]{nextId, atualizacao.getNrAtualizacao(), atualizacao.getNrAnoAtualizacao()});
                    this.atualizacaoMonetariaCreditoDARepository.saveAndFlush((Object)atualizacao);
                    AtualizacaoMonetariaCreditoParcelamentoDAId id = new AtualizacaoMonetariaCreditoParcelamentoDAId();
                    id.setIdParcelamento(item.getIdParcelamento());
                    id.setAtualizacaoMonetariaCreditoDA(nextId);
                    id.setIdDebitoParcelaReceita(divida.getIdDebitoParcelaReceita());
                    AtualizacaoMonetariaCreditoParcelamentoDA parcelamentoDA = new AtualizacaoMonetariaCreditoParcelamentoDA();
                    parcelamentoDA.setAtualizacaoMonetariaCreditoParcelamentoDAId(id);
                    parcelamentoDA.setValor(valor);
                    this.atualizacaoMonetariaCreditoParcelamentoDARepository.save((Object)parcelamentoDA);
                    return nextId;
                });
            }
        }
        return null;
    }

    @OnProcessError
    public void onProcessError(LancamentoCreditoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error(PREFIXO + "Erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item));
        throw e;
    }

    @Generated
    public AtualizacaoMonetariaCreditoParcelamentoDABatchProcessor(SequenceGeneratorRepository sequenceGeneratorRepository, AtualizacaoMonetariaCreditoDARepository atualizacaoMonetariaCreditoDARepository, AtualizacaoMonetariaCreditoParcelamentoDARepository atualizacaoMonetariaCreditoParcelamentoDARepository) {
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.atualizacaoMonetariaCreditoDARepository = atualizacaoMonetariaCreditoDARepository;
        this.atualizacaoMonetariaCreditoParcelamentoDARepository = atualizacaoMonetariaCreditoParcelamentoDARepository;
    }
}

