/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.arrecadacaocredito;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCredito;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoConsultaDTO;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoCreditoContribuinteId;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoPagamento;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoPagamentoId;
import br.com.elotech.tributos.domain.simam.TipoArrecadacaoCredito;
import br.com.elotech.tributos.dto.TipoArrecadacao;
import br.com.elotech.tributos.dto.diarioarrecadacao.TipoOrigemReceita;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ArrecadacaoCreditoBatchProcessor
implements ItemProcessor<ArrecadacaoCreditoConsultaDTO, TipoArrecadacaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrecadacaoCreditoBatchProcessor.class);
    private static final String PREFIXO = "SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - ";
    private AtomicLong ultimoNrArrecadacao = new AtomicLong(0L);
    private Long nrAnoArrecadacao;
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final ArrecadacaoCreditoRepository arrecadacaoCreditoRepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
        this.nrAnoArrecadacao = dataInicial.getYear();
        LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Atualizando \u00faltimo NrArrecadacao");
        this.ultimoNrArrecadacao.set(this.arrecadacaoCreditoRepository.findNextNrArrecadacaoByExercicio(this.nrAnoArrecadacao));
    }

    public TipoArrecadacaoCredito process(ArrecadacaoCreditoConsultaDTO item) {
        Long finalId = this.sequenceGeneratorRepository.getNextVal("S05IDTCEARRTIPOCREDITO");
        ArrecadacaoCredito arrecadacaoCredito = new ArrecadacaoCredito();
        arrecadacaoCredito.setId(finalId);
        arrecadacaoCredito.setTipoOrigemReceita(TipoOrigemReceita.fromValue((Long)item.getIdTipoOrigemReceita()));
        arrecadacaoCredito.setTipoArrecadacao(TipoArrecadacao.fromValue((Long)item.getIdTipoArrecadacao()));
        arrecadacaoCredito.setNrAnoArrecadacao(this.nrAnoArrecadacao);
        arrecadacaoCredito.setNrArrecadacao(Long.valueOf(this.ultimoNrArrecadacao.getAndIncrement()));
        arrecadacaoCredito.setValorArrecadacao(item.getVlArrecadacao());
        LOGGER.info("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Gerando novo registro -> {} ({}/{})", new Object[]{finalId, arrecadacaoCredito.getNrArrecadacao(), arrecadacaoCredito.getNrAnoArrecadacao()});
        this.arrecadacaoCreditoRepository.saveAndFlush((Object)arrecadacaoCredito);
        if (item.getIdCreditoContribuinteItem() > 0L) {
            ArrecadacaoCreditoCreditoContribuinteId id = new ArrecadacaoCreditoCreditoContribuinteId();
            id.setArrecadacaoCredito((ArrecadacaoCredito)this.entityManager.getReference(ArrecadacaoCredito.class, (Object)finalId));
            id.setCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)item.getIdCreditoContribuinteItem()));
            id.setParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
            return new ArrecadacaoCreditoCreditoContribuinte(id);
        }
        ArrecadacaoCreditoPagamentoId id = new ArrecadacaoCreditoPagamentoId();
        id.setArrecadacaoCredito((ArrecadacaoCredito)this.entityManager.getReference(ArrecadacaoCredito.class, (Object)finalId));
        PagamentoDebitoId pagamentoDebitoId = new PagamentoDebitoId();
        pagamentoDebitoId.setIdPagamentoBoleto(item.getIdPagamentoBloqueto());
        pagamentoDebitoId.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
        id.setPagamentoDebito((PagamentoDebito)this.entityManager.getReference(PagamentoDebito.class, (Object)pagamentoDebitoId));
        return new ArrecadacaoCreditoPagamento(id);
    }

    @OnProcessError
    public void onProcessError(ArrecadacaoCreditoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error("SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - Erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item));
        throw e;
    }

    @Generated
    public ArrecadacaoCreditoBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, ArrecadacaoCreditoRepository arrecadacaoCreditoRepository) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.arrecadacaoCreditoRepository = arrecadacaoCreditoRepository;
    }
}

