/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.simam.LancamentoCredito;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoDTO;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoRepository;
import java.time.LocalDate;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LancamentoCreditoService
extends CrudService<LancamentoCredito, Long> {
    private final EntidadeRepository entidadeRepository;
    private final LancamentoCreditoRepository lancamentoCreditoRepository;

    public LancamentoCreditoService(EntidadeRepository entidadeRepository, LancamentoCreditoRepository lancamentoCreditoRepository) {
        this.entidadeRepository = entidadeRepository;
        this.lancamentoCreditoRepository = lancamentoCreditoRepository;
    }

    public List<LancamentoCreditoDTO> findLancamentoCredito(Long idEntidade, LocalDate dataInicial, LocalDate dataFinal) {
        Entidade entidade = (Entidade)this.entidadeRepository.findById((Object)idEntidade).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar a entidade com id %d", idEntidade)));
        return this.lancamentoCreditoRepository.findLancamentos(Long.valueOf(entidade.getIdentificacaoTce()), dataInicial, dataFinal);
    }

    @Transactional
    public void atualizaValorFinal(LocalDate dataInicial, LocalDate dataFinal) {
        this.lancamentoCreditoRepository.atualizaValorFinal(dataInicial, dataFinal);
    }
}

