/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.hibernatesearch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.hibernatesearch.HibernateSearchLock;
import br.com.elotech.tributos.enums.hibernatesearch.StatusHibernateSearchIndexed;
import br.com.elotech.tributos.enums.hibernatesearch.TipoCadastroIndexacao;
import br.com.elotech.tributos.hibernatesearch.dto.IndexacaoHibernateSearchDTO;
import br.com.elotech.tributos.repository.hibernatesearch.HibernateSearchLockRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HibernateSearchLockService {
    private final HibernateSearchLockRepository hibernateSearchLockRepository;

    public HibernateSearchLockService(HibernateSearchLockRepository hibernateSearchLockRepository) {
        this.hibernateSearchLockRepository = hibernateSearchLockRepository;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void startIndexedFromTipoCadastro(TipoCadastroIndexacao tipoCadastro) {
        List<TipoCadastroIndexacao> tiposCadastro = Arrays.asList(tipoCadastro, TipoCadastroIndexacao.TODOS);
        if (Boolean.TRUE.equals(this.hibernateSearchLockRepository.existsByStatusAndTipoIn(StatusHibernateSearchIndexed.EXECUTANDO, tiposCadastro))) {
            throw new EloValidationException(String.format("A indexa\u00e7\u00e3o para o tipo de cadastro %s, j\u00e1 est\u00e1 em execu\u00e7\u00e3o!", tipoCadastro.getDescricao()));
        }
        HibernateSearchLock hibernateSearchLock = new HibernateSearchLock();
        hibernateSearchLock.setUsuario(SecurityUtils.getUserName());
        hibernateSearchLock.setIdUsuario(SecurityUtils.getUserId());
        hibernateSearchLock.setTipo(tipoCadastro);
        this.hibernateSearchLockRepository.save((Object)hibernateSearchLock);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateStatusHibernateSearchFromTipoCadastro(IndexacaoHibernateSearchDTO indexacaoHibernateSearch) {
        TipoCadastroIndexacao tipoCadastro = indexacaoHibernateSearch.getTipoCadastro();
        HibernateSearchLock hibernateSearchLock = (HibernateSearchLock)this.hibernateSearchLockRepository.findFirstByTipoAndStatusAndDataFimIsNullOrderByDataInicioDesc(tipoCadastro, StatusHibernateSearchIndexed.EXECUTANDO).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o existe processo do hibernate search referente ao tipo de cadastro %s!", tipoCadastro.getDescricao())));
        hibernateSearchLock.setStatus(indexacaoHibernateSearch.getStatus());
        hibernateSearchLock.setDataFim(LocalDateTime.now());
        hibernateSearchLock.setMensagemErro(indexacaoHibernateSearch.getMessageError());
        hibernateSearchLock.setTotalProcessados(indexacaoHibernateSearch.getIndexed());
        hibernateSearchLock.setTotalRegistros(indexacaoHibernateSearch.getTotal());
        this.hibernateSearchLockRepository.save((Object)hibernateSearchLock);
    }
}

