/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ModeloArquivo;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.repository.ContaBancariaRepository;
import br.com.elotech.tributos.repository.ConvenioRepository;
import br.com.elotech.tributos.repository.ModeloArquivoRepository;
import br.com.elotech.tributos.service.exception.ConvenioNaoSuportaRegistroOnlineException;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ConvenioService
extends CrudService<Convenio, Long> {
    private final ContaBancariaRepository contaBancariaRepository;
    private final ModeloArquivoRepository modeloArquivoRepository;
    private final ConvenioRepository convenioRepository;

    public ConvenioService(ContaBancariaRepository contaBancariaRepository, ModeloArquivoRepository modeloArquivoRepository, ConvenioRepository convenioRepository) {
        this.contaBancariaRepository = contaBancariaRepository;
        this.modeloArquivoRepository = modeloArquivoRepository;
        this.convenioRepository = convenioRepository;
    }

    private void validateRegistraBoletoOnline(Convenio convenio) {
        if (convenio.getBanco() == null || convenio.getRegistraBoletoOnline() == null) {
            return;
        }
        List<Long> bancos = Arrays.asList(Banco.CODIGO_BANCO_BRASIL, Banco.CODIGO_BRADESCO, Banco.CODIGO_CAIXA_ECONOMICA);
        if (convenio.getRegistraBoletoOnline().booleanValue() && !bancos.contains(convenio.getBanco().getId())) {
            throw new ConvenioNaoSuportaRegistroOnlineException();
        }
    }

    private void validateCarteira(Convenio convenio) {
        TipoCodigoBarras tipoCodigoBarras = convenio.getTipoCodigoBarras();
        if (tipoCodigoBarras == null) {
            return;
        }
        if (tipoCodigoBarras.equals((Object)TipoCodigoBarras.BOLETO_BANCARIO_BB_CONVENIO_7_POSICOES) && convenio.getCarteira() == null) {
            throw new IllegalArgumentException("A carteira \u00e9 obrigat\u00f3ria para este tipo de c\u00f3digo de barras.");
        }
    }

    private void reloadContaBancaria(Convenio convenio) {
        if (convenio.getContaBancaria() != null && convenio.getContaBancaria().getId() != null) {
            convenio.setContaBancaria((ContaBancaria)this.contaBancariaRepository.findOne((Object)convenio.getContaBancaria().getId()));
        }
    }

    private void reloadModelosArquivos(Convenio convenio) {
        if (convenio.getModeloArquivoEnvio() != null && convenio.getModeloArquivoEnvio().getId() != null) {
            convenio.setModeloArquivoEnvio((ModeloArquivo)this.modeloArquivoRepository.findOne((Object)convenio.getModeloArquivoEnvio().getId()));
        }
        if (convenio.getModeloArquivoRetorno() != null && convenio.getModeloArquivoRetorno().getId() != null) {
            convenio.setModeloArquivoRetorno((ModeloArquivo)this.modeloArquivoRepository.findOne((Object)convenio.getModeloArquivoRetorno().getId()));
        }
    }

    protected void beforeSave(Convenio entity, Authentication authentication) {
        this.reloadContaBancaria(entity);
        this.reloadModelosArquivos(entity);
        this.validateCarteira(entity);
        this.validateRegistraBoletoOnline(entity);
        super.beforeSave((EloEntity)entity, authentication);
    }

    public Convenio findByEntidadeAndNumeroConvenioAndBancoId(Long entidade, String numeroConvenio, Long idBanco) {
        return this.convenioRepository.findByEntidadeAndNumeroConvenioAndBancoId(entidade, numeroConvenio, idBanco);
    }
}

