/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.repository.CarneRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.GeraBoletoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CarneService
extends ReadOnlyService<Carne, CarneId> {
    private final CarneRepository carneRepository;
    private final DebitoParcelaService debitoParcelaService;
    private final GeraBoletoService geraBoletoService;

    public CarneService(CarneRepository carneRepository, GeraBoletoService geraBoletoService, DebitoParcelaService debitoParcelaService) {
        this.carneRepository = carneRepository;
        this.geraBoletoService = geraBoletoService;
        this.debitoParcelaService = debitoParcelaService;
    }

    @Transactional
    public CarneDTO geraCarne(DebitoCarneDTO debitoCarne) {
        List parcelas = this.debitoParcelaService.findByDebitoAndAberto(debitoCarne.getEntidade(), debitoCarne.getExercicio(), debitoCarne.getTipoCadastro(), debitoCarne.getCadastroGeral(), debitoCarne.getDivida(), debitoCarne.getSubDivida());
        Assert.assertFalse((String)"N\u00e3o foram encontrados os d\u00e9bitos para a gera\u00e7\u00e3o do carn\u00ea", (boolean)parcelas.isEmpty());
        Carne carneSavedSemNumero = this.save(debitoCarne.toEntity());
        debitoCarne.getFormasPagamento().forEach(formaPagamento -> {
            ArrayList<DebitoParcelaDTO> debitosBoletoFormaPagamento = new ArrayList<DebitoParcelaDTO>();
            for (DebitoParcela debitoParcela : parcelas) {
                if (formaPagamento.getTipoFormaPagamento().equals(TipoFormaPagamento.PARCELADO.getValue()) && !this.isFormaPagamentoParceladoAndNaoVencido(formaPagamento.getTipoFormaPagamento(), debitoParcela)) continue;
                DebitoParcelaDTO debitoParcelaDTO = DebitoParcelaDTO.convertBoleto((DebitoParcela)debitoParcela, (Long)debitoCarne.getIdDebito());
                debitosBoletoFormaPagamento.add(debitoParcelaDTO);
            }
            this.geraBoletoEAdicionaNoCarne(carneSavedSemNumero, debitosBoletoFormaPagamento, formaPagamento.getFormaPagamento(), formaPagamento.getTipoFormaPagamento(), Boolean.TRUE);
        });
        this.getEm().flush();
        return CarneDTO.fromWithBoletos((Carne)this.save(carneSavedSemNumero));
    }

    private boolean isFormaPagamentoParceladoAndNaoVencido(String tipoFormaPagamento, DebitoParcela debitoParcela) {
        return TipoFormaPagamento.PARCELADO.getValue().equals(tipoFormaPagamento) && LocalDate.now().compareTo(debitoParcela.getDataVencimento()) <= 0;
    }

    private void geraBoletoEAdicionaNoCarne(Carne carne, List<DebitoParcelaDTO> debitosBoleto, Long formaPagamento, String tipoFormaPagamento, Boolean somenteDebitosConstituidos) {
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.fromValue((String)tipoFormaPagamento));
        geraBoletoDTO.setDebitos(debitosBoleto);
        geraBoletoDTO.setExercicio(carne.getId().getExercicio());
        geraBoletoDTO.setImpressaoCarne(Boolean.TRUE);
        this.geraBoletoService.geraBoleto(geraBoletoDTO, formaPagamento, somenteDebitosConstituidos).forEach(arg_0 -> ((Carne)carne).addBoleto(arg_0));
    }

    private Carne save(Carne carne) {
        if (Objects.isNull(carne.getData())) {
            carne.setData(LocalDate.now());
        }
        if (Objects.isNull(carne.getUsuario())) {
            carne.setUsuario(SecurityUtils.getUserAise());
        }
        if (Objects.isNull(carne.getNumero()) && Objects.nonNull(carne.getId().getCarne())) {
            carne.setNumero(carne.getId().getCarne());
        }
        if (Objects.isNull(carne.getCodigoBarras()) && Objects.nonNull(carne.getId().getCarne())) {
            carne.setCodigoBarras(String.format("%02d%04d%08d", carne.getId().getEntidade(), carne.getId().getExercicio(), carne.getId().getCarne()));
        }
        return (Carne)this.carneRepository.save((Object)carne);
    }

    @Transactional
    public CarneDTO geraCarnePorFormaPagamento(DebitoAgrupadoPorFormaPagamentoDTO params) {
        DebitoCarneDTO debitoCarneDTO = new DebitoCarneDTO();
        debitoCarneDTO.setIdDebito(params.getIdDebito());
        debitoCarneDTO.setEntidade(params.getEntidade());
        debitoCarneDTO.setExercicio(params.getExercicio());
        debitoCarneDTO.setTipoCadastro(params.getTipoCadastro());
        debitoCarneDTO.setCadastroGeral(params.getCadastroGeral());
        debitoCarneDTO.setDivida(params.getDivida());
        debitoCarneDTO.setSubDivida(params.getSubDivida());
        debitoCarneDTO.setFormasPagamento(Collections.singletonList(params));
        return this.geraCarne(debitoCarneDTO);
    }

    @Transactional
    public CarneDTO geraCarneCalculo(CalculoCadastro calculoCadastro, Long calculoLoteImpressaoOrdem) {
        Debito debito = calculoCadastro.getDebito();
        Carne carneSavedSemNumero = this.save(this.createCarne(debito, calculoCadastro.getCalculo().getExercicio()));
        calculoCadastro.getCalculo().getFormasPagamento().stream().filter(calculoFormasPagamento -> calculoFormasPagamento.getDividaFormaPagamento().getDivida().equals((Object)debito.getDivida())).sorted(Comparator.comparing(calculoFormasPagamento -> calculoFormasPagamento.getDividaFormaPagamento().getFormaPagamento().getOrdemEmissao(), Comparator.nullsLast(Comparator.naturalOrder()))).forEach(calculoFormaPagamento -> {
            FormaPagamento formaPagamento = calculoFormaPagamento.getDividaFormaPagamento().getFormaPagamento();
            ArrayList<DebitoParcelaDTO> debitosBoletoFormaPagamento = new ArrayList<DebitoParcelaDTO>();
            for (DebitoParcela debitoParcela : debito.getParcelas()) {
                if (!debitoParcela.getSituacaoDebito().isAberto().booleanValue() || formaPagamento.getTipoFormaPagamento().equals((Object)TipoFormaPagamento.PARCELADO) && !this.validaFormaPagamentoAndParcela(formaPagamento, debitoParcela, calculoFormaPagamento.getQuantidadeParcelas())) continue;
                DebitoParcelaDTO debitoParcelaDTO = DebitoParcelaDTO.convertBoleto((DebitoParcela)debitoParcela, (Long)debito.getId());
                debitosBoletoFormaPagamento.add(debitoParcelaDTO);
            }
            if (!debitosBoletoFormaPagamento.isEmpty()) {
                this.geraBoletoEAdicionaNoCarne(carneSavedSemNumero, debitosBoletoFormaPagamento, formaPagamento.getId(), formaPagamento.getTipoFormaPagamento().getValue(), Boolean.FALSE);
            }
        });
        if (carneSavedSemNumero.getBoletos().isEmpty()) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel gerar o carn\u00ea do lote: %d, cadastro: %d - %d. Verifique a situa\u00e7\u00e3o das parcelas do d\u00e9bito e as formas de pagamento configuradas.", calculoLoteImpressaoOrdem, calculoCadastro.getCadastro().getTipoCadastro().getValue(), calculoCadastro.getCadastro().getCadastroGeral()));
        }
        return CarneDTO.from((Carne)this.save(carneSavedSemNumero));
    }

    private boolean validaFormaPagamentoAndParcela(FormaPagamento formaPagamento, DebitoParcela debitoParcela, Long quantidadeParcelas) {
        return TipoFormaPagamento.PARCELADO.equals((Object)formaPagamento.getTipoFormaPagamento()) && LocalDate.now().compareTo(debitoParcela.getDataVencimento()) <= 0 && (Objects.isNull(quantidadeParcelas) || debitoParcela.getId().getParcela() <= quantidadeParcelas);
    }

    private Carne createCarne(Debito debito, Long exercicioCarne) {
        CarneId id = new CarneId();
        id.setEntidade(debito.getEntidade());
        id.setExercicio(exercicioCarne);
        Carne carne = new Carne();
        carne.setId(id);
        carne.setTipoCadastro(debito.getTipoCadastro());
        carne.setCadastroGeral(debito.getCadastroGeralId());
        return carne;
    }

    public void deleteCarne(Long entidade, Long exercicio, Long numeroCarne) {
        CarneId carneId = new CarneId(entidade, exercicio, numeroCarne);
        Carne carne = (Carne)this.carneRepository.findById((Object)carneId).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o encontrado carne %d no exercicio %d para entidade %d.", numeroCarne, exercicio, entidade)));
        this.carneRepository.delete((Object)carne);
    }
}

